/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import java.util.ArrayList;
import java.util.HashSet;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.security.RealTimeSecLogMoGen;
import se.ericsson.cello.security.StructServerConfigImpl;
import se.ericsson.cello.transaction.Coordinator;

public class RealTimeSecLogMoImpl
extends RealTimeSecLogMoGen {
    public RealTimeSecLogMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public RealTimeSecLogMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void actionAddExternalServer(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getExtServerListConfig(coordinator);
        Struct[] structArray2 = new Struct[structArray.length + 1];
        for (int i = 0; i < structArray.length; ++i) {
            structArray2[i] = structArray[i];
        }
        structArray2[i] = struct;
        this.validateExtServerListConfig(structArray2, null);
        StructParameter structParameter = StructServerConfigImpl.toStructParameter(struct, "RealTimeSecLog", "extServerListConfigElement");
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    public void actionDeleteExternalServer(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getExtServerListConfig(coordinator);
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string2 = (String)struct.getValue("serverName");
            if (!string2.equals(string)) continue;
            bl = true;
            ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
            StringParameter stringParameter = new StringParameter("extServerListConfigElement_serverName", string, 255);
            arrayList.add(stringParameter);
            this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 102, arrayList);
        }
        if (!bl) {
            throw new ActionNotAllowedException("RealTimeSecLog", "ServerName: " + string + " not found.");
        }
    }

    protected void validateExtServerListConfig(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (structArray.length > 2) {
            throw new MaxNumberExceededException("Only 2 external servers are allowed to be configured.", "RealTimeSecLog");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < structArray.length; ++i) {
            RealTimeSecLogMoImpl.checkServerAddress((String)structArray[i].getValue("extServerAddress"));
            String string = (String)structArray[i].getValue("serverName");
            if (hashSet.contains(string)) {
                throw new ValueOutOfRangeException("Duplicate server name " + string + " in " + "extServerListConfig", "RealTimeSecLog");
            }
            hashSet.add(string);
        }
    }

    public static void checkServerAddress(String string) throws MoAccessException {
        int n = string.indexOf("]");
        if (string.equals("")) {
            return;
        }
        if (string.startsWith("[")) {
            int n2 = string.lastIndexOf(":");
            if (n2 == -1 || n2 < n || string.startsWith("[") && n <= 0) {
                throw new IllegalAttributeValueException("Ipv6Address given does not have valid format ", "extServerAddress", "RealTimeSecLog");
            }
            IpAddressValidation.validateServerURL((String)string, (String)"extServerAddress", (String)"RealTimeSecLog");
        } else if (!string.startsWith("[") && Ipv6AddressValidation.isIpv6((String)string)) {
            if (n >= 0) {
                throw new IllegalAttributeValueException("Ipv6Address given does not have valid format ", "extServerAddress", "RealTimeSecLog");
            }
            Ipv6AddressValidation.validateIpv6((String)string);
        } else {
            IpAddressValidation.validateServerURL((String)string, (String)"extServerAddress", (String)"RealTimeSecLog");
        }
    }

    public static void create(ManagedObject managedObject, String string, Coordinator coordinator, FroProxy froProxy, InitialMaoContext initialMaoContext, MaoFroIndicationHandler maoFroIndicationHandler) throws MoCanNotBeCreatedException {
        throw new MoCanNotBeCreatedException("RealTimeSecLog");
    }
}

