/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.nex.NexLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiViewPreferences
implements UserPreferencesI {
    private static final String ADDED_COLUMNS_KEY_PREFIX = "cpp_nex_addedColumns_";
    private static final String SHOW_LDN_KEY = "cpp_nex_showLDN";
    private static final String COLUMN_ORDER_KEY_PREFIX = "cpp_nex_columnorder_";
    private static final String COLUMN_ORDER_LENGTH_KEY_PREFIX = "cpp_nex_columnorderlength_";
    private static final String COLUMN_WIDTH_KEY_PREFIX = "cpp_nex_columnwidth_";
    private static final String DELIMITER = ";";
    private UserPreferencesI userPrefs;
    private String viewName;
    private String tableKey;

    public static String getAddedColumnsKey(String aViewname) {
        return ADDED_COLUMNS_KEY_PREFIX + aViewname + "_";
    }

    public GuiViewPreferences(String nameOfView, UserPreferencesI userPreferences) {
        this.userPrefs = userPreferences;
        this.viewName = nameOfView;
    }

    public boolean getShowLDNFlag() {
        String showLDN = this.userPrefs.getPreference(SHOW_LDN_KEY, "false");
        return String.valueOf(true).equals(showLDN);
    }

    public void updateShowLDNFlag(boolean showLDN) {
        this.userPrefs.setPreference(SHOW_LDN_KEY, "" + showLDN);
    }

    public void removeShowLDNFlag() {
        this.userPrefs.removePreference(SHOW_LDN_KEY);
    }

    public HashMap<String, Integer> getColumnWidthPreference(Collection<String> columns) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String keyPrefix = this.constructColumnWidthKeyPrefix(this.tableKey);
        for (String columnName : columns) {
            try {
                Integer width = new Integer(this.userPrefs.getPreference(keyPrefix + columnName, "0"));
                if (width <= 0) continue;
                result.put(columnName, width);
            }
            catch (Exception e) {
                NexLog.logger().info("Exception while getting preferred size of columns:\n" + NexLog.stackToString(e));
            }
        }
        return result;
    }

    public void setColumnWidthPreference(Map<String, Integer> nameWidths) {
        String prefix = this.constructColumnWidthKeyPrefix(this.tableKey);
        for (Map.Entry<String, Integer> entry : nameWidths.entrySet()) {
            this.userPrefs.setPreference(prefix + entry.getKey(), entry.getValue().toString());
        }
    }

    public void setColumnOrderPreference(List<String> columnNames) {
        String columnOrderKey = COLUMN_ORDER_KEY_PREFIX + this.viewName + this.tableKey;
        String columnOrderLengthKey = COLUMN_ORDER_LENGTH_KEY_PREFIX + this.viewName + this.tableKey;
        StringBuilder columnStringBuilder = new StringBuilder();
        int columnCount = 0;
        Iterator<String> iter = columnNames.iterator();
        while (iter.hasNext()) {
            columnStringBuilder.append(iter.next());
            if (!iter.hasNext()) continue;
            columnStringBuilder.append(',');
        }
        this.userPrefs.setPreference(columnOrderKey, columnStringBuilder.toString());
        this.userPrefs.setPreference(columnOrderLengthKey, Integer.toString(columnCount += columnNames.size()));
    }

    public List<String> getColumnOrderPreference() {
        int length;
        try {
            String pref = this.userPrefs.getPreference(COLUMN_ORDER_LENGTH_KEY_PREFIX + this.viewName + this.tableKey, "0");
            length = Integer.valueOf(pref);
        }
        catch (Exception e) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> columnsArray = new ArrayList<String>(length);
        String columnKey = COLUMN_ORDER_KEY_PREFIX + this.viewName + this.tableKey;
        String columns = this.userPrefs.getPreference(columnKey, "");
        if (!columns.equals("")) {
            StringTokenizer tokens = new StringTokenizer(columns, ",");
            while (tokens.hasMoreTokens()) {
                columnsArray.add(tokens.nextToken());
            }
        }
        return columnsArray;
    }

    public Collection<String> getUserAddedColumnPreference() {
        LinkedList<String> result = new LinkedList<String>();
        String columnsToAdd = this.userPrefs.getPreference(GuiViewPreferences.getAddedColumnsKey(this.viewName), "NONE");
        if (!columnsToAdd.equals("NONE")) {
            StringTokenizer tokenizer = new StringTokenizer(columnsToAdd, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
        }
        NexLog.logger().fine("getUserAddedColumns returning " + result.toString());
        return result;
    }

    public void setUserColumnsPreference(Collection<String> columnNamesAddedByUser) {
        StringBuilder addedColumns = new StringBuilder();
        for (String columnName : columnNamesAddedByUser) {
            addedColumns.append(columnName);
            addedColumns.append(DELIMITER);
        }
        if (addedColumns.length() > 0) {
            this.userPrefs.setPreference(GuiViewPreferences.getAddedColumnsKey(this.viewName), addedColumns.toString());
        } else {
            this.userPrefs.removePreference(GuiViewPreferences.getAddedColumnsKey(this.viewName));
        }
    }

    public void destroy() {
        String destroyedName;
        this.viewName = destroyedName = "Destroyed view " + this.viewName;
        this.userPrefs = new UserPreferencesI(){
            private final Throwable destroyStack = new Throwable("Stackdump from destroy");

            public String getPreference(String key, String defaultValue) {
                NexLog.logger().log(Level.FINE, "STRANGE! getPreference(" + key + "...) called on destyroyed object!", this.destroyStack);
                NexLog.logger().log(Level.FINE, "STRANGE! getPreference(" + key + "...) called on destyroyed object!", new Throwable("Stack dump from late call: "));
                return null;
            }

            public void setPreference(String key, String value) {
                NexLog.logger().log(Level.FINE, "STRANGE! setPreference(" + key + "...) called on destyroyed object!", this.destroyStack);
                NexLog.logger().log(Level.FINE, "STRANGE! setPreference(" + key + "...) called on destyroyed object!", new Throwable("Stack dump from late call: "));
            }

            public void removePreference(String preferenceKey) {
                NexLog.logger().log(Level.FINE, "STRANGE! removePreference(" + preferenceKey + ") called on destyroyed object!", this.destroyStack);
                NexLog.logger().log(Level.FINE, "STRANGE! removePreference(" + preferenceKey + ") called on destyroyed object!", new Throwable("Stack dump from late call: "));
            }
        };
    }

    public String getPreference(String key, String defaultValue) {
        return this.userPrefs.getPreference(key, defaultValue);
    }

    public void removePreference(String preferenceKey) {
        this.userPrefs.removePreference(preferenceKey);
    }

    public void setPreference(String key, String value) {
        this.userPrefs.setPreference(key, value);
    }

    private String constructColumnWidthKeyPrefix(String tableKey) {
        StringBuilder construct = new StringBuilder(COLUMN_WIDTH_KEY_PREFIX);
        construct.append(this.viewName);
        construct.append(tableKey);
        return construct.toString();
    }

    public void setStandardAttributes(Collection<String> defaultAttributeList) {
        TreeSet<String> sortedDefaultAttributes = new TreeSet<String>();
        sortedDefaultAttributes.addAll(defaultAttributeList);
        StringBuilder builder = new StringBuilder();
        for (String attribute : sortedDefaultAttributes) {
            builder.append(attribute);
        }
        this.tableKey = builder.toString();
    }
}

