/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Properties;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import se.ericsson.cello.nex.MessengerI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewI;

public class TableMouseListener
implements MouseListener {
    private ViewI myView;
    private ToolServicesI myToolServicesI;
    private MessengerI myMessenger;
    private JTable myTable;
    private JPopupMenu myPopUp;
    private JMenuItem myOpenMoPropMenuItem;
    private Point myCurrentPoint = new Point(0, 0);

    public TableMouseListener(JTable table, MessengerI messenger, ToolServicesI toolServicesI, ViewI guiView) {
        this.myMessenger = messenger;
        this.myTable = table;
        this.myToolServicesI = toolServicesI;
        this.myView = guiView;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.myMessenger.setStatusMessage("");
        this.popUp(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.popUp(e);
    }

    private void popUp(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (null == this.myPopUp) {
                this.myPopUp = this.createPopUpMenu();
            }
            this.myCurrentPoint = e.getPoint();
            this.enableOrDisableMenuItems(e);
            this.myPopUp.show(e.getComponent(), e.getX(), e.getY());
            int row = this.myTable.rowAtPoint(this.myCurrentPoint);
            this.myTable.setRowSelectionInterval(row, row);
        }
    }

    private void enableOrDisableMenuItems(MouseEvent e) {
        NexLog.logger().entering("TableMouseListener", "enableOrDisableMenuItems(MouseEvent e)", e);
        int row = this.myTable.rowAtPoint(this.myCurrentPoint);
        int column = this.myTable.columnAtPoint(this.myCurrentPoint);
        String cellContents = this.myTable.getValueAt(row, column).toString();
        String cellStringValue = cellContents.toString();
        if ("Not Applicable".equalsIgnoreCase(cellStringValue)) {
            this.myOpenMoPropMenuItem.setVisible(false);
        } else if (cellStringValue.indexOf("[") == 0 && cellStringValue.lastIndexOf("]") < cellStringValue.length() - 1) {
            this.myOpenMoPropMenuItem.setVisible(false);
        } else {
            this.myOpenMoPropMenuItem.setVisible(true);
        }
        NexLog.logger().exiting("TableMouseListener", "enableOrDisableMenuItems(MouseEvent e)");
    }

    private JPopupMenu createPopUpMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem copyMenuItem = new JMenuItem("Copy Table Cell Contents");
        copyMenuItem.setToolTipText("Copy the table cell contents to the clipboard");
        copyMenuItem.setName("copyCellContentsMenuItem");
        copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableMouseListener.this.copy();
            }
        });
        this.myOpenMoPropMenuItem = new JMenuItem("Open Table Cell");
        this.myOpenMoPropMenuItem.setToolTipText("Open MO Properties with this attribute");
        this.myOpenMoPropMenuItem.setName("openCellAttibuteMenu");
        this.myOpenMoPropMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableMouseListener.this.openMoProperties();
            }
        });
        menu.add(copyMenuItem);
        menu.add(this.myOpenMoPropMenuItem);
        return menu;
    }

    private void copy() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int row = this.myTable.rowAtPoint(this.myCurrentPoint);
            int column = this.myTable.columnAtPoint(this.myCurrentPoint);
            StringSelection contents = new StringSelection(this.myTable.getValueAt(row, column).toString());
            clipboard.setContents(contents, null);
        }
        catch (Exception x) {
            NexLog.logger().warning("Cannot access clipboard\n" + x);
        }
    }

    private void openMoProperties() {
        NexLog.logger().entering(this.getClass().getName(), "openMoProperties()");
        Properties props = this.myToolServicesI.getConfiguration().getSupersedingProperties();
        String selLDN = this.myView.getSelectedLDN();
        props.put("LDNs", selLDN);
        props.put("EXPAND_STRUCTS", "yes");
        props.put("EXPAND_SEQUENCES", "yes");
        String selAttribute = this.myTable.getColumnName(this.myTable.columnAtPoint(this.myCurrentPoint));
        int pointPlace = selAttribute.indexOf(".");
        if (pointPlace > -1) {
            selAttribute = selAttribute.substring(0, pointPlace);
        }
        props.put("SELECTED_ATTRIBUTES", selAttribute);
        try {
            this.myToolServicesI.startHyperTool("MO Properties", props);
        }
        catch (Exception ex) {
            NexLog.logger().warning("Was not able to launch the tool .MO Properties\n" + ex.getMessage());
            this.myMessenger.setMessage("Failed to start the tool MO Properties", ex, false);
        }
    }
}

