/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.AddChildrenJob;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandRecursivelyWorker
extends ModelWorker<Void, AddChildrenJob> {
    private NexTreeNode root;
    private ModelCallback<Collection<TreePath>> callback;
    private LinkedList<TreePath> paths = new LinkedList();
    private int depth;

    public ExpandRecursivelyWorker(MoTreeTableModel model, NexTreeNode root, int depth, ModelCallback<Collection<TreePath>> callback) {
        super(model);
        this.root = root;
        this.callback = callback;
        this.depth = depth;
    }

    @Override
    protected Void doWork() throws Exception {
        this.expandNode(this.root, this.depth);
        return null;
    }

    private void expandNode(NexTreeNode node, int depth) throws Exception {
        if (!this.isCancelled() && depth > 0) {
            List<NexTreeNode> children = this.createChildNodesFor(node);
            Collections.sort(children);
            this.publish(new AddChildrenJob[]{new AddChildrenJob(node, children)});
            for (NexTreeNode child : children) {
                this.expandNode(child, depth - 1);
            }
        }
    }

    protected void process(List<AddChildrenJob> jobs) {
        for (AddChildrenJob job : jobs) {
            this.replaceAllChildren(job.getParent(), job.getChildren());
            this.paths.add(new TreePath(job.getParent().getPath()));
        }
    }

    protected void done() {
        block4: {
            try {
                this.get();
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in ExpandRecursivelyWorker.done() \n" + NexLog.stackToString(e));
                if (this.callback == null) break block4;
                this.callback.setException(e);
            }
        }
        if (this.callback != null) {
            this.callback.run(this.paths, this.isCancelled());
        }
    }

    public String toString() {
        return "Expanding nodes below " + this.root.getLongName() + " recursively.";
    }
}

