/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.viewservices.model.ChPaAttrData;
import se.ericsson.cello.nex.viewservices.model.MoHolder;
import se.ericsson.cello.nex.viewservices.model.Query;
import se.ericsson.cello.nex.viewservices.model.TreeNodeObjectHelperI;
import se.ericsson.cello.nex.viewservices.model.ViewElementDataI;
import se.ericsson.cello.nex.viewservices.utils.MoClassResolver;
import se.ericsson.cello.nex.viewservices.utils.UndefinedTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeObjectHelper
implements TreeNodeObjectHelperI {
    private NodeServices nodeServ;

    public TreeNodeObjectHelper(NodeServices nodeServ) {
        this.nodeServ = nodeServ;
    }

    @Override
    public List<MoHolder> getSubMoHoldersAsChildren(MimModel mim, Mo mo, boolean checkChildren, ViewElementDataI viewElementData) throws Exception {
        ArrayList<String> moClasses;
        NexLog.logger().fine("MO Type: " + viewElementData.getMoType());
        if (viewElementData.getMoType().equals("")) {
            return this.getSubMoHoldersAsContainment(mim, mo, checkChildren);
        }
        ArrayList<MoHolder> returnList = new ArrayList<MoHolder>();
        try {
            moClasses = MoClassResolver.resolveChildrenMoClasses(mim, viewElementData.getMoType(), mo.getType());
        }
        catch (UndefinedTypeException e) {
            NexLog.logger().log(Level.INFO, e.getMessage());
            return returnList;
        }
        for (String moClass : moClasses) {
            this.getChildrenMoHolders(mim, mo, checkChildren, returnList, moClass);
        }
        return returnList;
    }

    @Override
    public List<MoHolder> getSubMoHoldersAsContainment(MimModel mim, Mo mo, boolean checkChildren) throws Exception {
        NexLog.logger().fine("getSubMoHoldersAsContainment for " + mo.getLdn());
        ArrayList<MoHolder> returnList = new ArrayList<MoHolder>(0);
        this.getChildrenMoHolders(mim, mo, checkChildren, returnList, "");
        return returnList;
    }

    @Override
    public List<Mo> getSubMOsAsReferences(MimModel mim, Mo mo, ViewElementDataI viewElementData) throws Exception {
        List<Mo> moList = new ArrayList<Mo>();
        NameValue references = null;
        ArrayList<String> moClasses = new ArrayList();
        boolean allMoTypes = false;
        try {
            if (viewElementData.getMoType().equals("")) {
                allMoTypes = true;
            } else {
                moClasses = MoClassResolver.resolveMoClass(mim, viewElementData.getMoType());
            }
            if (System.getProperty("ARTH", "false").equals("true")) {
                mo = this.nodeServ.getNode().getCmService().getMo(mo.getLdn());
            }
            references = mo.getAttribute(viewElementData.getReferencingAttribute(), null);
        }
        catch (Exception e) {
            if (e.toString().indexOf("org.omg.CORBA") > -1) {
                NexLog.logger().log(Level.WARNING, "Could not get MOs referenced from " + mo.getLdn() + "  Probably lost contact with the node.     " + e.toString());
                throw e;
            }
            NexLog.logger().log(Level.INFO, "Could not get MOs referenced from " + mo.getLdn() + "  The MO might no longer exist.     " + e.toString());
            return moList;
        }
        Mo[] moRefs = null;
        if (references.getType() == 12) {
            moRefs = new Mo[]{references.getMoValue()};
        } else if (references.getType() == 13 && references.getArrayType() == 12) {
            moRefs = references.getMoArrayValue();
        } else {
            NexLog.logger().log(Level.WARNING, "Unsupported attribute type: " + references.getType() + " for attribute " + references.getName());
        }
        if (moRefs != null) {
            moList = this.storeMoArrayInList(moRefs);
        }
        if (allMoTypes) {
            return moList;
        }
        return this.getMatchingMoRefs(moClasses, moList);
    }

    @Override
    public List<Mo> getSubMOsAsParent(Mo mo, ViewElementDataI viewElementData) throws Exception {
        ArrayList<Mo> returnList = new ArrayList<Mo>(1);
        try {
            if (!mo.getLdn().equals("ManagedElement=1")) {
                Mo parent = mo.getParent(null);
                returnList.add(parent);
            }
        }
        catch (Exception e) {
            if (e.toString().indexOf("org.omg.CORBA") > -1) {
                NexLog.logger().log(Level.WARNING, "Could not get parent of " + mo.getLdn() + "  Probably lost contact with the node.     " + e.toString());
                throw e;
            }
            NexLog.logger().log(Level.INFO, "Could not get children of " + mo.getLdn() + "  The MO might no longer exist.     " + e.toString());
        }
        return returnList;
    }

    @Override
    public List<Mo> getSubMOsAsMO(NodeServices nodeServ, MimModel mim, Mo mo, ViewElementDataI viewElementData) throws Exception {
        NexLog.logger().fine("mo: " + mo.getLdn());
        ArrayList<Mo> returnList = new ArrayList<Mo>();
        Collection<Query> queries = viewElementData.getQueries();
        for (Query qu : queries) {
            ArrayList<Object> moClasses;
            block6: {
                NexLog.logger().fine("search expression: " + qu.getSearchExpression());
                String anMoClassExp = qu.getMoClass();
                NexLog.logger().fine("query MO class: " + anMoClassExp);
                moClasses = new ArrayList<String>();
                if (MoClassResolver.isRegExp(anMoClassExp)) {
                    try {
                        moClasses = MoClassResolver.resolveMoClassesBelow(mim, anMoClassExp, mo.getType());
                        break block6;
                    }
                    catch (UndefinedTypeException e) {
                        NexLog.logger().fine("UndefinedTypeException when resolving MO classes from " + anMoClassExp);
                        continue;
                    }
                }
                if (MoClassResolver.isMoSpecifiedInMom(mim, anMoClassExp)) {
                    moClasses.add(anMoClassExp);
                } else {
                    NexLog.logger().fine("MO class " + anMoClassExp + " is ignored. Exists in view but not in MOM");
                    continue;
                }
            }
            NexLog.logger().fine("Found " + moClasses.size() + " MO classes");
            String aSearchExp = qu.getSearchExpression();
            this.searchForSubMosOfClasses(nodeServ, mim, mo, returnList, qu, moClasses, aSearchExp);
        }
        NexLog.logger().fine("returning a list with " + returnList.size());
        return returnList;
    }

    @Override
    public List<Mo> getSubMOsAsFolder(Mo mo, ViewElementDataI viewElementData) {
        ArrayList<Mo> returnList = new ArrayList<Mo>();
        returnList.add(mo);
        return returnList;
    }

    @Override
    public void getNameValuesFromNode(Mo mo, ArrayList<String> attributesToFetch, ArrayList<NameValue> nameValueArrayToFill) {
        try {
            NameValue[] nameValuesFromNode = mo.getAttributes(attributesToFetch.toArray(new String[0]), null);
            for (int i = 0; i < nameValuesFromNode.length; ++i) {
                nameValueArrayToFill.add(nameValuesFromNode[i]);
            }
        }
        catch (Exception exe) {
            NexLog.logger().info("Some attribute of " + mo.getLdn() + " could not be fetched\n");
            this.getNameValuesOneByOne(mo, attributesToFetch, nameValueArrayToFill);
        }
    }

    @Override
    public Mo findChildOrParentMoWithAttribute(MimModel mim, Mo mo, String attributeString, Collection<ChPaAttrData> attrDatas) {
        boolean sameMOType = false;
        Mo anMo = mo;
        Transaction tx = null;
        for (ChPaAttrData attrData : attrDatas) {
            ArrayList<String> moClasses;
            try {
                moClasses = MoClassResolver.resolveMoClass(mim, attrData.getMoType());
            }
            catch (UndefinedTypeException e) {
                NexLog.logger().log(Level.INFO, e.getMessage());
                continue;
            }
            try {
                if (attributeString.equalsIgnoreCase(attrData.getParentAttribute())) {
                    for (int x = 0; x < attrData.getScope(); ++x) {
                        if (!moClasses.contains((anMo = anMo.getParent(tx)).getType())) continue;
                        sameMOType = true;
                        break;
                    }
                } else {
                    if (!attributeString.equalsIgnoreCase(attrData.getChildAttribute())) continue;
                    Scope aScope = Scope.ONE_LEVEL;
                    switch (attrData.getScope()) {
                        case 1: {
                            aScope = Scope.ONE_LEVEL;
                            break;
                        }
                        case 2: {
                            aScope = Scope.TWO_LEVELS;
                            break;
                        }
                        case 3: {
                            aScope = Scope.THREE_LEVELS;
                        }
                    }
                    if (1 == moClasses.size()) {
                        Mo[] arr = mo.getChildren(moClasses.get(0), "", aScope, tx);
                        if (arr.length > 0) {
                            anMo = arr[0];
                            sameMOType = true;
                        }
                    } else {
                        for (String aType : moClasses) {
                            Mo[] arr = mo.getChildren(aType, "", aScope, tx);
                            if (arr.length <= 0) continue;
                            anMo = arr[0];
                            sameMOType = true;
                            break;
                        }
                    }
                }
                if (!sameMOType) continue;
                break;
            }
            catch (Exception ee) {
                NexLog.logger().log(Level.INFO, ee.getMessage());
            }
        }
        if (!sameMOType) {
            anMo = null;
        }
        return anMo;
    }

    @Override
    public String resolveEnum(MimModel mim, String attributeName, NameValue nameVal, Mo anMo) {
        MomEntity ent;
        String retString = nameVal.valueToString();
        String motype = anMo.getType();
        MomClass momclass = mim.getClass(motype);
        MomAttribute momAttr = momclass.getAttribute(attributeName);
        if (momAttr != null && (ent = momAttr.getType()) instanceof MomEnumRef) {
            MomEnum anenum = ((MomEnumRef)ent).getEnum();
            Iterator iter = anenum.getMembers();
            while (iter.hasNext()) {
                MomEnumMember en = (MomEnumMember)iter.next();
                if (!en.getValue().equals(nameVal.getValue())) continue;
                retString = en.getName();
                break;
            }
        }
        return retString;
    }

    @Override
    public String getStructMemberValue(String structMemberNameWithOrWithoutAttributeAndDot, String defaultReturnString, NameValue nameVal) {
        int dotPlace = structMemberNameWithOrWithoutAttributeAndDot.indexOf(".");
        String structMemberName = structMemberNameWithOrWithoutAttributeAndDot.substring(dotPlace + 1);
        Struct aStruct = nameVal.getStructValue();
        NameValue structMemberNV = aStruct.getMember(structMemberName);
        if (null != structMemberNV) {
            defaultReturnString = structMemberNV.valueToString();
        }
        return defaultReturnString;
    }

    private void getChildrenMoHolders(MimModel mim, Mo mo, boolean checkChildren, List<MoHolder> returnList, String moClass) throws Exception {
        Scope scope = checkChildren ? Scope.TWO_LEVELS : Scope.ONE_LEVEL;
        try {
            NexLog.logger().fine("getChildrenMoHolders of " + mo.getLdn() + " of type " + moClass + " before call to NEAL");
            Mo[] moArr = mo.getChildren(moClass, "", scope, null);
            NexLog.logger().fine("getChildrenMoHolders of " + mo.getLdn() + " of type " + moClass + " after call to NEAL");
            if (checkChildren) {
                int childLevel = mo.getLdn().split(",").length + 1;
                for (int i = 0; i < moArr.length; ++i) {
                    if (childLevel != moArr[i].getLdn().split(",").length) continue;
                    returnList.add(new MoHolder(moArr[i], this.anyChildInArray(moArr, moArr[i].getLdn()), true));
                }
            } else {
                for (int i = 0; i < moArr.length; ++i) {
                    if (mim.getClass(moArr[i].getType()) == null) continue;
                    returnList.add(new MoHolder(moArr[i], true, true));
                }
            }
        }
        catch (Exception e) {
            if (e.toString().indexOf("org.omg.CORBA") > -1) {
                NexLog.logger().log(Level.WARNING, "Could not get children of " + mo.getLdn() + " of class " + moClass + "  Probably lost contact with the node.     " + e.toString());
                throw e;
            }
            NexLog.logger().log(Level.INFO, "Could not get children of " + mo.getLdn() + " of class " + moClass + "  The MO might no longer exist.     " + e.toString());
        }
    }

    private void searchForSubMosOfClasses(NodeServices nodeServ, MimModel mim, Mo mo, List<Mo> returnList, Query qu, ArrayList<String> moClasses, String aSearchExp) throws Exception {
        for (String aClass : moClasses) {
            if (aSearchExp.length() > 3 && !MoClassResolver.hasMoAttributes(mim, aClass, qu.getAttributes())) {
                NexLog.logger().fine("No attributes found in " + aClass + " for " + aSearchExp);
                continue;
            }
            Mo searchRootMo = null;
            boolean searchRootDefinedInViewFile = false;
            try {
                searchRootMo = this.getSearchRootMo(nodeServ, qu);
                if (searchRootMo == null) {
                    searchRootMo = mo;
                } else {
                    searchRootDefinedInViewFile = true;
                }
                NexLog.logger().fine("Will search below " + searchRootMo.getLdn() + " for " + aClass + " with search expression " + qu.getSearchExpression() + "  with scope " + qu.getSearchScope());
                Mo[] mos = searchRootMo.getChildren(aClass, qu.getSearchExpression(), qu.getSearchScope(), null);
                NexLog.logger().fine("Found mos " + mos.length);
                for (Mo anMo : mos) {
                    returnList.add(anMo);
                }
            }
            catch (Exception e) {
                StringBuilder mess = new StringBuilder();
                mess.append("searchRoot: ");
                mess.append(searchRootMo);
                mess.append(" Search expression: ");
                mess.append(qu.getSearchExpression());
                mess.append(" Search scope: ");
                mess.append(qu.getSearchScope());
                mess.append("\n");
                mess.append(e.toString());
                if (searchRootDefinedInViewFile) {
                    mess.insert(0, "Can not get children MOs for the MO that was specified as searchRoot in the view file.\n");
                } else {
                    mess.insert(0, "Can not get children MOs. Possible reasons: The search root MO no longer exists. We have lost contact with the node.\n");
                }
                if (e.toString().indexOf("org.omg.CORBA") > -1) {
                    NexLog.logger().warning(mess.toString());
                    throw e;
                }
                NexLog.logger().info(mess.toString());
            }
        }
    }

    private Mo getSearchRootMo(NodeServices nodeServ, Query aQuery) {
        Mo searchRootMo = null;
        String sRootLdn = aQuery.getSearchRoot();
        if (sRootLdn != null && sRootLdn.length() > 0) {
            searchRootMo = nodeServ.getNode().getCmService().getMo(sRootLdn);
        }
        return searchRootMo;
    }

    private List<Mo> getMatchingMoRefs(ArrayList<String> moClasses, List<Mo> moRefs) {
        ArrayList<Mo> matches = new ArrayList<Mo>(moClasses.size());
        if (moClasses.isEmpty()) {
            return matches;
        }
        for (Mo anMo : moRefs) {
            if (!moClasses.contains(anMo.getType())) continue;
            matches.add(anMo);
        }
        return matches;
    }

    private void getNameValuesOneByOne(Mo mo, ArrayList<String> attributesToFetch, ArrayList<NameValue> nameValueArrayToFill) {
        for (String attr : attributesToFetch) {
            try {
                nameValueArrayToFill.add(mo.getAttribute(attr, null));
            }
            catch (Exception e2) {
                NexLog.logger().info("The attribute " + attr + " could not be fetched\n" + NexLog.stackToString(e2));
            }
        }
    }

    private boolean anyChildInArray(Mo[] moArr, String ldn) {
        StringBuilder cmpString = new StringBuilder(ldn).append(",");
        for (int i = 0; i < moArr.length; ++i) {
            if (!moArr[i].getLdn().startsWith(cmpString.toString())) continue;
            return true;
        }
        return false;
    }

    private List<Mo> storeMoArrayInList(Mo[] arr) {
        ArrayList<Mo> retList = new ArrayList<Mo>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            retList.add(arr[i]);
        }
        return retList;
    }
}

