/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.viewservices.utils.UndefinedTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoClassResolver {
    private static Boolean mimParserHasMethodGetObsolete = null;
    private static Boolean mimParserHasMethodIsInterfaceOnly = null;

    public static boolean hasAttribute(MimModel model, String aClass, String attribute) {
        MomAttribute momAttribute;
        MomClass momClass;
        if (model != null && aClass != null && attribute != null && null != (momClass = model.getClass(aClass)) && (momAttribute = momClass.getAttribute(attribute)) != null) {
            if (MoClassResolver.attributeIsObsolete(momAttribute)) {
                return false;
            }
            return !MoClassResolver.attributeIsInterfaceOnly(momAttribute);
        }
        return false;
    }

    public static boolean isMoSpecifiedInMom(MimModel model, String aClass) {
        MomClass momClass;
        boolean moExistsInMom = false;
        if (model != null && !"".equals(aClass) && (momClass = model.getClass(aClass)) != null) {
            moExistsInMom = true;
        }
        return moExistsInMom;
    }

    public static ArrayList<String> resolveChildrenMoClasses(MimModel model, String expression, String parentClass) throws UndefinedTypeException {
        ArrayList<String> foundClasses = new ArrayList<String>();
        if (null == expression || 0 == expression.length()) {
            return foundClasses;
        }
        MomClass parentMomClass = model.getClass(parentClass);
        if (parentMomClass != null) {
            boolean isRegularExpression = MoClassResolver.isRegExp(expression);
            Pattern pattern = null;
            if (isRegularExpression) {
                pattern = Pattern.compile(MoClassResolver.getRegExp(expression), 2);
            }
            Iterator childrenClasses = model.getClass(parentClass).getContainmentChildren();
            while (childrenClasses.hasNext()) {
                String aClass = ((MomClass)childrenClasses.next()).getName();
                if (isRegularExpression) {
                    Matcher matcher = pattern.matcher(aClass);
                    if (!matcher.matches()) continue;
                    foundClasses.add(aClass);
                    continue;
                }
                if (!aClass.equalsIgnoreCase(expression)) continue;
                foundClasses.add(aClass);
                break;
            }
        }
        return foundClasses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<String> resolveMoClass(MimModel model, String expression) throws UndefinedTypeException {
        ArrayList<String> foundClasses = new ArrayList<String>();
        if (expression == null) {
            return foundClasses;
        }
        if (expression.equals("")) {
            return foundClasses;
        }
        if (!MoClassResolver.isRegExp(expression)) {
            MomClass momClass = model.getClass(expression);
            if (momClass == null) throw new UndefinedTypeException("The class " + expression + " is not defined in the MOM");
            foundClasses.add(expression);
            return foundClasses;
        } else {
            Pattern pattern = Pattern.compile(MoClassResolver.getRegExp(expression), 2);
            Iterator momClasses = model.getClasses();
            while (momClasses.hasNext()) {
                MomClass momClass = (MomClass)momClasses.next();
                Matcher matcher = pattern.matcher(momClass.getName());
                if (!matcher.matches()) continue;
                foundClasses.add(momClass.getName());
            }
        }
        return foundClasses;
    }

    public static ArrayList<String> resolveMoClassesBelow(MimModel model, String expression, String belowMoClass) throws UndefinedTypeException {
        ArrayList<String> foundClasses;
        block7: {
            block8: {
                foundClasses = new ArrayList<String>();
                if (belowMoClass == null || 0 >= belowMoClass.length()) {
                    NexLog.logger().info("The method resolveMoClassesBelow got null as MO class to look below");
                    return foundClasses;
                }
                if (expression == null || expression.equals("")) {
                    return foundClasses;
                }
                if (MoClassResolver.isRegExp(expression)) break block8;
                MomClass theMomClass = model.getClass(expression);
                if (theMomClass == null) break block7;
                Iterator<MomClass> momClasses = MoClassResolver.getMoClassesBelow(belowMoClass, model);
                while (momClasses.hasNext()) {
                    MomClass momClass = momClasses.next();
                    if (!momClass.equals(theMomClass)) continue;
                    if (MoClassResolver.isMoSpecifiedInMom(model, momClass.getName())) {
                        foundClasses.add(momClass.getName());
                    } else {
                        NexLog.logger().fine("MO class " + momClass.getName() + " is ignored. " + "Exists in view but not in MOM");
                    }
                    break block7;
                }
                break block7;
            }
            Pattern pattern = Pattern.compile(MoClassResolver.getRegExp(expression), 2);
            Iterator<MomClass> momClasses = MoClassResolver.getMoClassesBelow(belowMoClass, model);
            while (momClasses.hasNext()) {
                MomClass momClass = momClasses.next();
                Matcher matcher = pattern.matcher(momClass.getName());
                if (!matcher.matches()) continue;
                if (MoClassResolver.isMoSpecifiedInMom(model, momClass.getName())) {
                    foundClasses.add(momClass.getName());
                    continue;
                }
                NexLog.logger().fine("MO class " + momClass.getName() + " is ignored. " + "Exists in view but not in the MOM");
            }
        }
        return foundClasses;
    }

    public static String resolveMoClassFromLdn(String ldn) {
        String className = "";
        if (!ldn.equals("")) {
            int begin = ldn.lastIndexOf(",") + 1;
            int end = ldn.lastIndexOf("=");
            if (end > -1) {
                className = ldn.substring(begin, end);
            }
        }
        return className;
    }

    public static boolean isRegExp(String aString) {
        return aString.startsWith("re(") && aString.endsWith(")");
    }

    public static String getRegExp(String aString) {
        if (!MoClassResolver.isRegExp(aString)) {
            return null;
        }
        int begin = aString.indexOf("(");
        int end = aString.lastIndexOf(")");
        if (-1 == begin || end < 3) {
            return null;
        }
        return aString.substring(begin + 1, end);
    }

    public static boolean hasMoAttributes(MimModel model, String aClassName, Collection<String> searchAttributes) {
        boolean okAttribute = true;
        MomClass momClass = model.getClass(aClassName);
        if (null == momClass) {
            okAttribute = false;
        } else {
            Iterator<String> searchIter = searchAttributes.iterator();
            block0: while (searchIter.hasNext() && okAttribute) {
                String searchedAttribute = searchIter.next();
                okAttribute = false;
                Iterator moAttributeIterator = momClass.getAttributes();
                while (moAttributeIterator.hasNext()) {
                    if (!((MomAttribute)moAttributeIterator.next()).getName().equalsIgnoreCase(searchedAttribute)) continue;
                    okAttribute = true;
                    continue block0;
                }
            }
        }
        NexLog.logger().fine("Checking if " + aClassName + " has all attributes in the search expression. Returning: " + okAttribute);
        return okAttribute;
    }

    private static Iterator<MomClass> getMoClassesBelow(String aClassName, MimModel mimModel) {
        ArrayList<MomClass> possibleChildren = new ArrayList<MomClass>();
        MoClassResolver.getSearchableMoClasses(aClassName, possibleChildren, mimModel);
        return possibleChildren.iterator();
    }

    private static void getSearchableMoClasses(String aClassName, List<MomClass> possibleChildren, MimModel mimModel) {
        Iterator children = mimModel.getClass(aClassName).getContainmentChildren();
        while (children.hasNext()) {
            MomClass child = (MomClass)children.next();
            if (possibleChildren.contains(child)) continue;
            MoClassResolver.getSearchableMoClasses(child.getName(), possibleChildren, mimModel);
            possibleChildren.add(child);
        }
    }

    private static boolean attributeIsObsolete(MomAttribute momAttribute) {
        boolean isObsolete = false;
        if (null == mimParserHasMethodGetObsolete) {
            try {
                if (momAttribute.getObsolete() != null) {
                    isObsolete = true;
                    mimParserHasMethodGetObsolete = Boolean.TRUE;
                }
            }
            catch (NoSuchMethodError e) {
                mimParserHasMethodGetObsolete = Boolean.FALSE;
            }
        } else if (mimParserHasMethodGetObsolete.booleanValue()) {
            isObsolete = momAttribute.getObsolete() != null;
        }
        return isObsolete;
    }

    private static boolean attributeIsInterfaceOnly(MomAttribute momAttribute) {
        boolean isInterfaceOnly = false;
        if (null == mimParserHasMethodIsInterfaceOnly) {
            try {
                if (momAttribute.isInterfaceOnly()) {
                    isInterfaceOnly = true;
                }
                mimParserHasMethodIsInterfaceOnly = Boolean.TRUE;
            }
            catch (NoSuchMethodError e) {
                mimParserHasMethodIsInterfaceOnly = Boolean.FALSE;
            }
        } else if (mimParserHasMethodIsInterfaceOnly.booleanValue()) {
            isInterfaceOnly = momAttribute.isInterfaceOnly();
        }
        return isInterfaceOnly;
    }
}

