/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.neal.cm.DnAttributes;
import se.ericsson.cello.neal.cm.DnNameValues;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;
import se.ericsson.cello.nex.viewservices.utils.MoClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoReader {
    private NodeServices myNodeServices;
    private boolean readingDone = false;
    private Map<String, NameValue[]> fetchedData = new HashMap<String, NameValue[]>();
    private List<ViewElementI> nodes = new ArrayList<ViewElementI>();
    private static final int BATCH_SIZE = 50;
    private volatile boolean aborted = false;
    private String[] attributesToRead;
    private Exception statusException = null;
    private String statusMessage;
    private boolean status;

    public MoReader(NodeServices myNodeServices) {
        this.myNodeServices = myNodeServices;
    }

    public void refreshNodes(List<ViewElementI> nodes, String[] attributes) {
        NexLog.logger().fine("Process request of " + nodes.size() + " nodes");
        this.nodes = nodes;
        this.attributesToRead = new String[attributes.length];
        System.arraycopy(attributes, 0, this.attributesToRead, 0, attributes.length);
        this.statusException = null;
        this.statusMessage = "";
        this.status = true;
        this.readingDone = false;
        this.processRequest();
    }

    public void abortRequest() {
        this.aborted = true;
    }

    private void processRequest() {
        Runnable runner = new Runnable(){

            public void run() {
                MoReader.this.readingDone = false;
                MoReader.this.fetchedData = MoReader.this.fetchAttributes(MoReader.this.nodes, MoReader.this.attributesToRead);
                if (!MoReader.this.fetchedData.isEmpty()) {
                    MoReader.this.distributeAttributes(MoReader.this.nodes);
                }
                MoReader.this.readingDone = true;
                NexLog.logger().fine("Process request is done");
            }
        };
        new Thread(runner, "MoReaderThread").start();
    }

    public Map<String, NameValue[]> fetchAttributes(List<ViewElementI> nodes, String[] attributes) {
        NexLog.logger().fine("fetchAttributes for " + nodes.size() + " elements");
        String lastType = "undefined";
        String[] lastAttributes = attributes;
        ArrayList<DnAttributes> dnAttributeList = new ArrayList<DnAttributes>(0);
        this.fetchedData.clear();
        for (ViewElementI viewElem : nodes) {
            if (!lastType.equals(viewElem.getMoType())) {
                lastType = viewElem.getMoType();
                lastAttributes = this.resolveAttributes(lastType, attributes);
            }
            if (lastAttributes.length == 0 || viewElem.getType() == ViewElementI.ViewElementType.FOLDER) {
                NexLog.logger().fine(" No attributes to read. Skipping " + viewElem.getLdn());
            } else {
                dnAttributeList.add(new DnAttributes(viewElem.getLdn(), lastAttributes));
            }
            if (dnAttributeList.size() == 50) {
                this.processBatch(dnAttributeList);
                dnAttributeList.clear();
            }
            if (!this.aborted) continue;
            this.fetchedData.clear();
            break;
        }
        if (!dnAttributeList.isEmpty() && !this.aborted) {
            this.processBatch(dnAttributeList);
        }
        return this.fetchedData;
    }

    private void processBatch(ArrayList<DnAttributes> dnAttributeList) {
        DnAttributes[] dnAttrs = dnAttributeList.toArray(new DnAttributes[0]);
        try {
            DnNameValues[] dnNameValues = this.myNodeServices.getNode().getCmService().getMoAttributes(dnAttrs, null);
            for (int i = 0; i < dnNameValues.length; ++i) {
                this.fetchedData.put(dnNameValues[i].getDn(), dnNameValues[i].getNameValues());
            }
        }
        catch (Exception e) {
            this.setStatusException(e);
            NexLog.logger().warning("Could not read all attributes. " + e.getMessage());
        }
    }

    private String[] resolveAttributes(String momClass, String[] attributes) {
        ArrayList<String> resolvedAttributes = new ArrayList<String>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            if (!MoClassResolver.hasAttribute(this.myNodeServices.getMimModel(), momClass, attributes[i])) continue;
            resolvedAttributes.add(attributes[i]);
        }
        return resolvedAttributes.toArray(new String[0]);
    }

    private void distributeAttributes(List<ViewElementI> elements) {
        NameValue[] nameValues = null;
        for (ViewElementI element : elements) {
            nameValues = this.fetchedData.get(element.getLdn());
            if (nameValues == null) continue;
            element.setAttributeValues(nameValues);
        }
    }

    private void setStatusException(Exception e) {
        this.statusException = e;
    }

    public boolean isRequestFinished() {
        return this.readingDone;
    }

    public boolean wasRequestSuccessful() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public Exception getException() {
        return this.statusException;
    }
}

