/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.viewlist.parser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.nex.NexLog;

public class ViewlistParser {
    private static final String VIEWLIST_SCHEMA = "viewlist.xsd";
    private Document document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource xmlSource, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        ClassLoader savedClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DOMParser parser = new DOMParser();
            NexLog.logger().info("DOMParser is: " + parser);
            parser.parse(xmlSource);
            this.document = parser.getDocument();
            if (validate) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                InputStream inputStream = ViewlistParser.class.getResourceAsStream(VIEWLIST_SCHEMA);
                StreamSource schemaFile = new StreamSource(inputStream);
                Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(this.document));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassloader);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.document.getDocumentElement();
    }
}

