/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlist.controller.impl;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmListController;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmSuppressedMode;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmSuppressionConfigurator;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.security.utils.EmLogger;

public class AlarmSuppressionMonitor {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private AlarmListController alarmListController;
    private AlarmSuppressionConfigurator alarmSuppressionConfigurator;
    private String alarmSuppressionMoClass;
    private String displayCondition;
    private Timer moSearchingTimer;
    private Runnable moSearchingRunner;
    private AlarmSuppressedMode currentMode;
    private TimerTask searchTask;
    private final String rootMoLdn = "ManagedElement=1";
    private Mo rootMo = null;
    private final int pollperiod = 20000;

    public AlarmSuppressionMonitor() {
    }

    public AlarmSuppressionMonitor(AlarmListController c) {
        LOG.finer("AlarmSuppressionMonitor constructor.", new Object[0]);
        this.alarmListController = c;
        Properties props = this.alarmListController.getToolService().getConfiguration().getProperties();
        this.alarmSuppressionConfigurator = new AlarmSuppressionConfigurator();
        this.currentMode = AlarmSuppressedMode.OFF;
        this.alarmSuppressionConfigurator.setProperties(props);
        LOG.info("AlarmList started with: " + props, new Object[0]);
        this.alarmSuppressionConfigurator.setController(this.alarmListController);
        this.alarmSuppressionMoClass = this.alarmSuppressionConfigurator.getAlarmSuppressionMoClass();
        this.displayCondition = this.alarmSuppressionConfigurator.getDisplayCondition();
        String reason = "Reason:\nalarmSuppressionMoClass: " + this.alarmSuppressionMoClass + "\ndisplayCondition: " + this.displayCondition + "\nthat has been specified by user: " + this.alarmSuppressionConfigurator.isUserSpecified();
        if (this.alarmSuppressionMoClass != null && this.displayCondition != null) {
            this.startTimer();
            String text = "Alarm suppression monitor timer started. \n " + reason;
            LOG.info(text, new Object[0]);
        } else {
            String text = "Alarm suppression monitor timer not started. \n " + reason;
            LOG.info(text, new Object[0]);
        }
        LOG.finer("Exiting AlarmSuppressionMonitor constructor.", new Object[0]);
    }

    private Mo[] searchForMos(String moClass, String searchQuery) {
        LOG.finest("searchForMos(String moClass, String searchQuery), moClass is " + moClass + "searchQuery is: " + searchQuery, new Object[0]);
        Mo[] mos = null;
        try {
            if (this.rootMo == null) {
                this.rootMo = this.alarmListController.getToolService().getNodeServices().getNode().getCmService().getMo("ManagedElement=1");
            }
            mos = this.rootMo.getChildren(moClass, searchQuery, Scope.ALL_LEVELS, null);
        }
        catch (Exception e) {
            mos = null;
            String reason = "Can not get children mos of the type: " + moClass + "   \n" + e.getMessage();
            LOG.warning(reason, new Object[0]);
        }
        LOG.finest("searchForMos(String moClass, String searchQuery), returning: " + mos, new Object[0]);
        return mos;
    }

    private void updateAlarmListView(final Mo[] mos) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AlarmSuppressionMonitor.this.updateAlarmListView(mos);
                }
            });
        } else {
            JLabel aLabel = null;
            if (mos == null || mos.length == 0) {
                if (this.currentMode == AlarmSuppressedMode.ON) {
                    aLabel = this.alarmListController.getAlarmListView().readEmptyLabel();
                    this.currentMode = AlarmSuppressedMode.OFF;
                    this.alarmListController.getAlarmListView().setAlarmSuppressionLabel(aLabel);
                }
            } else if (this.currentMode == AlarmSuppressedMode.OFF) {
                aLabel = this.alarmListController.getAlarmListView().readAlarmSuppressedImageIcon();
                this.currentMode = AlarmSuppressedMode.ON;
                this.alarmListController.getAlarmListView().setAlarmSuppressionLabel(aLabel);
            }
        }
    }

    private void checkForAlarmSuppressionOnNode() {
        Mo[] mos = this.searchForMos(this.alarmSuppressionMoClass, this.displayCondition);
        this.updateAlarmListView(mos);
    }

    private void startTimer() {
        LOG.entering(new Object[0]);
        this.searchTask = new TimerTask(){

            public void run() {
                AlarmSuppressionMonitor.this.checkForAlarmSuppressionOnNode();
            }
        };
        this.moSearchingRunner = new Runnable(){

            public void run() {
                AlarmSuppressionMonitor.this.moSearchingTimer = new Timer();
                AlarmSuppressionMonitor.this.moSearchingTimer.schedule(AlarmSuppressionMonitor.this.searchTask, 6000L, 20000L);
            }
        };
        new Thread(this.moSearchingRunner, "moSearchingTimer for display condition").start();
        LOG.exiting();
    }

    public void destroy() {
        LOG.entering(new Object[0]);
        if (null != this.moSearchingTimer) {
            this.moSearchingTimer.cancel();
            LOG.finer("Destroyed: moSearchingTimer", new Object[0]);
            this.moSearchingTimer = null;
        }
        if (this.alarmSuppressionConfigurator != null) {
            this.alarmSuppressionConfigurator = null;
        }
        LOG.exiting();
    }
}

