/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.em.fm.common.model.impl.AbstractParser;
import se.ericsson.cello.em.fm.common.model.impl.AdditionalInformation;
import se.ericsson.cello.em.fm.common.model.impl.CorrelatedNotification;
import se.ericsson.cello.em.fm.common.model.impl.EventType;
import se.ericsson.cello.em.fm.common.model.impl.ExtendedEventType;
import se.ericsson.cello.em.fm.common.model.impl.ProbableCause;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.model.impl.Severity;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFileParser
extends AbstractParser {
    private static final String DELIMITER = ";";

    public NodeList getNodeList(InputStream inputStream, String nodeName) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = null;
        builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new DummyEntityResolver());
        Document doc = builder.parse(inputStream);
        NodeList nodeList = doc.getElementsByTagName(nodeName);
        doc = null;
        return nodeList;
    }

    public RecordContent parse(Node recordContentNode, FmType logType) {
        List<String> fields = this.getRecordContentList(recordContentNode);
        RecordContent recordContent = new RecordContent();
        int i = 0;
        try {
            recordContent.put(LogPart.DOMAIN_NAME, fields.get(i++));
            recordContent.put(LogPart.EVENT_TYPE, EventType.getEventType(fields.get(i++)));
            recordContent.put(LogPart.EXTENDED_EVENT_TYPE, ExtendedEventType.getExtendedEventType(fields.get(i++)));
            recordContent.put(LogPart.MANAGED_OBJECT_CLASS, fields.get(i++));
            recordContent.put(LogPart.MANAGED_OBJECT_INSTANCE, fields.get(i++));
            recordContent.put(LogPart.NOTIFICATION_ID, fields.get(i++));
            recordContent.put(LogPart.EVENT_TIME, this.getFormatedUtcTime(fields.get(i++)));
            recordContent.put(LogPart.SYSTEM_DN, fields.get(i++));
            if (logType.equals((Object)FmType.ALARM_LOG)) {
                String probableCauseValue;
                ProbableCause probableCause;
                recordContent.put(LogPart.PROBABLE_CAUSE, (probableCause = ProbableCause.getProbableCause(Short.valueOf(probableCauseValue = fields.get(i++)))) == ProbableCause.UNKNOWN_PROBABLE_CAUSE ? probableCauseValue : probableCause);
                recordContent.put(LogPart.PERCEIVED_SEVERITY, Severity.getSeverity(fields.get(i++)));
                recordContent.put(LogPart.SPECIFIC_PROBLEM, fields.get(i++));
                int numberOfNotifications = 0;
                numberOfNotifications = Integer.parseInt(fields.get(i++));
                ArrayList<CorrelatedNotification> correlatedNotifications = new ArrayList<CorrelatedNotification>();
                for (int x = 0; x < numberOfNotifications; ++x) {
                    CorrelatedNotification correlatedNotification = new CorrelatedNotification();
                    correlatedNotification.setMoi(fields.get(i++));
                    correlatedNotification.setNotificationId(fields.get(i++));
                    correlatedNotifications.add(correlatedNotification);
                }
                recordContent.put(LogPart.CORRELATED_NOTIFICATIONS, correlatedNotifications);
            } else {
                recordContent.put(LogPart.SPECIFIC_EVENT, fields.get(i++));
            }
            recordContent.put(LogPart.ADDITIONAL_TEXT, fields.get(i++));
            if (logType.equals((Object)FmType.ALARM_LOG)) {
                recordContent.put(LogPart.ALARM_ID, fields.get(i++));
                recordContent.put(LogPart.ACKNOWLEDGEMENT_USER, fields.get(i++));
                String logAckTime = fields.get(i++);
                String ackTime = "0".equals(logAckTime) ? "-" : this.getFormatedUtcTime(logAckTime);
                recordContent.put(LogPart.ACKNOWLEDGEMENT_TIME, ackTime);
                recordContent.put(LogPart.ACKNOWLEDGEMENT_STATE, fields.get(i++));
            }
            recordContent.put(LogPart.TIME_ZONE, fields.get(i++));
            int numberOfTypeValuePairs = 0;
            ArrayList<AdditionalInformation> additionalInformations = new ArrayList<AdditionalInformation>();
            if (i < fields.size()) {
                String tmpNumberOfTypeValuePairs = fields.get(i++);
                numberOfTypeValuePairs = Integer.parseInt(tmpNumberOfTypeValuePairs);
                for (int x = 0; x < numberOfTypeValuePairs; ++x) {
                    String type;
                    AdditionalInformation additionalInformation = new AdditionalInformation();
                    boolean userLabelFound = false;
                    if ("userLabel".equals(type = fields.get(i++))) {
                        userLabelFound = true;
                    }
                    additionalInformation.setType(type);
                    String value = fields.get(i++);
                    if (userLabelFound) {
                        recordContent.put(LogPart.USER_LABEL, value);
                    }
                    additionalInformation.setValue(value);
                    additionalInformations.add(additionalInformation);
                }
            }
            recordContent.put(LogPart.ADDITIONAL_INFORMATION, additionalInformations);
        }
        catch (Exception e) {
            LOG.warning("Wrong format on the log file: " + e.getMessage(), new Object[0]);
            LOG.finer("Wrong format on the log file: ", (Throwable)e);
            recordContent.setOk(false);
        }
        return recordContent;
    }

    private List<String> getRecordContentList(Node recordContentNode) {
        String recordContentString = recordContentNode.getTextContent().trim();
        if (recordContentString.endsWith(DELIMITER)) {
            recordContentString = recordContentString.substring(0, recordContentString.length() - 1);
        }
        String[] fields = recordContentString.split(DELIMITER, -1);
        return Arrays.asList(fields);
    }

    private class DummyEntityResolver
    implements EntityResolver {
        private DummyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

