/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.common.model.impl.NonEditableSortedTableModel;
import se.ericsson.cello.em.fm.common.view.impl.SortButtonRenderer;
import se.ericsson.cello.em.fm.common.view.impl.SortedTable;

public class FmSortedTable
extends SortedTable {
    private static final long serialVersionUID = 1L;
    private ListMouseListener listMouseListener = null;
    private SortButtonRenderer renderer = null;

    public FmSortedTable() {
        this.setColumnSelectionAllowed(false);
        this.setAutoCreateColumnsFromModel(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int pointx = (int)e.getPoint().getX();
                int pointy = (int)e.getPoint().getY();
                Point point = new Point(pointx, pointy);
                int rowNo = FmSortedTable.this.rowAtPoint(point);
                int colNo = FmSortedTable.this.columnAtPoint(point);
                FmSortedTable.this.setToolTipText(FmSortedTable.this.getValueAt(rowNo, colNo).toString());
            }
        });
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        if (model instanceof NonEditableSortedTableModel) {
            this.removeMouseListenerToHeaderInTable();
            this.addMouseListenerToHeaderInTable();
        }
    }

    private void addMouseListenerToHeaderInTable() {
        TableColumnModel tcm = this.tableHeader.getColumnModel();
        this.renderer = new SortButtonRenderer();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setHeaderRenderer(this.renderer);
        }
        if (tcm.getColumnCount() > 0) {
            this.renderer.setSelectedColumn(0);
        }
        this.listMouseListener = new ListMouseListener(this.tableHeader);
        this.tableHeader.addMouseListener(this.listMouseListener);
    }

    private void removeMouseListenerToHeaderInTable() {
        if (this.listMouseListener != null && this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.listMouseListener);
        }
    }

    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        if (this.renderer != null) {
            if (this.renderer.isSelectedColumn(e.getFromIndex())) {
                this.renderer.pressedColumnMoved(e.getToIndex());
                this.renderer.repaint();
            } else if (this.renderer.isSelectedColumn(e.getToIndex())) {
                this.renderer.pressedColumnMoved(e.getFromIndex());
                this.renderer.repaint();
            }
            this.renderer.setPressedColumn(e.getToIndex());
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        JTableHeader header = null;

        public ListMouseListener(JTableHeader header) {
            this.header = header;
        }

        public void mousePressed(MouseEvent e) {
            if (FmSortedTable.this.renderer != null && this.header != null) {
                int col = this.header.columnAtPoint(e.getPoint());
                FmSortedTable.this.renderer.setPressedColumn(col);
                if (FmSortedTable.this.renderer.isSelectedColumn(col)) {
                    FmSortedTable.this.renderer.pressedColumnMoved(col);
                }
                this.header.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (FmSortedTable.this.renderer != null && this.header != null) {
                FmSortedTable.this.renderer.setPressedColumn(-1);
                this.header.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (this.header != null) {
                FmSortedTable.this.renderer.setSelectedColumn(this.header.columnAtPoint(e.getPoint()));
                this.header.repaint();
            }
        }
    }
}

