/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.eventlog.view.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.view.impl.AbstractView;
import se.ericsson.cello.em.fm.common.view.impl.Menu;
import se.ericsson.cello.em.fm.common.view.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLogView
extends AbstractView {
    private static final long serialVersionUID = 3404150524771735328L;
    private static final Utils UTILS = new Utils();
    private JLabel noOfEventsValue;
    private JLabel changedValue;

    public EventLogView(ToolService toolService) {
        super(toolService);
    }

    @Override
    protected EnumMap<Menu, JMenuItem[]> getToolMenus() {
        EnumMap<Menu, JMenuItem[]> menus = new EnumMap<Menu, JMenuItem[]>(Menu.class);
        menus.put(Menu.NETWORK_ELEMENT, new JMenuItem[]{this.printMenuItem, this.pageSetupMenuItem, this.exportMenuItem, null, this.closeMenuItem});
        menus.put(Menu.VIEW, new JMenuItem[]{this.refreshMenuItem});
        menus.put(Menu.EVENT_LOG, new JMenuItem[]{this.detailsMenuItem});
        return menus;
    }

    @Override
    protected List<JMenuItem> getTablePopUpMenuItems() {
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
        menus.add(this.detailsPopUpMenuItem);
        return menus;
    }

    @Override
    protected JComponent createToolSpecificPanel() {
        JPanel toolSpecific = new JPanel(new BorderLayout());
        toolSpecific.add((Component)UTILS.createUserPanel(), "North");
        toolSpecific.add(this.createStatusPanel(), "South");
        return toolSpecific;
    }

    @Override
    protected String getHelpOnWindowSection() {
        return "EventLog";
    }

    @Override
    protected ArrayList<String> getRightAlignedColumns() {
        return new ArrayList<String>();
    }

    public void setTimeStamp(String timeStamp) {
        this.changedValue.setText(timeStamp);
    }

    public void setNoOfEvents(int noOfEvents) {
        this.noOfEventsValue.setText(UTILS.getCounterText(noOfEvents));
    }

    private Component createStatusPanel() {
        JPanel status = new JPanel(new BorderLayout(10, 0));
        status.setBorder(BorderFactory.createEtchedBorder(1));
        this.noOfEventsValue = new JLabel();
        this.changedValue = new JLabel();
        this.changedValue.setName("changedValue");
        JComponent counterPanel = UTILS.createCounterPanel("Total:", this.noOfEventsValue, null);
        JComponent changedPanel = UTILS.createChangedPanel("Changed:", this.changedValue);
        status.add((Component)counterPanel, "West");
        status.add((Component)changedPanel, "Center");
        return status;
    }

    @Override
    protected MenuListener getMenuListener() {
        return new EventLogMenuListener();
    }

    private class EventLogMenuListener
    implements MenuListener {
        private EventLogMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            if (EventLogView.this.getTable().getSelectedRows().length == 1) {
                EventLogView.this.detailsMenuItem.setEnabled(true);
            } else {
                EventLogView.this.detailsMenuItem.setEnabled(false);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

