/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemoveSuperfluousAlarmPortsAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = RemoveSuperfluousAlarmPortsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String REMOVE_MO_ALARM_PORT_STEP2_ACTION = "alarmPortsToRemove";
    protected static final String HWUNIT = "HwUnit";
    protected static final String UNITTYPE = "unitType";
    protected static final String LDN = "ldn";
    protected static final String ALARMPORT = "AlarmPort";
    private TableHandler tableHandler = null;

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        this.tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(this.tableHandler, HWUNIT);
        List list = this.findSCUsAndSUPs(tableData);
        List list2 = this.generateAlarmPortsToRemoveList(list);
        this.removeAlarmPorts(list2);
        this.informStep2(list2);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void informStep2(List list) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = LdnUtil.getParentLdn((String)string);
            string3 = LdnUtil.getRdnValue((String)string2);
            string4 = LdnUtil.getRdnValue((String)string);
            string5 = string3 + "," + string4;
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string5);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", REMOVE_MO_ALARM_PORT_STEP2_ACTION, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private void removeAlarmPorts(List list) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "removeAlarmPorts()");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            String string = (String)iterator.next();
            String string2 = this.getFroTypeFromLdn(string);
            TableData tableData = null;
            try {
                tableData = this.tableHandler.getTableData(string2);
            }
            catch (TableDataException tableDataException) {
                logger.traceDebug(THIS_CLASS, "Could not delete Mo instance " + AueUtil.doubleQuote((String)string) + " due to no data for Mo type.");
            }
            boolean bl = false;
            for (n = 0; n < tableData.getNumberOfRecords(); ++n) {
                if (!((String)tableData.getRecord(n)[1]).equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                logger.traceDebug(THIS_CLASS, "Deleting ldn: " + AueUtil.doubleQuote((String)string));
                tableData.deleteRowData(n);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Could not find ldn to delete: " + AueUtil.doubleQuote((String)string));
        }
        logger.traceReturn(THIS_CLASS, "removeAlarmPorts()");
    }

    private List generateAlarmPortsToRemoveList(List list) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "generateAlarmPortsToRemoveList()");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!list.isEmpty()) {
            TableData tableData = this.getTableData(this.tableHandler, ALARMPORT);
            Object[] objectArray = new Object[]{};
            try {
                if (tableData.isNotEmpty()) {
                    objectArray = tableData.getAttributeValues(LDN);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            block2: for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                String string2 = this.getParentLdn(string);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (!string2.equals(string3) || this.getRdnIntValue(string) < 17 || this.getRdnIntValue(string) > 32) continue;
                    arrayList.add(string);
                    continue block2;
                }
            }
        }
        logger.info(THIS_CLASS, "generateAlarmPortsToRemoveList(): alarmPortsToRemove.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "generateAlarmPortsToRemoveList()");
        return arrayList;
    }

    private List findSCUsAndSUPs(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findSCUsAndSUPs()");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            String string = (String)map.get(UNITTYPE);
            logger.info(THIS_CLASS, "findSCUsAndSUPs(): unittype: " + string);
            if (!"SCU".equals(string) && !"SUP".equals(string)) continue;
            String string2 = (String)map.get(LDN);
            arrayList.add(string2);
        }
        logger.info(THIS_CLASS, "findSCUsAndSUPs(): scuAndSupArrayList.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "findSCUsAndSUPs()");
        return arrayList;
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }

    private int getRdnIntValue(String string) {
        int n = -1;
        String string2 = AueUtil.getRdnAttributeValue((String)string);
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            logger.traceDebug(THIS_CLASS, "getRdnIntValue(): Integer.parseInt(" + string2 + ") failed");
        }
        return n;
    }
}

