<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<!-- Identity template -->
	<xsl:template match="node() | @*">
 		<xsl:copy>
			<xsl:apply-templates select="node() | @*" />
		</xsl:copy>
  	</xsl:template>

	<!-- Deleted elements -->
	<xsl:template match="EthernetSwitch"/>


	<!-- Modified elements -->

	<xsl:variable name="matchesConnection" select="//Connection" />
	<xsl:variable name="numOfConnections" select="count($matchesConnection)" />

	<xsl:template match="Connection">
		<xsl:copy> 
			
			<xsl:choose>
				<xsl:when test="$numOfConnections='1'">
					<xsl:attribute name="name">firstOAMatm</xsl:attribute>	
					<xsl:apply-templates select="node() | @*[not(name()='name')]" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="node() | @*" />
				</xsl:otherwise>
			</xsl:choose>
						
			<xsl:call-template name="convertPhysicalLine"/>
		</xsl:copy>          
	</xsl:template>                         
                             
	<xsl:template match= "AtmPort">
		<xsl:copy>
			<xsl:call-template name="convertPhysicalLine"/>
		</xsl:copy>
	</xsl:template>
                             
	<xsl:template match= "IPoverGigabitEthernet">
		<xsl:copy>
			<!-- Change the etIPSynchSlot to slot 1 -->
			<xsl:attribute name="etIPSynchSlot">1</xsl:attribute>
			<xsl:apply-templates select="node() | @*[not(name()='etIPSynchSlot')]" />
		</xsl:copy>
	</xsl:template>
                             
	<xsl:template match= "NetworkSynch">
                                                          
		<xsl:variable name="terminationTypeFirstOAMatm" select="../IPoverATM/Connection[@name='firstOAMatm']/@terminationType"/>
		<xsl:variable name="terminationTypeSecondOAMatm" select="../IPoverATM/Connection[@name='secondOAMatm']/@terminationType"/>
 		<xsl:choose>
			<xsl:when test="not(normalize-space($terminationTypeFirstOAMatm))">
				<xsl:call-template name="convertSynchPort">
					<xsl:with-param name="terminationType" select="$terminationTypeSecondOAMatm" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="convertSynchPort">
					<xsl:with-param name="terminationType" select="$terminationTypeFirstOAMatm" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="convertSynchPort">
		<xsl:param name="terminationType" />
		<xsl:copy>
			<!-- Change the synchSlot to slot 1 -->
			<xsl:attribute name="synchSlot">1</xsl:attribute>
			<xsl:apply-templates select="node() | @*[not(name()='synchSlot')]" />
                                                                                      
			<!-- 
			| synchPort is mapped with same ranges for DUW as for CBU 
			| except for "1 to 2 for IpSynchRef" which should be mapped
			| to "7 to 8 for IpSynchRef". This is handled in separate
			| xsl file. 
			+-->
			<!-- If the ETB type is ET-MC41 -->
			<xsl:if test="@synchPort='1'">
				<xsl:if
					test="$terminationType='Chan_STM1_E1' or 
					$terminationType='Chan_OC3_T1' or
					$terminationType='Chan_STM1_Fractional_E1' or
					$terminationType='Chan_OC3_fractional_T1' or
					$terminationType='IMA_Chan_STM1_E1' or
					$terminationType='IMA_Chan_OC3_T1'"
				>
					<xsl:attribute name="synchPort">9</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<!-- If the ETB type is ET-M4 -->
			<xsl:if test="@synchPort='1' or @synchPort='2'">
				<xsl:if 
					test="$terminationType='OC3' or
					$terminationType='STM1_ETSI' or
					$terminationType='STM1_TTC'"
				>
					<xsl:attribute name="synchPort">9</xsl:attribute>
				</xsl:if>
			</xsl:if>                                                                                                                                                                                                                               
		</xsl:copy>                                           
	</xsl:template>
                             
	<xsl:template name="convertPhysicalLine">
		<!-- Change the etbSlot to slot 1 -->
		<xsl:attribute name="etbSlot">1</xsl:attribute>
        <!--                                                                                                                                
		<xsl:apply-templates select="node() | @*[not(name()='etbSlot')]" />
        -->                                             
		<!-- 
       	| Change the physicalLine depending on the ETB type 
       	| (which is determined from the termination type) 
       	+-->
       	<!-- If the ETB type is ET-MC41 -->
		<xsl:if test="@physicalLine='1'">
			<xsl:if 
 				test="@terminationType='Chan_STM1_E1' or
				@terminationType='Chan_OC3_T1' or
				@terminationType='Chan_STM1_Fractional_E1' or
				@terminationType='Chan_OC3_fractional_T1' or
				@terminationType='IMA_Chan_STM1_E1' or
				@terminationType='IMA_Chan_OC3_T1'" 
			>
				<xsl:attribute name="physicalLine">5</xsl:attribute>
			</xsl:if>
		</xsl:if>
		
		<!-- If the ETB type is ET-M4 -->
		<xsl:if test="@physicalLine='1' or @physicalLine='2'">
			<xsl:if 
				test="@terminationType='OC3' or
				@terminationType='STM1_ETSI' or
				@terminationType='STM1_TTC'"
			>
				<xsl:attribute name="physicalLine">5</xsl:attribute>
           	</xsl:if>
		</xsl:if>
	</xsl:template>                         
</xsl:transform>
