/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.X509CertificateJSSE;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.SessionState;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.security.provider.X509Certificate;
import java.security.cert.Certificate;
import java.util.Hashtable;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;

public class SSLSession
implements javax.net.ssl.SSLSession {
    private final SessionState sessState;
    private final Hashtable boundObjects = new Hashtable(5);
    private final SSLSessionContext sessContext;

    SSLSession(SessionState sessState, SSLSessionContext context) {
        this.sessState = sessState;
        this.sessContext = context;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sessContext;
    }

    public byte[] getId() {
        if (this.sessState == null) {
            return new byte[0];
        }
        return this.sessState.getSessionID();
    }

    public long getCreationTime() {
        if (this.sessState == null) {
            return 0L;
        }
        return this.sessState.getCreationTime();
    }

    public long getLastAccessedTime() {
        if (this.sessState == null) {
            return 0L;
        }
        return this.sessState.getLastAccessTime();
    }

    public void invalidate() {
        if (this.sessState == null) {
            return;
        }
        this.sessState.invalidate();
    }

    public void putValue(String key, Object object) {
        SSLSessionBindingEvent event;
        if (key == null) {
            throw new IllegalArgumentException(Msg.getString("K0350"));
        }
        if (object == null) {
            throw new IllegalArgumentException(Msg.getString("K03a4"));
        }
        Object oldObject = this.boundObjects.get(key);
        if (oldObject instanceof SSLSessionBindingListener) {
            event = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)oldObject).valueUnbound(event);
        }
        this.boundObjects.put(key, object);
        if (object instanceof SSLSessionBindingListener) {
            event = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)object).valueBound(event);
        }
    }

    public Object getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException(Msg.getString("K0350"));
        }
        return this.boundObjects.get(key);
    }

    public void removeValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException(Msg.getString("K0350"));
        }
        Object removedObject = this.boundObjects.remove(key);
        if (removedObject instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent event = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)removedObject).valueUnbound(event);
        }
    }

    public String[] getValueNames() {
        Set s = this.boundObjects.keySet();
        String[] values = new String[s.size()];
        s.toArray(values);
        return values;
    }

    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.sessState == null) {
            throw new SSLPeerUnverifiedException(Msg.getString("K0411"));
        }
        X509CertImpl[] certs = this.sessState.getPeerCertificates();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException(Msg.getString("K0411"));
        }
        javax.security.cert.X509Certificate[] result = this.getX509CertRepresentation(certs);
        return result;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.sessState == null) {
            throw new SSLPeerUnverifiedException(Msg.getString("K0411"));
        }
        X509CertImpl[] certs = this.sessState.getPeerCertificates();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException(Msg.getString("K0411"));
        }
        Certificate[] result = this.getCertificateRepresentation(certs);
        return result;
    }

    public Certificate[] getLocalCertificates() {
        if (this.sessState == null) {
            return null;
        }
        return this.sessState.getLocalCertificates();
    }

    public String getCipherSuite() {
        if (this.sessState == null) {
            return CipherSpec.NULL_SPEC.toString();
        }
        CipherSpec spec = this.sessState.getCipherSpec();
        if (spec == null) {
            return CipherSpec.NULL_SPEC.toString();
        }
        return spec.toString();
    }

    public String getProtocol() {
        if (this.sessState == null) {
            return "NONE";
        }
        return CipherSpec.getProtocolName((byte[])this.sessState.getProtocolVersion());
    }

    public String getPeerHost() {
        if (this.sessState == null) {
            return null;
        }
        return this.sessState.getHostName();
    }

    private X509CertificateJSSE[] getX509CertRepresentation(X509CertImpl[] certs) {
        X509CertificateJSSE[] result = new X509CertificateJSSE[certs.length];
        int i = 0;
        while (i < certs.length) {
            result[i] = new X509CertificateJSSE(certs[i]);
            ++i;
        }
        return result;
    }

    private Certificate[] getCertificateRepresentation(X509CertImpl[] certs) {
        Certificate[] result = new Certificate[certs.length];
        int i = 0;
        while (i < certs.length) {
            result[i] = new X509Certificate(certs[i]);
            ++i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SSLSession)) {
            return false;
        }
        SSLSession obj = (SSLSession)o;
        boolean stateequal = true;
        boolean contextequal = true;
        if (this.sessContext == null && obj.sessContext != null) {
            return false;
        }
        if (this.sessState == null && obj.sessState != null) {
            return false;
        }
        if (this.sessState != null) {
            stateequal = this.sessState.equals(obj.sessState);
        }
        if (this.sessContext != null) {
            contextequal = this.sessContext.equals(obj.sessContext);
        }
        return stateequal && contextequal;
    }

    public int hashCode() {
        int result = 0;
        if (this.sessContext != null) {
            result = this.sessContext.hashCode();
        }
        if (this.sessState != null) {
            result += this.sessState.hashCode();
        }
        return result;
    }
}

