/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.J9JSSESSLContext;
import com.ibm.j9.jsse.SSLSocketImpl;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.J9SSLSessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static String DFLT_PROVIDER_TRUSTMGR_ALG = "IBMJ9X509";
    private J9SSLContext context;

    public SSLSocketFactory() {
        J9SSLSessionContext sessionContextImpl = new J9SSLSessionContext();
        X509KeyManager km = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(null, null);
            km = (X509KeyManager)kmf.getKeyManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(Msg.getString("K03a8"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalError(Msg.getString("K03a8"));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new InternalError(Msg.getString("K03a8"));
        }
        X509TrustManager tm = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(DFLT_PROVIDER_TRUSTMGR_ALG);
            tmf.init((KeyStore)null);
            TrustManager[] candidates = tmf.getTrustManagers();
            tm = (X509TrustManager)candidates[0];
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(Msg.getString("K03b8", e.getMessage()));
        }
        catch (KeyStoreException e) {
            throw new InternalError(Msg.getString("K03b9", e.getMessage()));
        }
        SecureRandom randomSource = new SecureRandom();
        this.context = new J9JSSESSLContext(km, tm, randomSource, sessionContextImpl);
    }

    public SSLSocketFactory(J9SSLContext context) {
        this.context = context;
    }

    public String[] getDefaultCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public Socket createSocket(Socket socket, String hostName, int hostPort, boolean closeBaseSocket) throws IOException {
        if (!socket.isConnected()) {
            throw new IOException(Msg.getString("K0074"));
        }
        return new SSLSocketImpl(socket, hostName, hostPort, closeBaseSocket, this.context, this.getDefaultCipherSuites());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new SSLSocketImpl(host, port, this.context, this.getDefaultCipherSuites());
    }

    public Socket createSocket(String hostName, int hostPort, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        return new SSLSocketImpl(hostName, hostPort, clientAddress, clientPort, this.context, this.getDefaultCipherSuites());
    }

    public Socket createSocket() throws IOException {
        return new SSLSocketImpl(this.context, this.getDefaultCipherSuites());
    }

    public Socket createSocket(InetAddress hostAddress, int hostPort) throws IOException {
        return new SSLSocketImpl(hostAddress, hostPort, this.context, this.getDefaultCipherSuites());
    }

    public Socket createSocket(InetAddress hostAddress, int hostPort, InetAddress clientAddress, int clientPort) throws IOException {
        return new SSLSocketImpl(hostAddress, hostPort, clientAddress, clientPort, this.context, this.getDefaultCipherSuites());
    }
}

