/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.J9X509KeyManager;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class X509KeyManagerFactory
extends KeyManagerFactorySpi {
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private boolean initialized = false;

    protected void engineInit(KeyStore keyStore, char[] keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.keyStorePassword = keyStorePassword;
        this.keyStore = keyStore != null ? keyStore : this.openConfiguredKeyStore();
        this.initialized = true;
    }

    protected void engineInit(ManagerFactoryParameters factoryParams) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(Msg.getString("K03be"));
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (!this.initialized) {
            throw new IllegalStateException(Msg.getString("K03bf"));
        }
        KeyManager[] result = new KeyManager[]{new J9X509KeyManager(this.keyStore, this.keyStorePassword)};
        return result;
    }

    private KeyStore openConfiguredKeyStore() throws KeyStoreException {
        String keyStoreProperty;
        KeyStore result = null;
        String keyStoreType = null;
        keyStoreType = X509KeyManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.keyStoreType");
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStorePassword = (char[])((keyStoreProperty = X509KeyManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.keyStorePassword")) == null ? null : keyStoreProperty.toCharArray());
        String keyStorePath = null;
        keyStorePath = X509KeyManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.keyStore");
        if (keyStorePath != null && (result = this.openKeyStore(keyStorePath, keyStoreType)) != null) {
            return result;
        }
        return KeyStore.getInstance(keyStoreType);
    }

    private static String getPrivilegedSystemProperty(String key) {
        return (String)AccessController.doPrivileged(new PriviAction(key));
    }

    private final KeyStore openKeyStore(String filePath, String keyStoreType) throws KeyStoreException {
        InputStream is;
        KeyStore result = KeyStore.getInstance(keyStoreType);
        final String keyStoreFilePath = filePath;
        try {
            is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BufferedInputStream(new FileInputStream(keyStoreFilePath));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception except = e.getException();
            if (except instanceof FileNotFoundException) {
                throw new KeyStoreException(e.getMessage());
            }
            throw new KeyStoreException(except.getMessage());
        }
        try {
            try {
                result.load(is, this.keyStorePassword);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(Msg.getString("K03c0", filePath, e.getMessage()));
            }
            catch (CertificateException e) {
                throw new KeyStoreException(Msg.getString("K03c0", filePath, e.getMessage()));
            }
            catch (IOException e) {
                throw new KeyStoreException(Msg.getString("K03c0", filePath, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

