/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;
import se.ericsson.security.corba.socket.CSUSocketFactory;

public class CppProfileSelector
implements ProfileSelector {
    public static final String SE_ERICSSON_SECURITY_CORBA_PROFILE_CHECK_ENABLED = "se.ericsson.security.corba.profile_check_enabled";
    public static final String SE_ERICSSON_SECURITY_CORBA_PROFILE_CHECK_TIMEOUT = "se.ericsson.security.corba.profile_check_timeout";
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public Profile selectProfile(List list, ClientConnectionManager clientConnectionManager, Map map) {
        for (int i = 0; i < list.size(); ++i) {
            logger.trace(1, this.getClass(), "Profile idx " + i + ": " + list.get(i).toString());
        }
        if (list.size() == 0) {
            logger.trace(1, this.getClass(), "No profiles available");
            return null;
        }
        Profile profile = null;
        if (list.size() == 1) {
            profile = (Profile)list.get(0);
        } else if (!System.getProperty(SE_ERICSSON_SECURITY_CORBA_PROFILE_CHECK_ENABLED, "true").equalsIgnoreCase("false")) {
            logger.trace(1, this.getClass(), "Profile check enabled");
            profile = this.getReachableProfile(list);
            if (profile == null) {
                logger.trace(1, this.getClass(), "No profile reachable, returning first profile");
                profile = (Profile)list.get(0);
            }
        } else {
            profile = (Profile)list.get(0);
        }
        logger.trace(1, this.getClass(), "Returning profile " + profile.toString());
        return profile;
    }

    public boolean selectNext(Map map) {
        return false;
    }

    private Profile getReachableProfile(List list) {
        int n = 10000;
        try {
            n = Integer.parseInt(System.getProperty(SE_ERICSSON_SECURITY_CORBA_PROFILE_CHECK_TIMEOUT, "10000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        IIOPProfile iIOPProfile = null;
        for (int i = 0; i < list.size(); ++i) {
            IIOPProfile iIOPProfile2 = (IIOPProfile)list.get(i);
            if (iIOPProfile2 == null) continue;
            String string = ((IIOPAddress)iIOPProfile2.getAddress()).getHostname();
            int n2 = ((IIOPAddress)iIOPProfile2.getAddress()).getPort();
            logger.trace(1, this.getClass(), "Trying profile with address " + string);
            try {
                Socket socket = new CSUSocketFactory().createSocket(string, n2, n);
                logger.trace(1, this.getClass(), "Profile is reachable");
                iIOPProfile = iIOPProfile2;
                socket.close();
                break;
            }
            catch (Exception exception) {
                logger.trace(1, this.getClass(), "Profile is not reachable");
            }
        }
        return iIOPProfile;
    }
}

