/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import org.apache.regexp.RE;
import se.ericsson.cello.mao.DomainNameFormatException;

public class DomainNameValidation {
    private static final String START_OF_LINE = "^";
    private static final String MANDATORY_FINAL_LABEL_FOR_FQDN = "(([a-zA-Z0-9])([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]{1}\\.?)";
    private static final String OPTIONAL_PRECEDING_LABELS = "(([a-zA-Z0-9])(([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]){0,1}\\.)*";
    private static final String MANDATORY_FINAL_LABEL = "(([a-zA-Z])([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]{1})";
    private static final String END_OF_LINE = "$";
    public static final String DOMAIN_REGEX_PATTERN = "^(([a-zA-Z0-9])(([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]){0,1}\\.)*(([a-zA-Z])([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]{1})$";
    public static final String DOMAIN_REGEX_PATTERN_FOR_FQDN = "^(([a-zA-Z0-9])(([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]){0,1}\\.)*(([a-zA-Z0-9])([a-zA-Z0-9\\-]{1,61})?[a-zA-Z0-9]{1}\\.?)$";
    public static final int DOMAIN_NAME_MAX_LENGTH = 255;
    public static final int DOMAIN_NAME_MAX_LENGTH_FOR_FQDN = 254;

    public static void validate(String string) throws DomainNameFormatException {
        if (string == null) {
            throw new DomainNameFormatException("Domain name was NULL");
        }
        if (string.length() > 255) {
            throw new DomainNameFormatException("Domain names can not be longer than 255 characters");
        }
        RE rE = new RE(DOMAIN_REGEX_PATTERN);
        if (!rE.match(string)) {
            throw new DomainNameFormatException(string + " is not a valid domain name.");
        }
    }

    public static void validateForFQDN(String string) throws DomainNameFormatException {
        if (string == null) {
            throw new DomainNameFormatException("Domain name was NULL");
        }
        RE rE = new RE("[a-zA-Z]");
        if (rE.match(string)) {
            if (string.length() > 254) {
                throw new DomainNameFormatException("Domain names can not be longer than 254 characters");
            }
            RE rE2 = new RE(DOMAIN_REGEX_PATTERN_FOR_FQDN);
            if (!rE2.match(string)) {
                throw new DomainNameFormatException(string + " is not a valid domain name.");
            }
        } else {
            throw new DomainNameFormatException(string + " Invalid format of Ipv4 or Ipv6 Address and domain name");
        }
    }
}

