/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mao.AddElementAction;
import se.ericsson.cello.mao.CollectionAction;
import se.ericsson.cello.mao.RemoveElementAction;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionWrapper;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;

public class TransactionalList {
    private List storage = new ArrayList();
    private TransactionHandler handler;

    public TransactionalList(TransactionHandler transactionHandler) {
        this.handler = transactionHandler;
    }

    public void add(Object object, Coordinator coordinator) throws TransactionRequiredException {
        if (!this.contains(object, coordinator)) {
            this.getTransaction(coordinator).register(new AddElementAction(object, this.storage));
        }
    }

    public void add(Object object) {
        if (!this.storage.contains(object)) {
            this.storage.add(object);
        }
    }

    public void remove(Object object, Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
        while (this.contains(object, coordinator)) {
            this.getTransaction(coordinator).register(new RemoveElementAction(object, this.storage));
        }
    }

    public int size(Coordinator coordinator) throws TransactionRequiredException {
        return this.determineReadSource(coordinator).size();
    }

    public Object[] toArray(Coordinator coordinator, Object[] objectArray) throws TransactionRequiredException {
        return this.determineReadSource(coordinator).toArray(objectArray);
    }

    public boolean contains(Object object, Coordinator coordinator) throws TransactionRequiredException {
        return this.determineReadSource(coordinator).contains(object);
    }

    List determineReadSource(Coordinator coordinator) throws TransactionRequiredException {
        List list = this.storage;
        if (coordinator != null && this.getTransaction(coordinator).resources().hasNext()) {
            list = this.previewStorage(coordinator);
        }
        return list;
    }

    private List previewStorage(Coordinator coordinator) throws TransactionRequiredException {
        ArrayList arrayList = new ArrayList(this.storage);
        Iterator iterator = this.getTransaction(coordinator).resources();
        while (iterator.hasNext()) {
            CollectionAction collectionAction = (CollectionAction)iterator.next();
            collectionAction.preview(arrayList);
        }
        return arrayList;
    }

    private TransactionWrapper getTransaction(Coordinator coordinator) throws TransactionRequiredException {
        return this.handler.getTransaction(coordinator);
    }
}

