/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.util.library;

import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.productinventory.UpSwData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;

public class Lib {
    public static final String EMPTY_STRING = "";
    public static final String WHITE_SPACE = " ";
    private static final char WHITE_SPACE_CHAR = ' ';

    public static AttrList clone(AttrList attrList) {
        if (attrList == null) {
            return null;
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        String string = null;
        Object object = null;
        try {
            for (int i = 0; i < attrList.size(); ++i) {
                string = attrList.getName(i);
                object = attrList.getValue(i);
                attrListImpl.addElement(string, object);
            }
            return attrListImpl;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "clone(AttrList anAttrList)", "Throwable caught when trying to clone the AttrList data to an other AttrList.\n\tanAttrList: " + attrList + "\n\ttheName:" + string + "\n\ttheValue:" + object + "\n\tThrowable data: " + throwable.toString(), throwable);
            return attrList;
        }
    }

    public static String convertByteArrayToString(byte[] byArray) {
        UpgradeTrace.debug(Lib.class, 70, "convertByteArrayToString(byte[ ] aByteArray)", "aByteArray: " + new String(byArray));
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if ((char)byArray[i] != '\u0000') continue;
            n = i + 1;
            break;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray).trim();
    }

    public static boolean convertIntToBoolean(int n) {
        UpgradeTrace.debug(Lib.class, 70, "convertIntToBoolean(int anInt)", "anInt: " + n);
        return n != 0;
    }

    public static boolean convertLongToInvertedBoolean(long l) {
        UpgradeTrace.debug(Lib.class, 70, "convertLongToInvertedBoolean(long aLong)", "aLong: " + l);
        return l == 0L;
    }

    public static byte[] convertStringToByteArray(String string, int n) {
        UpgradeTrace.debug(Lib.class, 70, "convertStringToByteArray(String aString, int aByteArrayLength)", "aString: " + string + "\n\taByteArrayLength: " + n);
        byte[] byArray = new byte[n];
        char[] cArray = new char[n];
        int n2 = string.length() <= n ? string.length() : n;
        string.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String toString(File file) {
        String string = "NULL";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static String toString(ManagedObject[] managedObjectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (i < managedObjectArray.length - 1) {
                        stringBuffer.append(managedObjectArray[i]);
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(managedObjectArray[i]);
                    stringBuffer.append(" ]");
                }
                if (managedObjectArray.length == 0) {
                    stringBuffer.append("]");
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Exception exception) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + stringBuffer.toString() + "\n\tException data: " + exception.toString(), exception);
            return stringBuffer.toString();
        }
        catch (Error error) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + stringBuffer.toString() + "\n\tError data: " + error.toString(), error);
            return stringBuffer.toString();
        }
    }

    public static String toString(AdditionalInfo[] additionalInfoArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        try {
            if (additionalInfoArray != null) {
                if (additionalInfoArray.length == 0) {
                    return "[]";
                }
                for (int i = 0; i < additionalInfoArray.length; ++i) {
                    if (i < additionalInfoArray.length - 1) {
                        stringBuffer.append(Lib.toString(additionalInfoArray[i]));
                        stringBuffer.append(",\n");
                        continue;
                    }
                    stringBuffer.append(Lib.toString(additionalInfoArray[i]));
                    stringBuffer.append("]");
                }
                return stringBuffer.toString();
            }
            return "[]";
        }
        catch (Exception exception) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + stringBuffer.toString() + "\n\tException data: " + exception.toString(), exception);
            return stringBuffer.toString();
        }
        catch (Error error) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + stringBuffer.toString() + "\n\tError data: " + error.toString(), error);
            return stringBuffer.toString();
        }
    }

    public static boolean isContainingWhiteSpaceOrLowerCase(String string) {
        if (string != null) {
            if (Lib.containsWhiteSpace(string)) {
                return true;
            }
            if (Lib.containsLowerCase(string)) {
                return true;
            }
        }
        return false;
    }

    public static String optimize(String string) {
        if (string != null) {
            if (Lib.containsWhiteSpace(string)) {
                string = Lib.removeWhiteSpaces(string);
            }
            if (Lib.containsLowerCase(string)) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    public static boolean containsWhiteSpace(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsLowerCase(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String removeWhiteSpaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, WHITE_SPACE);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static String toString(AdditionalInfo additionalInfo) {
        try {
            return "{ " + additionalInfo.getName() + ", " + additionalInfo.getValue() + " }";
        }
        catch (Exception exception) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + exception.toString(), exception);
            return "{ " + additionalInfo + " }";
        }
        catch (Error error) {
            UpgradeTrace.error(Lib.class, "toString(ManagedObject[] aManagedObjects)", "Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + error.toString(), error);
            return "{ " + additionalInfo + " }";
        }
    }

    public static String toString(StringTokenizer stringTokenizer) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(StringTokenizer aStringTokenizer)", "Throwable caught when trying to translate the StringTokenizer to a string.\n\taStringTokenizer: " + stringTokenizer + "\n\ttheStringTokenizerString:" + stringBuffer.toString() + "\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (i < nArray.length - 1) {
                        stringBuffer.append(nArray[i]);
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(nArray[i]);
                    stringBuffer.append(" ]");
                }
                if (nArray.length == 0) {
                    return stringBuffer.append("]").toString();
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(int[] anIntArray)", "Throwable caught when trying to translate an int Array to a String.\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(Struct struct) {
        if (struct != null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String[] stringArray = struct.getNames();
                Object[] objectArray = struct.getValues();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("\n\t");
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(": ");
                    stringBuffer.append(objectArray[i]);
                }
            }
            catch (Exception exception) {
                UpgradeTrace.debug(Lib.class, 72, "toString(Struct aStruct)", "Exception caught: " + exception.toString());
                stringBuffer.append(exception.toString());
            }
            return stringBuffer.toString();
        }
        return "NULL";
    }

    public static String toString(Struct[] structArray) {
        if (structArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < structArray.length; ++i) {
                stringBuffer.append("\n\tarray index: ");
                stringBuffer.append(i);
                stringBuffer.append(Lib.toString(structArray[i]));
            }
            return stringBuffer.toString();
        }
        return "NULL";
    }

    public static String toString(Coordinator coordinator) {
        String string = EMPTY_STRING;
        if (coordinator != null) {
            try {
                int n = coordinator.getTransactionID();
                string = string + "\n\t\tTransaction ID: " + n;
                String string2 = "UNKNOWN";
                if (coordinator.getStatus() == Status.ACTIVE) {
                    string2 = "ACTIVE";
                } else if (coordinator.getStatus() == Status.MARKED_ROLLBACK) {
                    string2 = "MARKED_ROLLBACK";
                } else if (coordinator.getStatus() == Status.NO_TRANSACTION) {
                    string2 = "NO_TRANSACTION";
                }
                string = string + "\n\t\tTransaction status: " + string2;
            }
            catch (Exception exception) {
                UpgradeTrace.debug(Lib.class, 72, "toString(Coordinator aCoordinator)", "Exception caught: " + exception.toString());
                string = string + exception.toString();
            }
            return string;
        }
        return "null";
    }

    public static String toString(AttrList attrList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (attrList == null) {
                return "null";
            }
            for (int i = 0; i < attrList.size(); ++i) {
                stringBuffer.append("\n\t");
                stringBuffer.append(attrList.getName(i));
                stringBuffer.append(": ");
                stringBuffer.append(attrList.getValue(i));
                if (i >= attrList.size() - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("\n]");
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(AttrList anAttrList)", "Throwable caught when trying to translate the AttrList data to a string.\n\tanAttrList: " + attrList + "\n\ttheString:" + stringBuffer.toString() + "\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(SequenceAttribute sequenceAttribute) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                StringAttribute stringAttribute = (StringAttribute)enumeration.nextElement();
                stringBuffer.append(stringAttribute.getValue(null));
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(SequenceAttribute aSeq)", "Throwable caught when trying to translate the SequenceAttribute to a string.\n\taSeq: " + sequenceAttribute + "\n\ttheSeqAttrString:" + stringBuffer.toString() + "\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i < stringArray.length - 1) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(" ]");
                }
                if (stringArray.length == 0) {
                    return stringBuffer.append("]").toString();
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(String[] aStringArray)", "Throwable caught when trying to translate a String Array to a String.\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpSwData[] upSwDataArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (upSwDataArray != null) {
                for (int i = 0; i < upSwDataArray.length; ++i) {
                    if (i < upSwDataArray.length - 1) {
                        stringBuffer.append(upSwDataArray[i].productNumber);
                        stringBuffer.append("\t");
                        stringBuffer.append(upSwDataArray[i].revision);
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(upSwDataArray[i].productNumber);
                    stringBuffer.append("\t");
                    stringBuffer.append(upSwDataArray[i].revision);
                    stringBuffer.append(" ]");
                }
                if (upSwDataArray.length == 0) {
                    return stringBuffer.append("]").toString();
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(UpSwData[] anUpSwList)", "Throwable caught when trying to translate an UpSwData Array to a String.\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpgradePackageProductData.UpStatus upStatus) {
        String string = "UnknownStatus";
        try {
            if (upStatus != null) {
                if (upStatus.equals(UpgradePackageProductData.PARTIALLY_INSTALLED)) {
                    string = "PARTIALLY_INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.INSTALLED)) {
                    string = "INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.SYSTEMUSED)) {
                    string = "SYSTEMUSED";
                } else if (upStatus.equals(UpgradePackageProductData.EXECUTING)) {
                    string = "EXECUTING";
                } else if (upStatus.equals(UpgradePackageProductData.ONLYDELETABLE)) {
                    string = "ONLYDELETABLE";
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(UpStatus anUP_Status)", "Throwable caught when trying to translate an UpState to a String.\n\tanUP_Status: " + upStatus + "\n\tException data: " + throwable.toString(), throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static Vector translateToVector(Object[] objectArray) {
        UpgradeTrace.debug(Lib.class, 70, "translateToVector(Object[] anObjects)", "anObjects: " + Lib.toString(objectArray));
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public static synchronized LinkedList getSubStrings(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(string2, n);
            string3 = Lib.getSubString(string, n, n2);
            linkedList.addLast(string3);
            n = n2 + 1;
        }
        return linkedList;
    }

    private static String getSubString(String string, int n, int n2) {
        if (n2 != -1) {
            return string.substring(n, n2);
        }
        return string.substring(n);
    }

    public static String toString(Object[] objectArray) {
        if (objectArray instanceof Struct[]) {
            return Lib.toString((Struct[])objectArray);
        }
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append('[');
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        try {
            if (lArray != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    if (i < lArray.length - 1) {
                        stringBuffer.append(lArray[i]);
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(lArray[i]);
                    stringBuffer.append(" ]");
                }
                if (lArray.length == 0) {
                    return stringBuffer.append("]").toString();
                }
                return stringBuffer.toString();
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(Lib.class, "toString(int[] anLongArray)", "Throwable caught when trying to translate an int Array to a String.\n\tException data: " + throwable.toString(), throwable);
            return stringBuffer.toString() + " (Note: The string is not complete due to Throwable caught.)";
        }
    }
}

