/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.am;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.TimeBase.UtcT;
import org.threegppsa5.CommonIRPConstDefs.IRPTimeHelper;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotificationSetTypeHelper;
import se.ericsson.cello.emas.fm.am.AnyConverter;
import se.ericsson.cello.emas.fm.common.EventType;
import se.ericsson.cello.emas.fm.common.ProbablyCause;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.Severity;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.MOProxy;

public class AlarmRecord
implements RowDataInterface {
    private static ResourceBundle myBundle = null;
    private static List myDefinedProperties = null;
    private static Map myConversionNames = null;
    private static Short myAckStateAcknowlege = new Short(1);
    private Map myAttributeValue = new HashMap();
    private boolean ackIsAvailable;

    public AlarmRecord(StructuredEvent entry, boolean hasAck) {
        Object obj;
        EventType eventType;
        this.ackIsAvailable = hasAck;
        if (myDefinedProperties == null) {
            this.defineProperties();
        }
        if (myConversionNames == null) {
            this.defineConversionNames();
        }
        int numFilterablePropertiesInSE = entry.filterable_data.length;
        Property property = new Property();
        StringBuffer addInfo = new StringBuffer();
        StringBuffer corrNot = new StringBuffer();
        String tmpAddInfo = new String();
        for (int i = 0; i < numFilterablePropertiesInSE; ++i) {
            boolean standardProperty = false;
            property = entry.filterable_data[i];
            if (property.name.equals("MCname")) {
                standardProperty = true;
            } else if (property.name.equals("c") || property.name.equals("m")) {
                UtcT eventTimeUtcT = IRPTimeHelper.extract((Any)property.value);
                String eventTimeString = "";
                if (eventTimeUtcT.time - (long)eventTimeUtcT.inacclo != 0L) {
                    eventTimeString = new TimeConverter().formatTime(eventTimeUtcT);
                }
                this.myAttributeValue.put(this.convertName(property.name), eventTimeString);
                standardProperty = true;
            } else if (property.name.equals("h")) {
                this.myAttributeValue.put(this.convertName(property.name), Severity.getSeverity((Short)AnyConverter.toObject(property.value)));
                standardProperty = true;
            } else if (property.name.equals("g")) {
                this.myAttributeValue.put(this.convertName(property.name), new ProbablyCause((Short)AnyConverter.toObject(property.value)));
                standardProperty = true;
            } else if (property.name.equals("i")) {
                this.myAttributeValue.put(this.convertName(property.name), (String)AnyConverter.toObject(property.value));
                this.myAttributeValue.put("SPECIFIC_PROBLEM", (String)AnyConverter.toObject(property.value));
                standardProperty = true;
            } else if (property.name.equals("b")) {
                for (int j = 0; j < CorrelatedNotificationSetTypeHelper.extract((Any)entry.filterable_data[i].value).length; ++j) {
                    corrNot.append("managedObjectInstance: " + CorrelatedNotificationSetTypeHelper.extract((Any)property.value)[j].source);
                    corrNot.append("   ");
                    corrNot.append("notificationID: " + CorrelatedNotificationSetTypeHelper.extract((Any)property.value)[j].notifIDSet[0]);
                    if (j != CorrelatedNotificationSetTypeHelper.extract((Any)entry.filterable_data[i].value).length - 1) {
                        corrNot.append(" | ");
                    }
                    this.myAttributeValue.put("CORRELATED_NOTIFICATIONS", corrNot);
                }
                standardProperty = true;
            } else if (myDefinedProperties.contains(property.name)) {
                this.myAttributeValue.put(this.convertName(property.name), AnyConverter.toObject(property.value));
                standardProperty = true;
            }
            if (standardProperty) continue;
            addInfo.append(property.name);
            addInfo.append(": ");
            addInfo.append(AnyConverter.toStringType(property.value));
            addInfo.append(" | ");
            if (!property.name.equals("userLabel")) continue;
            this.myAttributeValue.put("USERLABEL", AnyConverter.toStringType(property.value));
        }
        if (!addInfo.toString().equals("")) {
            this.myAttributeValue.put("ADDITIONAL_INFORMATION", addInfo);
        }
        if ((eventType = EventType.getEventType(entry.header.fixed_header.event_type.type_name)) != null) {
            this.myAttributeValue.put("EVENT_TYPE", eventType);
        }
        if ((obj = this.myAttributeValue.get("MANAGED_OBJECT_INSTANCE")) != null) {
            MOProxy mo = new MOProxy(obj.toString());
            this.myAttributeValue.put("MANAGED_OBJECT_INSTANCE", mo.getDN());
        } else {
            Log.logNotify((String)"No MANAGED_OBJECT_INSTANCE found");
        }
        if (this.ackIsAvailable && this.checkAckAlarm()) {
            StringBuffer ackBuf = new StringBuffer();
            ackBuf.append((String)this.myAttributeValue.get("ACK_USER_ID"));
            ackBuf.append(" - ");
            ackBuf.append((String)this.myAttributeValue.get("ACK_TIME"));
            this.myAttributeValue.put("ACK", ackBuf.toString());
        }
    }

    public boolean checkAckAlarm() {
        Object obj = this.myAttributeValue.get(this.convertName("o"));
        if (obj != null) {
            return obj.equals(myAckStateAcknowlege);
        }
        return false;
    }

    public String getAlarmId() {
        return (String)this.myAttributeValue.get("ALARM_ID");
    }

    public Severity getSeverity() {
        return (Severity)this.myAttributeValue.get("SEVERITY");
    }

    public String getSpecificProblem() {
        return (String)this.myAttributeValue.get("SPECIFIC_PROBLEM");
    }

    public String getManagedObjectInstance() {
        return (String)this.myAttributeValue.get("MANAGED_OBJECT_INSTANCE");
    }

    public Object getValueAt(String colName) {
        Object obj = this.myAttributeValue.get(colName);
        if (obj == null) {
            return "";
        }
        return obj;
    }

    public String getAdditionalInfo(ResourceBundle bundle) {
        String tmp;
        StringTokenizer st;
        StringBuffer strBuf = new StringBuffer();
        String fontName = new String("Arial");
        strBuf.append("<html>");
        strBuf.append("<FONT FACE=");
        strBuf.append('\"');
        strBuf.append(fontName);
        strBuf.append('\"');
        strBuf.append(">");
        strBuf.append("<font size = -1>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ALARM_ID_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("ALARM_ID"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("PERCEIVED_SEVERITY_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SEVERITY"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TIME_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EVENT_TIME"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TYPE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EVENT_TYPE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ADDITIONAL_TEXT_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("ADDITIONAL_TEXT"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("PROBABLE_CAUSE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("PROBABLE_CAUSE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SPECIFIC_PROBLEM_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SPECIFIC_PROBLEM"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_CLASS_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_CLASS"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_INSTANCE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_INSTANCE"));
        strBuf.append("<BR>");
        if (this.ackIsAvailable && !this.getStringValue("ACK_SYSTEM_ID").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ACK_SYSTEM_ID_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("ACK_SYSTEM_ID"));
            strBuf.append("<BR>");
        }
        if (this.ackIsAvailable && !this.getStringValue("ACK_USER_ID").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ACK_USER_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("ACK_USER_ID"));
            strBuf.append("<BR>");
        }
        if (this.ackIsAvailable && !this.getStringValue("ACK_TIME").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ACK_TIME_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("ACK_TIME"));
            strBuf.append("<BR>");
        }
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SYSTEM_DN_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SYSTEM_DN"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("NOTIFICATION_ID_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("NOTIFICATION_ID"));
        strBuf.append("<BR>");
        if (!this.getStringValue("CORRELATED_NOTIFICATIONS").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("CORRELATED_NOTIFICATIONS_DETAILS"));
            strBuf.append("</b>");
            strBuf.append("<ul>");
            String corrList = this.getStringValue("CORRELATED_NOTIFICATIONS");
            st = new StringTokenizer(corrList, "|", false);
            while (st.hasMoreTokens()) {
                tmp = st.nextToken();
                strBuf.append("<li>");
                strBuf.append(tmp);
                strBuf.append("</li>");
            }
            strBuf.append("</ul>");
            strBuf.append("<BR>");
        }
        if (!this.getStringValue("PROPOSED_REPAIRED_ACTIONS").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("PROPOSED_REPAIRED_ACTIONS_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("PROPOSED_REPAIRED_ACTIONS"));
            strBuf.append("<BR>");
        }
        if (!this.getStringValue("ADDITIONAL_INFORMATION").equals("")) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ADDITIONAL_INFORMATION_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append("<ul>");
            String addStr = this.getStringValue("ADDITIONAL_INFORMATION");
            st = new StringTokenizer(addStr, "|", false);
            while (st.hasMoreTokens()) {
                tmp = st.nextToken();
                if (tmp.equals(" ")) continue;
                strBuf.append("<li>");
                strBuf.append(tmp);
                strBuf.append("</li>");
            }
            strBuf.append("</ul>");
            strBuf.append("<BR>");
        }
        strBuf.append("</font>");
        strBuf.append("</html>");
        return strBuf.toString();
    }

    public String toString() {
        return this.myAttributeValue.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlarmRecord) {
            AlarmRecord elr = (AlarmRecord)obj;
            String alarmIdObj = elr.getAlarmId();
            String alarmIdThis = this.getAlarmId();
            return alarmIdObj.equals(alarmIdThis);
        }
        return false;
    }

    public int hashCode() {
        return this.getStringValue("NOTIFICATION_ID").hashCode();
    }

    public String getEventTime() {
        return (String)this.myAttributeValue.get("EVENT_TIME");
    }

    public EventType getEventType() {
        return (EventType)this.myAttributeValue.get("EVENT_TYPE");
    }

    public String getNotificationId() {
        return (String)this.myAttributeValue.get("NOTIFICATION_ID");
    }

    public String getStringValue(String tag) {
        Object obj = this.myAttributeValue.get(tag);
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private boolean isAckAvailable() {
        return this.ackIsAvailable;
    }

    private void defineProperties() {
        myDefinedProperties = new ArrayList();
        myDefinedProperties.add("h");
        myDefinedProperties.add("k");
        myDefinedProperties.add("g");
        myDefinedProperties.add("j");
        myDefinedProperties.add("f");
        myDefinedProperties.add("d");
        myDefinedProperties.add("e");
        myDefinedProperties.add("i");
        myDefinedProperties.add("a");
        myDefinedProperties.add("o");
        myDefinedProperties.add("l");
        myDefinedProperties.add("b");
        myDefinedProperties.add("n");
        myDefinedProperties.add("v");
    }

    private void defineConversionNames() {
        myConversionNames = new HashMap();
        myConversionNames.put("h", "SEVERITY");
        myConversionNames.put("k", "ALARM_ID");
        myConversionNames.put("g", "PROBABLE_CAUSE");
        myConversionNames.put("j", "ADDITIONAL_TEXT");
        myConversionNames.put("f", "MANAGED_OBJECT_INSTANCE");
        myConversionNames.put("d", "SYSTEM_DN");
        myConversionNames.put("e", "MANAGED_OBJECT_CLASS");
        myConversionNames.put("i", "SPECIFIC_PROBLEM");
        myConversionNames.put("a", "NOTIFICATION_ID");
        myConversionNames.put("o", "ACK_STATE");
        myConversionNames.put("l", "ACK_USER_ID");
        myConversionNames.put("b", "CORRELATED_NOTIFICATIONS");
        myConversionNames.put("n", "ACK_SYSTEM_ID");
        myConversionNames.put("v", "PROPOSED_REPAIRED_ACTIONS");
        myConversionNames.put("c", "EVENT_TIME");
        myConversionNames.put("m", "ACK_TIME");
    }

    private String convertName(String str) {
        String tmpStr = (String)myConversionNames.get(str);
        if (tmpStr == null) {
            tmpStr = str;
        }
        return tmpStr;
    }
}

