/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.ericsson.cello.emas.fm.common.BevelArrowIcon;

class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    public static final int NONE_SORT = 0;
    public static final int DOWN_SORT = 1;
    public static final int UP_SORT = 2;
    int pushColumn = -1;
    Hashtable states = new Hashtable();
    JButton dButton;
    JButton uButton;
    private int lastRenderedColumn = 0;
    private String[] toolTips = null;

    public SortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.dButton = new JButton();
        this.dButton.setMargin(new Insets(0, 0, 0, 0));
        this.dButton.setHorizontalTextPosition(2);
        this.dButton.setIcon(new BevelArrowIcon(1, false, true));
        this.dButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.uButton = new JButton();
        this.uButton.setMargin(new Insets(0, 0, 0, 0));
        this.uButton.setHorizontalTextPosition(2);
        this.uButton.setIcon(new BevelArrowIcon(0, false, true));
        this.uButton.setPressedIcon(new BevelArrowIcon(0, false, true));
    }

    public void setColumnToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.toolTips != null && this.lastRenderedColumn < this.toolTips.length) {
            return this.toolTips[this.lastRenderedColumn];
        }
        return super.getToolTipText(event);
    }

    public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton theButton = this;
        this.lastRenderedColumn = column;
        Object obj = this.states.get(new Integer(column));
        if (obj != null) {
            theButton = (Integer)obj == 1 ? this.dButton : this.uButton;
        }
        theButton.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pushColumn;
        theButton.getModel().setPressed(isPressed);
        theButton.getModel().setArmed(isPressed);
        return theButton;
    }

    public void setPressedColumn(int col) {
        this.pushColumn = col;
    }

    public boolean isSelectedColumn(int column) {
        if (column < 0) {
            return false;
        }
        return this.states.get(new Integer(column)) != null;
    }

    public void setSelectedColumn(int column) {
        if (column < 0) {
            return;
        }
        Integer v = null;
        Object obj = this.states.get(new Integer(column));
        v = obj == null ? new Integer(2) : ((Integer)obj == 1 ? new Integer(2) : new Integer(1));
        this.states.clear();
        this.states.put(new Integer(column), v);
    }

    public void pressedColumnMoved(int col) {
        int oldState = this.getState(this.pushColumn);
        this.states.clear();
        this.states.put(new Integer(col), new Integer(oldState));
        this.setPressedColumn(col);
    }

    public int getState(int col) {
        Object obj = this.states.get(new Integer(col));
        int returnValue = obj == null ? 0 : ((Integer)obj == 1 ? 1 : 2);
        return returnValue;
    }
}

