/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class ChangeHwuPiuTypeReferenceAction
implements MoDataAction {
    private static final String PIU_TYPE = "piuType";
    private static final String PIU_TYPE_MO = "PiuType";
    private static final String RESERVED_BY = "reservedBy";
    private static final Class THIS_CLASS = ChangeHwuPiuTypeReferenceAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String OLD_REF_PART1 = "BGM1361006/1";
    private static final String NEW_REF_PART1 = "SCU00000_*";
    private static final String OLD_REF_PART2 = "ZHY60117/1";
    private static final String NEW_REF_PART2 = "SAU00000_*";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(PIU_TYPE);
        if (referenceAttribute != null) {
            String string = referenceAttribute.getReferenceAsLDN();
            if (string.indexOf(OLD_REF_PART1) != -1) {
                this.doChange(moDataWrapper, OLD_REF_PART1, NEW_REF_PART1, converterContext, coordinator);
            } else if (string.indexOf(OLD_REF_PART2) != -1) {
                this.doChange(moDataWrapper, OLD_REF_PART2, NEW_REF_PART2, converterContext, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void doChange(MoDataWrapper moDataWrapper, String string, String string2, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        String string3;
        MoDataWrapper moDataWrapper2;
        logger.traceEnter(THIS_CLASS, "doChange()");
        ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(PIU_TYPE);
        boolean bl = false;
        boolean bl2 = false;
        MoDataWrapper moDataWrapper3 = null;
        MoDataWrapper moDataWrapper4 = null;
        ReferenceAttribute referenceAttribute2 = null;
        Collection collection = converterContext.getMoDataAccessor().getByType(PIU_TYPE_MO);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moDataWrapper2 = (MoDataWrapper)iterator.next();
            string3 = moDataWrapper2.getLocalDistinguishedName();
            if (string3 == null || string3.indexOf(string2) == -1) continue;
            moDataWrapper3 = moDataWrapper2;
            referenceAttribute2 = new ReferenceAttribute(PIU_TYPE, string3, false);
            bl = true;
            break;
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            moDataWrapper2 = (MoDataWrapper)iterator.next();
            string3 = moDataWrapper2.getLocalDistinguishedName();
            if (string3 == null || string3.indexOf(string) == -1) continue;
            moDataWrapper4 = moDataWrapper2;
            bl2 = true;
            break;
        }
        if (bl && bl2) {
            moDataWrapper.deregisterAttribute((Attribute)referenceAttribute);
            moDataWrapper.registerPersistentAttr(referenceAttribute2);
            this.removeReservedByOnOldPiuType(moDataWrapper, coordinator, moDataWrapper4);
            this.setReservedByOnNewPiuType(moDataWrapper, moDataWrapper3);
        }
        logger.traceReturn(THIS_CLASS, "doChange()");
    }

    private void removeReservedByOnOldPiuType(MoDataWrapper moDataWrapper, Coordinator coordinator, MoDataWrapper moDataWrapper2) {
        logger.traceEnter(THIS_CLASS, "removeReservedByOnOldPiuType()");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper2.getAttribute(RESERVED_BY);
        if (sequenceAttribute != null) {
            Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
            for (int i = 0; i < sequenceAttribute.size(); ++i) {
                if (!((ReferenceAttribute)attributeArray[i]).getReferenceAsLDN().endsWith(moDataWrapper.getLocalDistinguishedName())) continue;
                sequenceAttribute.removeElement(attributeArray[i]);
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "removeReservedByOnOldPiuType()");
    }

    private void setReservedByOnNewPiuType(MoDataWrapper moDataWrapper, MoDataWrapper moDataWrapper2) {
        logger.traceEnter(THIS_CLASS, "setReservedByOnNewPiuType()");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper2.getAttribute(RESERVED_BY);
        if (sequenceAttribute != null) {
            String string = moDataWrapper.getLocalDistinguishedName();
            ReferenceAttribute referenceAttribute = new ReferenceAttribute(PIU_TYPE, string, false);
            sequenceAttribute.addElement((Attribute)referenceAttribute);
        }
        logger.traceReturn(THIS_CLASS, "setReservedByOnNewPiuType()");
    }
}

