/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.ReplaceInAllLDNs;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class CreateEquipmentSupportFunctionAction
implements MoDataAction {
    private static final Class THIS_CLASS = CreateEquipmentSupportFunctionAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String CABINET_TYPE = "Cabinet";
    protected static final String EQUIPMENT_RDN = "Equipment=1";
    protected static final String EQUIPMENT_SUPPORT_FUNCTION_RDN = "EquipmentSupportFunction=1";
    protected static final String EQUIPMENT_SUPPORT_FUNCTION_LDN = "ManagedElement=1,EquipmentSupportFunction=1";
    protected static final String BATTERY_BACKUP_TYPE = "BatteryBackup";
    protected static final String POWER_DISTRIBUTION_TYPE = "PowerDistribution";
    protected static final String POWER_SUPPLY_TYPE = "PowerSupply";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            MoDataWrapper moDataWrapper2 = moDataAccessor.create(EQUIPMENT_SUPPORT_FUNCTION_LDN, coordinator);
            IntegerAttribute integerAttribute = new IntegerAttribute("froId", false, 0);
            moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            moDataWrapper2.registerPersistentAttr((Attribute)integerAttribute);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        this.executeReplaceInAllLdns(BATTERY_BACKUP_TYPE, converterContext, coordinator);
        this.executeReplaceInAllLdns(POWER_DISTRIBUTION_TYPE, converterContext, coordinator);
        this.executeReplaceInAllLdns(POWER_SUPPLY_TYPE, converterContext, coordinator);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void executeReplaceInAllLdns(String string, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "executeReplaceInAllLdns(" + string + ")");
        ReplaceInAllLDNs replaceInAllLDNs = new ReplaceInAllLDNs(EQUIPMENT_RDN, EQUIPMENT_SUPPORT_FUNCTION_RDN);
        Collection collection = converterContext.getMoDataAccessor().getByType(string);
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    replaceInAllLDNs.perform((MoDataWrapper)iterator.next(), converterContext, coordinator);
                }
                catch (AueException aueException) {
                    CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                    crbsAueException.setStackTrace(aueException.getStackTrace());
                    throw crbsAueException;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "executeReplaceInAllLdns(" + string + ")");
    }
}

