/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal.omsi_version;

import java.io.InvalidClassException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import se.ericsson.cello.neal.JarVersionError;
import se.ericsson.cello.neal.internal.JarVersionInfo;
import se.ericsson.cello.neal.internal.omsi_version.AbstractOmsiAdapter;
import se.ericsson.cello.neal.internal.omsi_version.OmsiVersionInfo;

public class OmsiAndAdapterTypeInfo {
    private static OmsiVersionInfo omsiVersion = OmsiVersionInfo.instance();
    final Class omsiClass;
    final Class adapterClass;
    final Class omsiArray;
    final Class adapterArray;
    final Field[] omsiFields;
    final Field[] adapterFields;
    final OmsiAndAdapterTypeInfo[] fieldTypeInfo;

    public OmsiAndAdapterTypeInfo(Class clazz, Class clazz2) {
        this.omsiClass = clazz;
        this.adapterClass = clazz2;
        this.omsiArray = OmsiAndAdapterTypeInfo.getArrayClass(clazz);
        this.adapterArray = OmsiAndAdapterTypeInfo.getArrayClass(clazz2);
        this.omsiFields = clazz.getFields();
        this.adapterFields = OmsiAndAdapterTypeInfo.getAdapterFields(clazz2, clazz, this.omsiFields);
        this.fieldTypeInfo = OmsiAndAdapterTypeInfo.getFieldTypeInfo(this.omsiFields, this.adapterFields);
        omsiVersion.newInstance(clazz);
        omsiVersion.newInstance(clazz2);
    }

    private static Class getArrayClass(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    private static Field[] getAdapterFields(Class clazz, Class clazz2, Field[] fieldArray) {
        Field[] fieldArray2 = new Field[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            String string = field.getName();
            try {
                Field field2;
                fieldArray2[i] = field2 = clazz.getField(string);
                if (OmsiAndAdapterTypeInfo.isStatic(field) == OmsiAndAdapterTypeInfo.isStatic(field2)) continue;
                throw new JarVersionError((JarVersionInfo)omsiVersion, "One is static and one dynamic of Fields " + clazz2.getName() + "#" + string + " and " + clazz.getName() + "#" + string + "!");
            }
            catch (Exception exception) {
                throw new JarVersionError(omsiVersion, "Failed retreiving Field " + clazz2.getName() + "#" + string + " from adapterClass=" + clazz.getName() + "!", exception);
            }
        }
        return fieldArray2;
    }

    private static OmsiAndAdapterTypeInfo[] getFieldTypeInfo(Field[] fieldArray, Field[] fieldArray2) {
        OmsiAndAdapterTypeInfo[] omsiAndAdapterTypeInfoArray = new OmsiAndAdapterTypeInfo[fieldArray2.length];
        for (int i = 0; i < omsiAndAdapterTypeInfoArray.length; ++i) {
            omsiAndAdapterTypeInfoArray[i] = OmsiAndAdapterTypeInfo.getFieldTypeInfo(fieldArray[i], fieldArray2[i]);
        }
        return omsiAndAdapterTypeInfoArray;
    }

    private static OmsiAndAdapterTypeInfo getFieldTypeInfo(Field field, Field field2) {
        Class<?> clazz = field.getType();
        Class<?> clazz2 = field2.getType();
        if (clazz2 == clazz) {
            return null;
        }
        while (clazz2.isArray()) {
            if (!clazz.isArray()) {
                throw new JarVersionError((JarVersionInfo)omsiVersion, "Adapter Field='" + field2 + "', is an array, but corresponding" + "\n  Omsi Field='" + field + "' is not array of same dimension!");
            }
            clazz = clazz.getComponentType();
            clazz2 = clazz2.getComponentType();
        }
        if (clazz.isArray()) {
            throw new JarVersionError((JarVersionInfo)omsiVersion, "Omsi Field='" + field + "', is an array, but corresponding" + "\n  Adapter Field='" + field2 + "' is not array of same dimension!");
        }
        if (!OmsiAndAdapterTypeInfo.isAdapter(clazz2)) {
            throw new JarVersionError((JarVersionInfo)omsiVersion, "Omsi Field='" + field + "', has different type from " + "\n  Adapter Field='" + field2 + "' which is not an adapter type!");
        }
        OmsiAndAdapterTypeInfo omsiAndAdapterTypeInfo = OmsiAndAdapterTypeInfo.getTypeInfo(clazz2);
        if (omsiAndAdapterTypeInfo.adapterClass != clazz2) {
            throw new JarVersionError(null, "INTENAL NEAL ERROR!\n  Adapter Field='" + field2 + "'\n  is of INCONSICTENT Adapter Class!" + "\n  Its typeInfo field    adapterClass=" + omsiAndAdapterTypeInfo.adapterClass.getName() + "\n  differs from expected adapterClass=" + clazz2.getName() + "!");
        }
        if (omsiAndAdapterTypeInfo.omsiClass != clazz) {
            throw new JarVersionError((JarVersionInfo)omsiVersion, "In Adapter for Omsi Field='" + field + "',\n  the Adapter class=" + clazz2.getName() + "\n  is adapter for omsiClass=" + omsiAndAdapterTypeInfo.omsiClass.getName() + " from " + OmsiAndAdapterTypeInfo.getJar(omsiAndAdapterTypeInfo.omsiClass) + ", not for\n  expected omsiClass=" + clazz.getName() + " from " + OmsiAndAdapterTypeInfo.getJar(clazz) + "\n  Remove one of the definitions of the omsiClass from the classpath!");
        }
        return omsiAndAdapterTypeInfo;
    }

    private static OmsiAndAdapterTypeInfo getTypeInfo(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("typeInfo");
            Object object = field.get(null);
            return (OmsiAndAdapterTypeInfo)object;
        }
        catch (Exception exception) {
            throw new JarVersionError(null, "INTERNAL NEAL ERROR!\n  Failed retreiving the required static field 'typeInfo'  from Adapter class=" + clazz.getName() + "!", exception);
        }
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isAdapter(Class clazz) {
        return AbstractOmsiAdapter.class.isAssignableFrom(clazz);
    }

    public Object newOmsi() {
        return omsiVersion.newInstance(this.omsiClass);
    }

    public Object newOmsi(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(this.omsiClass, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.newOmsi(objectArray[i]);
            }
            return objectArray2;
        }
        try {
            AbstractOmsiAdapter abstractOmsiAdapter = (AbstractOmsiAdapter)object;
            Object object2 = abstractOmsiAdapter.toOmsi();
            return object2;
        }
        catch (Exception exception) {
            throw new JarVersionError(omsiVersion, "Failed crating new " + this.omsiClass.getName() + " from " + object + "!", exception);
        }
    }

    public Object[] newOmsis(Object[] objectArray) {
        return (Object[])this.newOmsi(objectArray);
    }

    public AbstractOmsiAdapter newAdapter() {
        return (AbstractOmsiAdapter)omsiVersion.newInstance(this.adapterClass);
    }

    public Object newAdapter(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(this.adapterClass, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.newAdapter(objectArray[i]);
            }
            return objectArray2;
        }
        AbstractOmsiAdapter abstractOmsiAdapter = this.newAdapter();
        try {
            abstractOmsiAdapter.setFromOmsi(object);
        }
        catch (Exception exception) {
            throw new JarVersionError(omsiVersion, "Failed crating new Adapter=" + this.adapterClass.getName() + " from Omsi=" + object + "!", exception);
        }
        return abstractOmsiAdapter;
    }

    public Object[] newAdapters(Object[] objectArray) {
        return (Object[])this.newAdapter(objectArray);
    }

    public Object convert(Object object) throws InvalidClassException {
        if (object.getClass().isArray()) {
            if (object.getClass().getComponentType() == this.omsiClass) {
                return this.newAdapters((Object[])object);
            }
            if (object.getClass().getComponentType() == this.adapterClass) {
                return this.newOmsis((Object[])object);
            }
        } else {
            if (object.getClass() == this.omsiClass) {
                return this.newAdapter(object);
            }
            if (object.getClass() == this.omsiClass) {
                return this.newOmsi(object);
            }
        }
        throw new InvalidClassException("Can't convert object of type " + object.getClass().getName() + " with Adapter for " + this.omsiClass.getName() + "!");
    }

    public void setAdapterFromOmsi(Object object, Object object2) {
        String string = "(undefined field)";
        try {
            for (int i = 0; i < this.omsiFields.length; ++i) {
                string = this.omsiFields[i].getName();
                Object object3 = this.omsiFields[i].get(object2);
                OmsiAndAdapterTypeInfo omsiAndAdapterTypeInfo = this.fieldTypeInfo[i];
                if (omsiAndAdapterTypeInfo != null) {
                    object3 = omsiAndAdapterTypeInfo.newAdapter(object3);
                }
                this.adapterFields[i].set(object, object3);
            }
        }
        catch (Exception exception) {
            throw new JarVersionError(omsiVersion, "Failed setting Field=" + string + " in adapter=" + object + " from omsi=" + object2, exception);
        }
    }

    public void setOmsiFromAdapter(Object object, Object object2) {
        String string = "(undefined field)";
        try {
            for (int i = 0; i < this.omsiFields.length; ++i) {
                string = this.omsiFields[i].getName();
                Object object3 = this.adapterFields[i].get(object2);
                OmsiAndAdapterTypeInfo omsiAndAdapterTypeInfo = this.fieldTypeInfo[i];
                if (omsiAndAdapterTypeInfo != null) {
                    object3 = omsiAndAdapterTypeInfo.newOmsi(object3);
                }
                this.omsiFields[i].set(object, object3);
            }
        }
        catch (Exception exception) {
            throw new JarVersionError(omsiVersion, "Failed setting Field=" + string + " in adapter=" + object2 + " from omsi=" + object, exception);
        }
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.isEqual(objectArray[i], objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        if (this.adapterClass != object.getClass()) {
            return object.equals(object2);
        }
        String string = "(undefined field)";
        try {
            for (int i = 0; i < this.adapterFields.length; ++i) {
                string = this.adapterFields[i].getName();
                Object object3 = this.adapterFields[i].get(object);
                Object object4 = this.adapterFields[i].get(object2);
                if (object3 == null && object4 == null) continue;
                if (object3 == null || object4 == null) {
                    return false;
                }
                OmsiAndAdapterTypeInfo omsiAndAdapterTypeInfo = this.fieldTypeInfo[i];
                if (!(omsiAndAdapterTypeInfo != null ? !omsiAndAdapterTypeInfo.isEqual(object3, object4) : !object3.equals(object4))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            throw new JarVersionError(omsiVersion, "Failed retriving Field=" + string + " in class=" + this.adapterClass.getName() + "!", exception);
        }
        return true;
    }

    public String toString(AbstractOmsiAdapter abstractOmsiAdapter) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JarVersionInfo.getShortName(abstractOmsiAdapter.getClass()));
        stringBuffer.append('{');
        for (int i = 0; i < this.adapterFields.length; ++i) {
            Field field = this.adapterFields[i];
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(field.getName()).append('=');
            Object object = omsiVersion.getFieldValue(field, abstractOmsiAdapter);
            if (field.getType().isArray()) {
                stringBuffer.append(Arrays.asList((Object[])object));
                continue;
            }
            stringBuffer.append(object);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static URL getUrl(Class clazz) {
        return JarVersionInfo.getUrl(clazz);
    }

    public static String getJar(Class clazz) {
        return JarVersionInfo.getJar(clazz);
    }
}

