/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AbstractRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.IntegerRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.LongRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StringRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AbstractAttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BiDirectionalAssociationDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BooleanDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.EnumDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.IntegerDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.LongDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SingleRefBiDirectionalAssociationDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StringDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class AttributeDataTypeFactory {
    private static final Class THIS_CLASS = AttributeDataTypeFactory.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected static final String DEFAULT_VALUE = "defaultValue";
    protected static final String SEQ_DEFAULT_VALUE = "seqDefaultValue";
    protected static final String RANGE = "range";
    protected static final String RESOLUTION = "resolution";
    protected static final String MAX = "max";
    protected static final String MIN = "min";
    protected static final String LONG = "long";
    protected static final String LONGLONG = "longlong";
    protected static final String MIN_LENGTH = "minLength";
    protected static final String ORDERED = "ordered";
    protected static final String MAX_LENGTH = "maxLength";
    protected static final String NON_UNIQUE = "nonUnique";
    protected static final String VALID_VALUES = "validValues";
    protected static final String ALPHABET = "alphabet";
    protected static final String LENGTH_RANGE = "lengthRange";

    private AttributeRange createRange(String typeId, String max, String min) {
        AbstractRange requiredRange = null;
        if (typeId.equals(LONG)) {
            requiredRange = new IntegerRange(Integer.valueOf(min), Integer.valueOf(max));
        } else if (typeId.equals("string")) {
            requiredRange = new StringRange(Integer.valueOf(min), Integer.valueOf(max));
        } else if (typeId.equals(LONGLONG)) {
            requiredRange = new LongRange(Long.valueOf(min), Long.valueOf(max));
        }
        return requiredRange;
    }

    private List createRanges(XMLElement rangeElement, String typeId) {
        ArrayList<AttributeRange> rangeData = new ArrayList<AttributeRange>();
        List ranges = rangeElement.getChildren();
        Iterator rangeIter = ranges.iterator();
        String currentMinValue = null;
        String currentMaxValue = null;
        boolean rangeComplete = false;
        while (rangeIter.hasNext()) {
            XMLElement currentRangeElement;
            if (rangeComplete) {
                rangeComplete = false;
                rangeData.add(this.createRange(typeId, currentMaxValue, currentMinValue));
            }
            if ((currentRangeElement = (XMLElement)rangeIter.next()).getType().equals(MIN)) {
                currentMinValue = currentRangeElement.getText();
                continue;
            }
            if (!currentRangeElement.getType().equals(MAX)) continue;
            currentMaxValue = currentRangeElement.getText();
            rangeComplete = true;
        }
        if (currentMinValue == null) {
            currentMinValue = String.valueOf(Integer.MIN_VALUE);
        }
        if (currentMaxValue == null) {
            currentMaxValue = String.valueOf(Integer.MAX_VALUE);
        }
        try {
            rangeData.add(this.createRange(typeId, currentMaxValue, currentMinValue));
        }
        catch (NumberFormatException e) {
            String msg = "Error in createRanges(), " + e.getMessage();
            logger.traceAbnormal(THIS_CLASS, msg);
        }
        return rangeData;
    }

    public AttributeDataType getAttributeDataType(String moType, String attributeName, XMLElement dataType) throws IOException {
        AttributeDataType data = null;
        List dataTypeChildren = dataType.getChildren();
        Iterator dataTypeChildIter = dataTypeChildren.iterator();
        XMLElement typeHolder = null;
        while (dataTypeChildIter.hasNext() && ((typeHolder = (XMLElement)dataTypeChildIter.next()).getType().equals("description") || typeHolder.getType().equals("applicationTag"))) {
        }
        String typeId = typeHolder.getType();
        data = this.getTheDataType(moType, attributeName, typeHolder, typeId);
        return data;
    }

    public AttributeDataType getBiDirAssDataType(String moType, String attributeName, XMLElement momDataTypeHolder) throws IOException {
        List typeChildren = momDataTypeHolder.getChildren();
        Iterator typeChildIter = typeChildren.iterator();
        AttributeDataType seqType = null;
        Integer maxLength = new Integer(Integer.MAX_VALUE);
        boolean nonUnique = false;
        while (typeChildIter.hasNext()) {
            XMLElement currentChild = (XMLElement)typeChildIter.next();
            if (currentChild.getType().equals(MAX_LENGTH)) {
                String maxLengthAsString = currentChild.getText();
                maxLength = new Integer(maxLengthAsString);
                continue;
            }
            if (currentChild.getType().equals(NON_UNIQUE)) {
                nonUnique = true;
                continue;
            }
            seqType = this.getAttributeDataType(moType, attributeName, momDataTypeHolder);
        }
        return new BiDirectionalAssociationDataType(seqType, maxLength, nonUnique, attributeName);
    }

    private AttributeDataType getBooleanDataType(XMLElement booleanintTag, String attributeName) {
        List booleanintTagChildren = booleanintTag.getChildren();
        Iterator booleanintTagChildrenIter = booleanintTagChildren.iterator();
        String defaultValue = null;
        while (booleanintTagChildrenIter.hasNext()) {
            XMLElement currentbooleanintTagChild = (XMLElement)booleanintTagChildrenIter.next();
            if (currentbooleanintTagChild.getType().equals(DEFAULT_VALUE)) {
                defaultValue = currentbooleanintTagChild.getText().trim();
                continue;
            }
            if (!currentbooleanintTagChild.getType().equals(SEQ_DEFAULT_VALUE)) continue;
            Iterator seqDefTagChildrenIter = currentbooleanintTagChild.getChildren().iterator();
            while (seqDefTagChildrenIter.hasNext()) {
                XMLElement currentSeqDefTagChildren = (XMLElement)seqDefTagChildrenIter.next();
                if (!currentSeqDefTagChildren.getType().equals(DEFAULT_VALUE)) continue;
                if (defaultValue == null) {
                    defaultValue = currentSeqDefTagChildren.getText().trim();
                    continue;
                }
                defaultValue = defaultValue + "," + currentSeqDefTagChildren.getText().trim();
            }
        }
        BooleanDataType result = null;
        result = defaultValue != null && (defaultValue.equalsIgnoreCase("true") || defaultValue.equalsIgnoreCase("false")) ? new BooleanDataType(Boolean.valueOf(defaultValue), attributeName) : new BooleanDataType(defaultValue, attributeName);
        return result;
    }

    private AttributeDataType getEnumDataType(XMLElement seqenumRefTag, String attributeName) {
        List seqenumRefTagChildren = seqenumRefTag.getChildren();
        Iterator seqenumRefTagChildrenIter = seqenumRefTagChildren.iterator();
        String enumName = seqenumRefTag.getAttributes().getValue("name");
        String defaultValue = null;
        while (seqenumRefTagChildrenIter.hasNext()) {
            XMLElement currentseqenumRefTagChildren = (XMLElement)seqenumRefTagChildrenIter.next();
            if (currentseqenumRefTagChildren.getType().equals(DEFAULT_VALUE)) {
                defaultValue = currentseqenumRefTagChildren.getText().trim();
                continue;
            }
            if (currentseqenumRefTagChildren.getType().equals("enumRef")) {
                enumName = currentseqenumRefTagChildren.getAttributes().getValue("name");
                continue;
            }
            if (!currentseqenumRefTagChildren.getType().equals(SEQ_DEFAULT_VALUE)) continue;
            Iterator enumRefIter = currentseqenumRefTagChildren.getChildren().iterator();
            while (enumRefIter.hasNext()) {
                XMLElement currentenumRefTagChildren = (XMLElement)enumRefIter.next();
                if (!currentenumRefTagChildren.getType().equals(DEFAULT_VALUE)) continue;
                if (defaultValue == null) {
                    defaultValue = currentenumRefTagChildren.getText().trim();
                    continue;
                }
                defaultValue = defaultValue + "," + currentenumRefTagChildren.getText().trim();
            }
        }
        return new EnumDataType(enumName, defaultValue, attributeName);
    }

    private AttributeDataType getIntegerDataType(XMLElement longTag, String attributeName) {
        return this.getNumericDataType(longTag, attributeName, 32);
    }

    private AttributeDataType getLongDataType(XMLElement longLongTag, String attributeName) {
        return this.getNumericDataType(longLongTag, attributeName, 64);
    }

    private AttributeDataType getNumericDataType(XMLElement longLongTag, String attributeName, int numberOfBits) {
        String typeId = longLongTag.getType();
        List longLongTagChildren = longLongTag.getChildren();
        Iterator longLongTagChildrenIter = longLongTagChildren.iterator();
        String defaultValue = null;
        List rangeData = new ArrayList();
        int resolution = 1;
        while (longLongTagChildrenIter.hasNext()) {
            XMLElement currentLongLongTagChild = (XMLElement)longLongTagChildrenIter.next();
            if (currentLongLongTagChild.getType().equals(SEQ_DEFAULT_VALUE)) {
                defaultValue = this.getDefaultValue(currentLongLongTagChild);
                continue;
            }
            if (currentLongLongTagChild.getType().equals(DEFAULT_VALUE)) {
                defaultValue = currentLongLongTagChild.getText().trim();
                continue;
            }
            if (currentLongLongTagChild.getType().equals(RANGE)) {
                rangeData = this.createRanges(currentLongLongTagChild, typeId);
                continue;
            }
            if (currentLongLongTagChild.getType().equals(RESOLUTION)) {
                resolution = Integer.decode(currentLongLongTagChild.getText());
                continue;
            }
            if (!currentLongLongTagChild.getType().equals(LONG) && !currentLongLongTagChild.getType().equals(LONGLONG)) continue;
            rangeData = this.createRangesforSeq(currentLongLongTagChild);
        }
        AbstractAttributeDataType result = null;
        switch (numberOfBits) {
            case 32: {
                result = new IntegerDataType(defaultValue, rangeData, resolution, attributeName);
                break;
            }
            case 64: {
                result = new LongDataType(defaultValue, rangeData, resolution, attributeName);
                break;
            }
            default: {
                throw new RuntimeException("Unknown number of bits for Numeric datatype");
            }
        }
        return result;
    }

    private String getDefaultValue(XMLElement currentLongLongTagChild) {
        String defaultValue = null;
        Iterator seqDefTagChildrenIter = currentLongLongTagChild.getChildren().iterator();
        while (seqDefTagChildrenIter.hasNext()) {
            XMLElement currentSeqDefTagChildren = (XMLElement)seqDefTagChildrenIter.next();
            if (!currentSeqDefTagChildren.getType().equals(DEFAULT_VALUE)) continue;
            if (defaultValue == null) {
                defaultValue = currentSeqDefTagChildren.getText().trim();
                continue;
            }
            defaultValue = defaultValue + "," + currentSeqDefTagChildren.getText().trim();
        }
        return defaultValue;
    }

    private List createRangesforSeq(XMLElement longlongTag) {
        List longlongTagChild = longlongTag.getChildren();
        Iterator longlongTagChildIter = longlongTagChild.iterator();
        List rangeData = new ArrayList();
        while (longlongTagChildIter.hasNext()) {
            XMLElement currentLongLongTagChild = (XMLElement)longlongTagChildIter.next();
            if (!currentLongLongTagChild.getType().equals(RANGE)) continue;
            String getType = longlongTag.getType();
            rangeData = this.createRanges(currentLongLongTagChild, getType);
        }
        return rangeData;
    }

    private AttributeDataType getMoRefDataType(XMLElement momDataTypeHolder, String attributeName) {
        String defaultValue = null;
        String refMoName = momDataTypeHolder.getAttributes().getValue("name");
        List moRefTagChildren = momDataTypeHolder.getChildren();
        Iterator moRefTagChildrenIter = moRefTagChildren.iterator();
        while (moRefTagChildrenIter.hasNext()) {
            XMLElement currentMoRefTagChild = (XMLElement)moRefTagChildrenIter.next();
            if (!currentMoRefTagChild.getType().equals(DEFAULT_VALUE) && !currentMoRefTagChild.getType().equals(SEQ_DEFAULT_VALUE)) continue;
            defaultValue = currentMoRefTagChild.getText();
        }
        return new MoRefType(refMoName, attributeName, defaultValue);
    }

    public AttributeDataType getSeqDataType(String moType, String attributeName, XMLElement dataTypeTag) throws IOException {
        List dataTypeTagChildren = dataTypeTag.getChildren();
        Iterator dataTypeTagChildrenChildIter = dataTypeTagChildren.iterator();
        AttributeDataType seqType = null;
        Integer minLength = null;
        Integer maxLength = null;
        boolean nonUnique = false;
        String mylocalType = null;
        XMLElement seqDefaultValueTag = null;
        SeqDataType myseq = null;
        while (dataTypeTagChildrenChildIter.hasNext()) {
            XMLElement currentChild = (XMLElement)dataTypeTagChildrenChildIter.next();
            if (currentChild.getType().equals(MAX_LENGTH)) {
                String maxLengthAsString = currentChild.getText();
                maxLength = new Integer(maxLengthAsString);
                continue;
            }
            if (currentChild.getType().equals(MIN_LENGTH)) {
                String minLengthAsString = currentChild.getText();
                minLength = new Integer(minLengthAsString);
                continue;
            }
            if (currentChild.getType().equals(NON_UNIQUE)) {
                nonUnique = true;
                continue;
            }
            if (currentChild.getType().equals(SEQ_DEFAULT_VALUE)) {
                seqDefaultValueTag = currentChild;
                continue;
            }
            if (currentChild.getType().equals(ORDERED)) {
                logger.traceError(THIS_CLASS, "Error tag exists but ignored  : " + currentChild.getType() + " : " + currentChild.getText());
                continue;
            }
            mylocalType = currentChild.getType();
            seqType = this.getAttributeDataType(moType, attributeName, dataTypeTag);
        }
        if (seqDefaultValueTag != null) {
            if (mylocalType.equalsIgnoreCase(LONGLONG)) {
                seqType = this.getLongDataType(dataTypeTag, attributeName);
            } else if (mylocalType.equalsIgnoreCase(LONG)) {
                seqType = this.getIntegerDataType(dataTypeTag, attributeName);
            } else if (mylocalType.equalsIgnoreCase("enumRef")) {
                seqType = this.getEnumDataType(dataTypeTag, attributeName);
            } else if (mylocalType.equalsIgnoreCase("boolean")) {
                seqType = this.getBooleanDataType(dataTypeTag, attributeName);
            } else if (mylocalType.equalsIgnoreCase("structRef")) {
                seqType = this.getStructRefDataType(dataTypeTag, mylocalType, attributeName);
            }
        }
        myseq = new SeqDataType(seqType, minLength, maxLength, nonUnique, attributeName);
        return myseq;
    }

    private AttributeDataType getSingleRefDataType(XMLElement momDataTypeHolder, String attributeName) {
        String refMoName = momDataTypeHolder.getAttributes().getValue("name");
        return new SingleRefBiDirectionalAssociationDataType(refMoName, attributeName);
    }

    private AttributeDataType getStringDataType(XMLElement stringTag, String attributeName) {
        String typeId = stringTag.getType();
        List stringTagChildren = stringTag.getChildren();
        Iterator stringTagChildrenIter = stringTagChildren.iterator();
        String defaultValue = null;
        String validValues = null;
        String alphabet = null;
        List rangeData = new ArrayList();
        while (stringTagChildrenIter.hasNext()) {
            XMLElement currentStringTagChild = (XMLElement)stringTagChildrenIter.next();
            if (currentStringTagChild.getType().equals(DEFAULT_VALUE)) {
                defaultValue = StringHelper.getStringHelper().unQuote(currentStringTagChild.getText());
                continue;
            }
            if (currentStringTagChild.getType().equals(VALID_VALUES)) {
                validValues = currentStringTagChild.getText();
                continue;
            }
            if (currentStringTagChild.getType().equals(ALPHABET)) {
                alphabet = currentStringTagChild.getText();
                continue;
            }
            if (!currentStringTagChild.getType().equals(LENGTH_RANGE)) continue;
            rangeData = this.createRanges(currentStringTagChild, typeId);
        }
        return new StringDataType(defaultValue, rangeData, validValues, alphabet, attributeName);
    }

    private AttributeDataType getStructRefDataType(XMLElement structRefTag, String moType, String attributeName) {
        String refStructName = structRefTag.getAttributes().getValue("name");
        return new StructRefType(refStructName, moType, attributeName);
    }

    private AttributeDataType getTheDataType(String moType, String attributeName, XMLElement typeHolder, String typeId) throws IOException {
        AttributeDataType data = null;
        if (typeId.equals("boolean")) {
            data = this.getBooleanDataType(typeHolder, attributeName);
        } else if (typeId.equals(LONG)) {
            data = this.getIntegerDataType(typeHolder, attributeName);
        } else if (typeId.equals(LONGLONG)) {
            data = this.getLongDataType(typeHolder, attributeName);
        } else if (typeId.equals("string")) {
            data = this.getStringDataType(typeHolder, attributeName);
        } else if (typeId.equals("enumRef")) {
            data = this.getEnumDataType(typeHolder, attributeName);
        } else if (typeId.equals("moRef")) {
            data = this.getTheMoRefDataType(attributeName, typeHolder);
        } else if (typeId.equals("structRef")) {
            data = this.getStructRefDataType(typeHolder, moType, attributeName);
        } else if (typeId.equals("sequence")) {
            data = this.getTheSeqDataType(moType, attributeName, typeHolder);
        }
        return data;
    }

    private AttributeDataType getTheMoRefDataType(String attributeName, XMLElement typeHolder) {
        AttributeDataType data = "reservedBy".equals(attributeName) ? this.getSingleRefDataType(typeHolder, attributeName) : this.getMoRefDataType(typeHolder, attributeName);
        return data;
    }

    private AttributeDataType getTheSeqDataType(String moType, String attributeName, XMLElement typeHolder) throws IOException {
        AttributeDataType data = "reservedBy".equals(attributeName) ? this.getBiDirAssDataType(moType, attributeName, typeHolder) : this.getSeqDataType(moType, attributeName, typeHolder);
        return data;
    }

    private static class NumericBitCounts {
        private static final int INT_TYPE = 32;
        private static final int LONG_TYPE = 64;

        private NumericBitCounts() {
        }
    }
}

