/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.finder;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.AlarmInfoHandler;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.DesignMomHandler;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.EnumFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.MoFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.RelationshipFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.StructFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.ParserFactory;
import se.ericsson.crbs.omf.mao.xml.ParserFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

class MoMetaDataFinderImpl
implements MoMetaDataFinder {
    private static Map instances = new HashMap();
    private final ResourceBundle myBundle;
    private final ParserFactory parserFactory = new ParserFactoryImpl();
    private final Map moMap = new HashMap();
    private final Map childParentMap = new HashMap();
    private final Map structMap = new HashMap();
    private final Map enumMap = new HashMap();
    private final Map biDirectionalRelationshipMap = new HashMap();
    private String mimType = "";
    private String mimVersion = "";
    private String mimRelease = "";
    private final String finderType;

    public static MoMetaDataFinder getInstance(String metaDataType, ResourceBundle aBundle) throws IOException {
        MoMetaDataFinder requiredMetaData = null;
        String key = metaDataType + "-" + aBundle.getString("ID");
        if (instances.containsKey(key)) {
            requiredMetaData = (MoMetaDataFinder)instances.get(key);
        } else {
            requiredMetaData = new MoMetaDataFinderImpl(metaDataType, aBundle);
            instances.put(key, requiredMetaData);
        }
        return requiredMetaData;
    }

    private MoMetaDataFinderImpl(String metaDataType, ResourceBundle aBundle) throws IOException {
        this.finderType = metaDataType;
        this.myBundle = aBundle;
        String[] MOM_FILES = this.getMomFiles();
        String[] DESIGN_MOM_FILES = this.getDesignMomFiles();
        if (metaDataType.equals("MOM_META_DATA")) {
            Parser momParser = this.parserFactory.createParser(this.myBundle.getString("DESIGN_MOM_XML_FILE_NAME"), "");
            DesignMomHandler.storeStructs(momParser);
            List<String> momFiles = Arrays.asList(MOM_FILES);
            this.parseXMLFiles(momFiles, true);
            List<String> designMomFiles = Arrays.asList(DESIGN_MOM_FILES);
            this.parseXMLFiles(designMomFiles, false);
        } else {
            Parser systemCreatedMomParser = this.parserFactory.createParser(this.myBundle.getString("SYSINSTMIB_XML_FILE_NAME"), "");
            this.storeMOMData(systemCreatedMomParser);
        }
    }

    public Map getAVCAttributes(String moName) {
        HashMap<String, AttributeMetaData> avcMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (currentAttribute.isNoNotification()) continue;
            avcMap.put(currentAttribute.getName(), currentAttribute);
        }
        return avcMap;
    }

    public Map getBiDirectionalRelationshipMap() {
        return this.biDirectionalRelationshipMap;
    }

    public List getChildMetaData(String childMoType) {
        return (List)this.childParentMap.get(childMoType);
    }

    private String[] getDesignMomFiles() {
        String[] result = new String[]{};
        if (this.myBundle != null) {
            String designMomFile = this.myBundle.getString("DESIGN_MOM_XML_FILE_NAME");
            result = new String[]{designMomFile};
        }
        return result;
    }

    public Map getEnumMap() {
        return this.enumMap;
    }

    public String getFinderType() {
        return this.finderType;
    }

    public Map getMandatoryAndOptionalAttributes(String moName) {
        HashMap<String, AttributeMetaData> attrMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (currentAttribute.getName().equals(moName + "Id") || Definitions.isPmAttribute(currentAttribute.getName())) continue;
            attrMap.put(currentAttribute.getName(), currentAttribute);
        }
        return attrMap;
    }

    public Map getMandatoryAttributes(String moName) {
        HashMap<String, AttributeMetaData> mandatoryMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (!currentAttribute.isMandatory() || currentAttribute.getName().equals(moName + "Id")) continue;
            mandatoryMap.put(currentAttribute.getName(), currentAttribute);
        }
        return mandatoryMap;
    }

    public String getMimRelease() {
        return this.mimRelease;
    }

    public String getMimType() {
        return this.mimType;
    }

    public String getMimVersion() {
        return this.mimVersion;
    }

    public Map getMoAttributes(String moName) {
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        return moMetaData.getAttributes();
    }

    public AttributeMetaData getMoAttributes(String moName, String attributeName) {
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map moAttributes = moMetaData.getAttributes();
        AttributeMetaData attributeData = (AttributeMetaData)moAttributes.get(attributeName);
        return attributeData;
    }

    public MoMetaData getMoData(String moName) {
        return (MoMetaData)this.moMap.get(moName);
    }

    public Map getMoMap() {
        return this.moMap;
    }

    private String[] getMomFiles() {
        String[] result = new String[]{};
        if (this.myBundle != null) {
            String nodeMomFile = this.myBundle.getString("RBS_NODE_COMPLETE_XML_FILE_NAME");
            result = new String[]{nodeMomFile};
        }
        return result;
    }

    public Map getOptionalAttributes(String moName) {
        HashMap<String, AttributeMetaData> opMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (currentAttribute.isMandatory() || Definitions.isPmAttribute(currentAttribute.getName())) continue;
            opMap.put(currentAttribute.getName(), currentAttribute);
        }
        return opMap;
    }

    public Map getReadOnlyAttributes(String moName) {
        HashMap<String, AttributeMetaData> readOnlyMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (!currentAttribute.isReadOnly()) continue;
            readOnlyMap.put(currentAttribute.getName(), currentAttribute);
        }
        return readOnlyMap;
    }

    public Map getRestrictedAttributes(String moName) {
        HashMap<String, AttributeMetaData> restrictedMap = new HashMap<String, AttributeMetaData>();
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moName);
        Map allAttributes = moMetaData.getAttributes();
        Iterator attributeIter = allAttributes.values().iterator();
        while (attributeIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attributeIter.next();
            if (!currentAttribute.isRestricted()) continue;
            restrictedMap.put(currentAttribute.getName(), currentAttribute);
        }
        return restrictedMap;
    }

    public Map getStructmap() {
        return this.structMap;
    }

    private void parseXMLFiles(List filesToParse, boolean isMomStructure) throws IOException {
        Iterator fileIter = filesToParse.iterator();
        while (fileIter.hasNext()) {
            String currentFileName = (String)fileIter.next();
            Parser momParser = this.parserFactory.createParser(currentFileName, "");
            if (isMomStructure) {
                this.storeMOMData(momParser);
            } else {
                DesignMomHandler.storeDesignMOMData(momParser, this);
                Parser alarmInfoParser = this.parserFactory.createParser(this.myBundle.getString("ALARMDEFINITIONS_XML_FILE_NAME"), "");
                AlarmInfoHandler.storeAlarmInfo(alarmInfoParser, this);
            }
            momParser.close();
        }
    }

    private void storeMOMData(Parser momParser) throws IOException {
        List nodeMomElements = momParser.getXMLelements();
        XMLElement mimElement = (XMLElement)nodeMomElements.get(nodeMomElements.size() - 1);
        AttributesImpl mimAttribs = mimElement.getAttributes();
        String type = mimAttribs.getValue("name");
        String version = mimAttribs.getValue("version");
        String release = mimAttribs.getValue("release");
        this.mimType = type;
        this.mimVersion = version;
        this.mimRelease = release;
        List mimChildren = mimElement.getChildren();
        Iterator mimChildIter = mimChildren.iterator();
        while (mimChildIter.hasNext()) {
            XMLElement currentMimChild = (XMLElement)mimChildIter.next();
            String mimChildType = currentMimChild.getType();
            if ("class".equals(mimChildType)) {
                MoFactory.storeMo(currentMimChild, this.moMap);
                continue;
            }
            if ("relationship".equals(mimChildType)) {
                RelationshipFactory.storeRelationship(currentMimChild, this.childParentMap, this.biDirectionalRelationshipMap, this);
                continue;
            }
            if ("struct".equals(mimChildType)) {
                StructFactory.storeStruct(currentMimChild, this.structMap);
                continue;
            }
            if (!"enum".equals(mimChildType)) continue;
            EnumFactory.storeEnum(currentMimChild, this.enumMap);
        }
        RelationshipFactory.storeReferencedMOTypes(this.biDirectionalRelationshipMap, this);
    }
}

