/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.mo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroIdFinderHelper;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroInfoProvider;

public class FroIdFinderHelperImpl
implements FroIdFinderHelper {
    private static final Class THIS_CLASS = FroIdFinderHelperImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public int getManagedObjectFroId(ManagedObject mo, Coordinator coord) throws MoAccessException {
        int res = -1;
        res = FroIdFinderHelperImpl.isCppMo(mo) ? FroIdFinderHelperImpl.getCppObjectFroId(mo, coord) : FroIdFinderHelperImpl.getXoamObjectFroId(mo, coord);
        return res;
    }

    public int getManagedObjectFroType(ManagedObject mo, Coordinator coord) throws MoAccessException {
        int res = -1;
        res = FroIdFinderHelperImpl.isCppMo(mo) ? FroIdFinderHelperImpl.getCppObjectFroType(mo, coord) : FroIdFinderHelperImpl.getXoamObjectFroType(mo);
        return res;
    }

    private static int getCppObjectFroId(ManagedObject mo, Coordinator coord) throws ProcessingFailureException {
        String msg = "getCppObjectFroId(" + mo.getType() + ")";
        logger.traceEnter(THIS_CLASS, msg);
        int froId = 0;
        froId = "Licensing".equals(mo.getType()) || "LoadModule".equals(mo.getType()) || "Equipment".equals(mo.getType()) || "PiuType".equals(mo.getType()) || "ManagedElement".equals(mo.getType()) || "GeneralProcessorUnit".equals(mo.getType()) ? 0 : FroIdFinderHelperImpl.getFroIdByReflection(mo, coord);
        logger.traceReturn(THIS_CLASS, msg);
        return froId;
    }

    private static int getXoamObjectFroId(ManagedObject mo, Coordinator coord) throws MoAccessException {
        String msg = "getXoamObjectFroId(" + mo.getType() + ")";
        logger.traceEnter(THIS_CLASS, msg);
        int froId = 0;
        froId = mo instanceof FroInfo ? ((FroInfo)mo).getFroId(coord) : FroIdFinderHelperImpl.getFroIdByReflection(mo, coord);
        logger.traceReturn(THIS_CLASS, msg);
        return froId;
    }

    private static int getFroIdByReflection(ManagedObject mo, Coordinator coord) throws ProcessingFailureException {
        String msg = "findFroIdByReflection(" + mo.getType() + ")";
        logger.traceEnter(THIS_CLASS, msg);
        Class[] methodAttrs = new Class[]{Coordinator.class};
        Method getFroId = FroIdFinderHelperImpl.getMethod(mo, "getFroId", methodAttrs);
        if (getFroId == null) {
            getFroId = FroIdFinderHelperImpl.getMethod(mo, "getResourceId", methodAttrs);
        }
        if (getFroId == null) {
            throw new ProcessingFailureException("None of the methods getFroId or getResourceId does not exist for MO: " + mo.getLocalDistinguishedName());
        }
        Integer froId = null;
        try {
            froId = (Integer)getFroId.invoke((Object)mo, coord);
        }
        catch (IllegalAccessException iae) {
            throw new ProcessingFailureException("Failed to get froId for MO: " + mo.getLocalDistinguishedName() + " Reason:" + iae);
        }
        catch (InvocationTargetException ite) {
            throw new ProcessingFailureException("Failed to get froId for MO: " + mo.getLocalDistinguishedName() + " Reason:" + ite);
        }
        logger.traceReturn(THIS_CLASS, msg);
        return froId;
    }

    private static int getCppObjectFroType(ManagedObject mo, Coordinator coord) {
        return 0;
    }

    private static int getXoamObjectFroType(ManagedObject mo) throws ProcessingFailureException {
        String msg = "getXoamObjectFroType(" + mo.getLocalDistinguishedName() + ")";
        logger.traceEnter(THIS_CLASS, msg);
        int froType = 0;
        if (mo instanceof FroInfoProvider) {
            FroInfoProvider froInfoProvider = (FroInfoProvider)mo;
            froType = froInfoProvider.getFroType();
        } else {
            froType = FroIdFinderHelperImpl.getFroTypeByReflection(mo);
        }
        logger.traceReturn(THIS_CLASS, msg);
        return froType;
    }

    private static int getFroTypeByReflection(ManagedObject mo) throws ProcessingFailureException {
        String msg = "findFroIdByReflection(" + mo.getType() + ")";
        logger.traceEnter(THIS_CLASS, msg);
        Class[] methodAttrs = new Class[]{};
        Method getFroType = FroIdFinderHelperImpl.getMethod(mo, "getFroType", methodAttrs);
        if (getFroType == null) {
            throw new ProcessingFailureException("Method getFroType does not exist for MO: " + mo.getLocalDistinguishedName());
        }
        Integer froType = null;
        try {
            froType = (Integer)getFroType.invoke((Object)mo, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new ProcessingFailureException("Failed to get froType for MO: " + mo.getLocalDistinguishedName() + " Reason:" + iae);
        }
        catch (InvocationTargetException ite) {
            throw new ProcessingFailureException("Failed to get froType for MO: " + mo.getLocalDistinguishedName() + " Reason:" + ite);
        }
        logger.traceReturn(THIS_CLASS, msg);
        return froType;
    }

    private static boolean isCppMo(ManagedObject mo) {
        boolean res = false;
        String packageName = mo.getClass().getPackage().getName();
        if (packageName.startsWith("se.ericsson.cello")) {
            res = true;
        }
        return res;
    }

    private static Method getMethod(ManagedObject mo, String name, Class[] methodAttrs) {
        Method result = null;
        logger.traceEnter(THIS_CLASS, "getMethod(), MO=" + mo.getLocalDistinguishedName() + ", name=" + name);
        try {
            result = mo.getClass().getDeclaredMethod(name, methodAttrs);
        }
        catch (NoSuchMethodException nsme) {
            logger.traceDebug(THIS_CLASS, "Failed to find method " + name + " in the class.");
        }
        catch (SecurityException se) {
            logger.traceDebug(THIS_CLASS, "Failed to find method " + name + " in the class.");
        }
        if (result == null) {
            try {
                result = mo.getClass().getMethod(name, methodAttrs);
            }
            catch (SecurityException e) {
                logger.traceDebug(THIS_CLASS, "Failed to find method " + name + " in the super class(es).");
            }
            catch (NoSuchMethodException e) {
                logger.traceDebug(THIS_CLASS, "Failed to find method " + name + " in the super class(es).");
            }
        }
        logger.traceReturn(THIS_CLASS, "getMethod(), method=" + result);
        return result;
    }
}

