/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactoryFactory;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactoryImpl;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class MaoFactoryFactoryImpl
implements MaoFactoryFactory {
    private static AbstractLogger logger = LoggingService.getLogger(MaoFactoryFactoryImpl.class.getName());
    private static final Class THIS_CLASS = MaoFactoryFactoryImpl.class;
    protected final Map mInstances = new HashMap();
    private final OmfContext omfContext;

    public MaoFactoryFactoryImpl(OmfContext aOmfContext) {
        this.omfContext = aOmfContext;
    }

    public MaoFactory getMoFactory(MoMetaData currentMo) {
        logger.traceEnter(THIS_CLASS, "getMoFactory(" + currentMo.getName() + ")");
        MaoFactory currentFac = null;
        currentFac = this.moTypeHasSpecialFactory(currentMo.getName()) ? this.getSpecialMaoFactory(currentMo.getName()) : (this.isDeprecatedGenericMao(currentMo.getName()) ? this.getDeprecatedGenericMaoFactory(currentMo.getName()) : (currentMo.isSystemCreated() ? this.getSystemCreatedMaoFactory(currentMo.getName()) : (currentMo.isPartlySystemCreated() ? this.getSystemCreatedMaoFactory(currentMo.getName()) : this.getGenericMaoFactory(currentMo.getName()))));
        logger.traceReturn(THIS_CLASS, "getMoFactory(" + currentMo.getName() + ")");
        return currentFac;
    }

    public MaoFactory getMoFactory(String moType, boolean isSystemCreated) throws IOException {
        logger.traceEnter(THIS_CLASS, "getMoFactory(" + moType + ", " + isSystemCreated + ")");
        MaoFactory currentFac = null;
        currentFac = this.isDeprecatedGenericMao(moType) ? this.getDeprecatedGenericMaoFactory(moType) : (isSystemCreated ? this.getSystemCreatedMaoFactory(moType) : this.getGenericMaoFactory(moType));
        logger.traceReturn(THIS_CLASS, "getMoFactory(" + moType + ", " + isSystemCreated + ")");
        return currentFac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaoFactory getSystemCreatedMaoFactory(String moType) {
        logger.traceEnter(THIS_CLASS, "getSystemCreatedMaoFactory(" + moType + ")");
        MaoFactoryFactoryImpl maoFactoryFactoryImpl = this;
        synchronized (maoFactoryFactoryImpl) {
            MaoFactory res = null;
            if (this.mInstances.get(moType) == null) {
                GenericMaoContext genericMaoContext = this.omfContext.getGenericMaoContext(moType);
                SystemCreatedMaoFactoryImpl instance = new SystemCreatedMaoFactoryImpl(moType, genericMaoContext);
                this.mInstances.put(moType, instance);
            }
            res = (MaoFactory)this.mInstances.get(moType);
            logger.traceReturn(THIS_CLASS, "getSystemCreatedMaoFactory(" + moType + ")");
            return res;
        }
    }

    private boolean moTypeHasSpecialFactory(String moType) {
        return this.getSpecialMaoFactoryClass(moType) != null;
    }

    private MaoFactory getSpecialMaoFactory(String moType) {
        MaoFactory specialMaoFactory = (MaoFactory)this.mInstances.get(moType);
        if (specialMaoFactory == null) {
            try {
                Class specialMaoFactoryClass = this.getSpecialMaoFactoryClass(moType);
                Class[] parameterTypes = new Class[]{String.class, GenericMaoContext.class};
                Constructor constructor = specialMaoFactoryClass.getConstructor(parameterTypes);
                Object[] parameterValues = new Object[]{moType, this.omfContext.getGenericMaoContext(moType)};
                specialMaoFactory = (MaoFactory)constructor.newInstance(parameterValues);
                this.mInstances.put(moType, specialMaoFactory);
            }
            catch (Exception e) {
                String errorMsg = "The specialMaoFactory for mo type " + moType + " is having problems with its constructor.";
                logger.traceError(THIS_CLASS, errorMsg, e);
                throw new RuntimeException(errorMsg, e);
            }
        }
        return specialMaoFactory;
    }

    private Class getSpecialMaoFactoryClass(String moType) {
        Class<?> specialFactoryClass = null;
        String className = "";
        try {
            Locale aLocale = Locale.getDefault();
            String maoPackage = this.omfContext.getGenericMaoContext(moType).getMoMetaDataNames().getMaoPackageName();
            className = maoPackage + "." + moType.toLowerCase(aLocale) + "." + moType + "MaoFactory";
            specialFactoryClass = Class.forName(className);
            if (!MaoFactory.class.isAssignableFrom(specialFactoryClass)) {
                specialFactoryClass = null;
            }
        }
        catch (ClassNotFoundException e) {
            logger.traceDebug(THIS_CLASS, "ignore this exception as MO type does not have to have a specialized class." + e);
        }
        return specialFactoryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaoFactory getGenericMaoFactory(String moType) {
        logger.traceEnter(THIS_CLASS, "getGenericMaoFactory()" + moType);
        MaoFactory res = null;
        MaoFactoryFactoryImpl maoFactoryFactoryImpl = this;
        synchronized (maoFactoryFactoryImpl) {
            if (this.mInstances.get(moType) == null) {
                GenericMaoContext genericMaoContext = this.omfContext.getGenericMaoContext(moType);
                GenericMaoFactory instance = new GenericMaoFactory(moType, genericMaoContext);
                this.mInstances.put(moType, instance);
            }
            res = (MaoFactory)this.mInstances.get(moType);
        }
        logger.traceReturn(THIS_CLASS, "getGenericMaoFactory()" + moType);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaoFactory getDeprecatedGenericMaoFactory(String moType) {
        logger.traceEnter(THIS_CLASS, "getDeprecatedGenericMaoFactory()" + moType);
        MaoFactory res = null;
        MaoFactoryFactoryImpl maoFactoryFactoryImpl = this;
        synchronized (maoFactoryFactoryImpl) {
            if (this.mInstances.get(moType) == null) {
                GenericMaoContext genericMaoContext = this.omfContext.getGenericMaoContext(moType);
                DeprecatedGenericMaoFactory instance = new DeprecatedGenericMaoFactory(moType, genericMaoContext);
                this.mInstances.put(moType, instance);
            }
            res = (MaoFactory)this.mInstances.get(moType);
        }
        logger.traceReturn(THIS_CLASS, "getDeprecatedGenericMaoFactory()" + moType);
        return res;
    }

    private boolean isDeprecatedGenericMao(String moType) {
        logger.traceEnter(THIS_CLASS, "isDeprecatedGenericMao()" + moType);
        boolean isDeprecated = false;
        MoMetaDataFinder moMetaDataFinder = this.omfContext.getMoMetaDataFinder();
        MoMetaData moMetaData = moMetaDataFinder.getMoData(moType);
        Struct replacedBy = moMetaData.getReplacedBy();
        if (replacedBy != null) {
            isDeprecated = true;
        }
        logger.traceReturn(THIS_CLASS, "isDeprecatedGenericMao()" + moType);
        return isDeprecated;
    }
}

