/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class MaoImplUtilities {
    private static final Class THIS_CLASS = MaoImplUtilities.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public boolean isChildAttrUnique(String childMoType, String attrName, Object attrValue, String childMoLdn, ManagedObject parent, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "isChildAttrUnique()");
        boolean isUnique = true;
        MoIterator children = parent.getChildren();
        while (children.hasMoreElements() && isUnique) {
            ManagedObject child = children.nextMo();
            try {
                if (!childMoType.equals(child.getType()) || childMoLdn.equals(child.getLocalDistinguishedName()) || !child.getAttribute(attrName, coordinator).equals(attrValue)) continue;
                isUnique = false;
            }
            catch (NoSuchAttributeException e) {
                logger.traceError(THIS_CLASS, "Failed to find " + attrName + " in sibling MO");
            }
        }
        logger.traceReturn(THIS_CLASS, "isChildAttrUnique()");
        return isUnique;
    }

    public boolean isAttrUnique(String moType, String[] attrNames, Object[] attrValues, String ldn, MoRepositoryWrapper repository, Coordinator coordinator) throws MoAccessException, MoNotFoundException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "isAttrUnique()");
        boolean isUnique = true;
        MoIterator i = repository.lookupType(moType);
        if (i == null) {
            throw new MoNotFoundException("moType: " + moType + " not found.");
        }
        while (i.hasMoreElements() && isUnique) {
            ManagedObject tmpMo = i.nextMo();
            String tmpLdn = tmpMo.getLocalDistinguishedName();
            if (attrNames.length != attrValues.length) {
                logger.traceError(THIS_CLASS, "Invalid Parameter: attrNames and attrValues must have identical size.");
                break;
            }
            int attrCollisionCount = 0;
            for (int a = 0; a < attrNames.length; ++a) {
                Object tmpAttrValue = tmpMo.getAttribute(attrNames[a], coordinator);
                if (attrValues[a] instanceof Struct && tmpAttrValue instanceof Struct) {
                    if (!moType.equals(tmpMo.getType()) || ldn.equals(tmpLdn) || !StructImpl.compareStructs((Struct)attrValues[a], (Struct)tmpAttrValue)) continue;
                    ++attrCollisionCount;
                    continue;
                }
                if (!moType.equals(tmpMo.getType()) || ldn.equals(tmpLdn) || !attrValues[a].equals(tmpAttrValue)) continue;
                ++attrCollisionCount;
            }
            if (attrCollisionCount != attrValues.length) continue;
            isUnique = false;
        }
        logger.traceEnter(THIS_CLASS, "isAttrUnique()");
        return isUnique;
    }

    public boolean isAttrUnique(String moType, String attrName, Object attrValue, String ldn, MoRepositoryWrapper repository, Coordinator coordinator) throws MoAccessException, MoNotFoundException, NoSuchAttributeException {
        return this.isAttrUnique(moType, new String[]{attrName}, new Object[]{attrValue}, ldn, repository, coordinator);
    }
}

