/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class SpecialisedMaoImplClassHelper {
    private static final Class THIS_CLASS = SpecialisedMaoImplClassHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public static Class getSpecialisedMaoClass(String moType, GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "getSpecialisedMaoClass() - " + moType);
        Class<?> specialClass = null;
        String className = "";
        try {
            Locale aLocale = Locale.getDefault();
            String maoPackage = genericMaoContext.getMoMetaDataNames().getMaoPackageName();
            className = maoPackage + "." + moType.toLowerCase(aLocale) + "." + moType + "MaoImpl";
            specialClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.traceGeneral(THIS_CLASS, "Specialised class " + className + " not found");
        }
        logger.traceReturn(THIS_CLASS, "getSpecialisedMaoClass() - " + moType);
        return specialClass;
    }

    public static Object createSpecialisedMaoImplClass(String moType, Class specialClass, ManagedObject parent, AttrList attributes, String identity, Coordinator coordinator, GenericMaoContext genericMaoContext, InitialMaoContext context) throws MoAccessException {
        Object requiredObject = null;
        logger.traceEnter(THIS_CLASS, "createSpecialisedMaoImplClass(id), id = " + identity + " - " + moType);
        try {
            Constructor mainConstructor = specialClass.getConstructor(ManagedObject.class, AttrList.class, String.class, GenericMaoContext.class, Integer.class, Coordinator.class, InitialMaoContext.class);
            int softwareRevision = genericMaoContext.getMoMetaDataFinder().getMoData(moType).getSwRevision();
            requiredObject = mainConstructor.newInstance(parent, attributes, identity, genericMaoContext, new Integer(softwareRevision), coordinator, context);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingFailureException("Method does not exist when creating MO. Original Exception message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ProcessingFailureException("Illegal Access when creating MO. Original Exception message: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ProcessingFailureException("Instantiation Exception when creating MO. Original Exception message: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.traceDebug(THIS_CLASS, e.getTargetException().getMessage());
            logger.traceDebugStackTrace(THIS_CLASS, e);
            if (e.getTargetException() instanceof MoAccessException) {
                throw (MoAccessException)e.getTargetException();
            }
            logger.traceError(THIS_CLASS, "", e.getTargetException());
            throw new MoCanNotBeCreatedException(e.getTargetException().getMessage() == null ? e.getTargetException().getClass().getName() : e.getTargetException().getMessage());
        }
        logger.traceReturn(THIS_CLASS, "createSpecialisedMaoImplClass(id), id = " + identity + " - " + moType);
        return requiredObject;
    }
}

