/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.ParameterConverter;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.RemoteAttributeManager;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPackFactory;

public class RemoteAttributeManagerImpl
implements RemoteAttributeManager {
    private static final int ACTION_ID = 0;
    private static final Class THIS_CLASS = RemoteAttributeManagerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final boolean doUseCache = false;
    private final Map attributeCache = new HashMap();
    private final GenericManagedObject myMo;
    private final String myMoType;
    private final FroProxy mFroProxy;
    private final ParameterConverter paramConv;
    private final GenericMaoContext genericMaoContext;
    private final XmlPack xmlPack;
    private final String protocolVersion;

    RemoteAttributeManagerImpl(GenericManagedObject managedObject, GenericMaoContext aGenericMaoContext) {
        String entMsg = "RemoteAttributeManager - " + managedObject.getType();
        logger.traceEnter(THIS_CLASS, entMsg);
        this.myMo = managedObject;
        this.genericMaoContext = aGenericMaoContext;
        XmlPackFactory xmlPackFactory = this.genericMaoContext.getXmlPackFactory();
        this.xmlPack = xmlPackFactory.getXmlPack();
        this.paramConv = new ParameterConverter();
        this.mFroProxy = this.genericMaoContext.getFroProxyFactory().getInstance(this.myMo.getType());
        this.myMoType = this.myMo.getType();
        if (this.genericMaoContext.getMoMetaDataFinder().getMoData(this.myMoType) != null) {
            this.protocolVersion = this.genericMaoContext.getMoMetaDataFinder().getMoData(this.myMoType).getFroProtocolVersion();
        } else {
            logger.traceAbnormal(THIS_CLASS, "MoMetaData for MO type " + this.myMoType + " was not found. " + "Assuming that protocolVersion is R1A.");
            this.protocolVersion = "R1A";
        }
        String retMsg = "RemoteAttributeManager - " + this.myMoType;
        logger.traceReturn(THIS_CLASS, retMsg);
    }

    public void clear() {
        String msg = "clear - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        this.attributeCache.clear();
        logger.traceReturn(THIS_CLASS, msg);
    }

    private Object convertFroParameterToJavaType(Parameter froValue, String attributeName, String attributeType) throws MoAccessException {
        String msg = "convertFroParameterToJavaType - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        Object value = this.paramConv.convertFroParameterToJavaType(this.myMo.getType(), this.myMo.getId(), froValue, this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext, attributeName, attributeType);
        logger.traceReturn(THIS_CLASS, msg);
        return value;
    }

    public int createMo(Coordinator coordinator, AttrList attributes) throws MoAccessException {
        String msg = "createMo - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        List sigParams = this.xmlPack.packCreateMO(attributes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
        FroData froData = this.mFroProxy.create(coordinator, (Collection)sigParams);
        logger.traceReturn(THIS_CLASS, msg);
        return froData.getFroId();
    }

    public void deleteMo(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        String msg = "deleteMo - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        int froId = this.myMo.getFroId(coordinator);
        AttrList attributes = attrList;
        List signalParameters = this.xmlPack.packCreateMO(attributes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
        try {
            this.mFroProxy.delete(coordinator, froId, (Collection)signalParameters);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String message = ((Object)((Object)frfe)).getClass().getName() + ": " + (exceptionVariables == null ? "NO EXCEPTION VARIABLES DEFINED" : exceptionVariables);
            throw new MoCanNotBeDeletedException(message);
        }
        logger.traceReturn(THIS_CLASS, msg);
    }

    public Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException {
        String entMsg = "getAttribute(" + attributeName + ") - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, entMsg);
        Object value = null;
        String attributeType = this.getAttributeType(attributeName);
        List signalParameters = null;
        if (this.attributeCache.containsKey(attributeName)) {
            value = this.attributeCache.get(attributeName);
        } else {
            signalParameters = this.xmlPack.packGetAttributes(new String[]{attributeName}, new String[]{attributeType}, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
            Map attributes = this.mFroProxy.getAttributes(coordinator, this.myMo.getFroId(coordinator), (Collection)signalParameters);
            StringParameter froData = (StringParameter)attributes.values().iterator().next();
            String debMsg = "Returned data is: " + froData.toString();
            logger.traceDebug(THIS_CLASS, debMsg);
            Parameter froValue = this.xmlPack.extractAttribute(froData, attributeName, this.protocolVersion);
            if (froValue == null) {
                String errMsg = "Error in getAttribute: error decoding answer from FRO - " + froData.getValueAsString();
                logger.traceAbnormal(THIS_CLASS, errMsg);
                throw new AttrNotReadableException((ManagedObject)this.myMo, attributeName);
            }
            Object attributeValue = this.convertFroParameterToJavaType(froValue, attributeName, attributeType);
            this.updateCache(attributeName, attributeValue);
            value = attributeValue;
        }
        String retMsg = "getAttribute(" + attributeName + ") - " + this.myMoType + " = " + value;
        logger.traceReturn(THIS_CLASS, retMsg);
        return value;
    }

    public Map getAttributes(String[] attributeNames, Coordinator coordinator) throws MoAccessException {
        String entMsg = "getAttributes(" + attributeNames + ") - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, entMsg);
        HashMap<String, Object> attributeValuesMap = new HashMap<String, Object>();
        String[] attributeTypes = this.getAttributeTypes(attributeNames);
        List signalParameters = this.xmlPack.packGetAttributes(attributeNames, attributeTypes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
        Map attributes = this.mFroProxy.getAttributes(coordinator, this.myMo.getFroId(coordinator), (Collection)signalParameters);
        StringParameter froData = (StringParameter)attributes.values().iterator().next();
        String debMsg = "Returned data is: " + froData.toString();
        logger.traceDebug(THIS_CLASS, debMsg);
        HashMap<String, String> attributeNamesToTypesMap = new HashMap<String, String>();
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNamesToTypesMap.put(attributeNames[i], attributeTypes[i]);
        }
        List parametersList = this.xmlPack.extractAttributes(froData, this.protocolVersion);
        Iterator paraIter = parametersList.iterator();
        while (paraIter.hasNext()) {
            Parameter parameter = (Parameter)paraIter.next();
            Object attrValue = this.convertFroParameterToJavaType(parameter, parameter.getName(), (String)attributeNamesToTypesMap.get(parameter.getName()));
            attributeValuesMap.put(parameter.getName(), attrValue);
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            if (!attributeValuesMap.containsKey(attributeNames[i])) {
                String errMsg = "Error in getAttribute: error decoding answer from FRO - " + attributeNames[i];
                logger.traceAbnormal(THIS_CLASS, errMsg);
                throw new AttrNotReadableException((ManagedObject)this.myMo, attributeNames[i]);
            }
            this.updateCache(attributeNames[i], attributeValuesMap.get(attributeNames[i]));
        }
        String retMsg = "getAttributes(" + attributeNames + ") - " + this.myMoType;
        logger.traceReturn(THIS_CLASS, retMsg);
        return attributeValuesMap;
    }

    private String getAttributeType(String attributeName) {
        String result = "Unknown";
        AttributeMetaData attributeMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoAttributes(this.myMoType, attributeName);
        if (attributeMetaData != null) {
            result = attributeMetaData.getData().getJavaReturnType();
        }
        return result;
    }

    private String[] getAttributeTypes(String[] attributeNames) {
        String[] result = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            AttributeMetaData attributeMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoAttributes(this.myMoType, attributeNames[i]);
            result[i] = attributeMetaData == null ? "Unknown" : attributeMetaData.getData().getJavaReturnType();
        }
        return result;
    }

    public Map sendActionWithCfm(String actionName, Coordinator coordinator, Map attributes) throws TransactionRequiredException, MoAccessException {
        String msg = "sendActionWithCfm(" + actionName + ") - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        List dataParameter = this.xmlPack.packAction(actionName, attributes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
        Map attributesFromFro = this.mFroProxy.actionWithCfm(coordinator, this.myMo.getFroId(coordinator), 0, (Collection)dataParameter);
        TreeMap<String, Object> returnedAttributes = new TreeMap<String, Object>();
        StringParameter froData = (StringParameter)attributesFromFro.values().iterator().next();
        if (froData != null) {
            String debMsg = "Returned data is: " + froData.toString();
            logger.traceDebug(THIS_CLASS, debMsg);
            List attributeValues = this.xmlPack.extractAttributes(froData, this.protocolVersion);
            Iterator iterator = attributeValues.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                String attributeName = parameter.getName();
                String attributeType = this.getAttributeType(attributeName);
                Object attributeValue = this.convertFroParameterToJavaType(parameter, attributeName, attributeType);
                returnedAttributes.put(attributeName, attributeValue);
            }
        }
        logger.traceReturn(THIS_CLASS, msg);
        return returnedAttributes;
    }

    public void sendActionWithoutCfm(String actionName, Coordinator coordinator, Map attributes) throws MoAccessException {
        String msg = "sendActionWithoutCfm(" + actionName + ") - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        List dataParameter = this.xmlPack.packAction(actionName, attributes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
        this.mFroProxy.actionWithoutCfm(coordinator, this.myMo.getFroId(coordinator), 0, (Collection)dataParameter);
        logger.traceReturn(THIS_CLASS, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Coordinator coordinator, Map attributes, MoValidator validator, Map attributeNameValuePairs) throws MoAccessException {
        String msg = "setAttributes - " + this.myMoType;
        logger.traceEnter(THIS_CLASS, msg);
        if (!attributes.isEmpty()) {
            try {
                Map newAttributes = this.myMo.addFroParametersAtSet(attributes, attributeNameValuePairs, coordinator);
                List dataParameter = this.xmlPack.packSetAttributes(newAttributes, this.myMo.getLocalDistinguishedName(), this.protocolVersion);
                this.mFroProxy.setAttributes(coordinator, this.myMo.getFroId(coordinator), (Collection)dataParameter);
                this.updateCache(newAttributes);
            }
            finally {
                this.clear();
            }
        }
        logger.traceReturn(THIS_CLASS, msg);
    }

    private void updateCache(Map attributes) throws MoAccessException {
    }

    private void updateCache(String attributeName, Object attributeValue) {
    }
}

