/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.type;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.swmanagement.LoadModuleMoImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class MaoStructureAttribute
implements LocalAttribute {
    private StructAttribute attributeValue = null;
    private final String attributeName;
    private final boolean isAvcNotifier;
    private MoMetaDataFinder finder;
    private StructRefType structMetaData;

    public MaoStructureAttribute(String moName, String attributeName, boolean isAvcNotifier, MoMetaDataFinder finder) throws MoAccessException {
        this.attributeName = attributeName;
        this.isAvcNotifier = isAvcNotifier;
        this.finder = finder;
        this.structMetaData = (StructRefType)finder.getMoAttributes(moName, attributeName).getData();
    }

    public void delete(ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        Attribute[] attributes = this.attributeValue.getElements(coordinator);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] instanceof ReferenceAttribute) {
                ManagedObject referencedMo = ((ReferenceAttribute)attributes[i]).getValue(coordinator);
                if (referencedMo == null) continue;
                ((Reservable)referencedMo).release(myMo, coordinator);
                continue;
            }
            if (!(attributes[i] instanceof SequenceAttribute)) continue;
            Attribute[] sequenceAttributes = ((SequenceAttribute)attributes[i]).getValue(coordinator);
            for (int j = 0; j < sequenceAttributes.length; ++j) {
                ReferenceAttribute referenceAttribute;
                ManagedObject referencedMo;
                if (!(sequenceAttributes[j] instanceof ReferenceAttribute) || (referencedMo = (referenceAttribute = (ReferenceAttribute)sequenceAttributes[j]).getValue(coordinator)) == null) continue;
                ((Reservable)referencedMo).release(myMo, coordinator);
            }
        }
    }

    public Object getValue(Coordinator coord) throws MoAccessException {
        return this.attributeValue.getValue(coord);
    }

    public void init(AttrList attributes, MoDataWrapper mMoData, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Struct structValues;
        this.attributeValue = new StructAttribute(this.attributeName, this.isAvcNotifier);
        mMoData.registerPersistentAttr((Attribute)this.attributeValue);
        if (attributes.contains(new String[]{this.attributeName}) && (structValues = (Struct)attributes.getValue(attributes.indexOf(this.attributeName))) != null) {
            String[] structMemberName = structValues.getNames();
            Object[] structMemberValuesArray = structValues.getValues();
            for (int i = 0; i < structMemberValuesArray.length; ++i) {
                this.attributeValue.addElement(this.objectToAttribute(structMemberValuesArray[i], structMemberName[i], managedObject, coordinator));
            }
        }
    }

    private Attribute objectToAttribute(Object structIndexValue, String structMemberName, ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        Attribute requiredAttribute = null;
        if (structIndexValue == null) {
            requiredAttribute = this.lookupAttribute(structMemberName);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.Integer")) {
            requiredAttribute = new IntegerAttribute(structMemberName, this.isAvcNotifier);
            ((IntegerAttribute)requiredAttribute).setValue((Integer)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.String")) {
            requiredAttribute = new StringAttribute(structMemberName, this.isAvcNotifier);
            ((StringAttribute)requiredAttribute).setValue((String)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.Boolean")) {
            requiredAttribute = new BooleanAttribute(structMemberName, this.isAvcNotifier, ((Boolean)structIndexValue).booleanValue());
        } else if (structIndexValue instanceof ManagedObject) {
            requiredAttribute = new ReferenceAttribute(structMemberName, this.isAvcNotifier);
            ((ReferenceAttribute)requiredAttribute).setValue((ManagedObject)structIndexValue);
            if (!(structIndexValue instanceof LoadModuleMoImpl) && structIndexValue != null) {
                ((Reservable)structIndexValue).reserve(myMo, coordinator);
            }
        } else if (structIndexValue instanceof Object[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structMemberName, false);
            Object[] newArray = (Object[])structIndexValue;
            for (int i = 0; i < ((Object[])structIndexValue).length; ++i) {
                Attribute newAttribute = this.objectToAttribute(newArray[i], structMemberName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else if (structIndexValue instanceof int[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structMemberName, false);
            int[] newArray = (int[])structIndexValue;
            for (int i = 0; i < newArray.length; ++i) {
                Attribute newAttribute = this.objectToAttribute(new Integer(newArray[i]), structMemberName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else if (structIndexValue instanceof boolean[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structMemberName, false);
            boolean[] newArray = (boolean[])structIndexValue;
            for (int i = 0; i < newArray.length; ++i) {
                Attribute newAttribute = this.objectToAttribute(newArray[i], structMemberName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else {
            throw new NotHandledAttributeTypeException();
        }
        return requiredAttribute;
    }

    private Attribute lookupAttribute(String structMemberName) throws MoAccessException {
        AttributeDataType[] structMembers;
        ReferenceAttribute attribute = null;
        try {
            structMembers = this.structMetaData.getStructMembers(this.finder);
        }
        catch (IOException e) {
            throw new SoftwareErrorException((Throwable)e);
        }
        for (int index = 0; index < structMembers.length; ++index) {
            if (!structMembers[index].getAttributeName().equals(structMemberName) || !(structMembers[index] instanceof MoRefType)) continue;
            attribute = new ReferenceAttribute(structMemberName, this.isAvcNotifier);
            break;
        }
        if (attribute == null) {
            throw new NotHandledAttributeTypeException();
        }
        return attribute;
    }

    public void recover(Attribute newValue) {
        this.attributeValue = (StructAttribute)newValue;
    }

    public void setValue(Object newValue, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        Struct structValues = (Struct)newValue;
        String[] structNames = structValues.getNames();
        Object[] newValues = structValues.getValues();
        Attribute[] newValueAttributes = new Attribute[newValues.length];
        if (this.attributeValue.getElement(structNames[0], coord) == null) {
            for (int i = 0; i < newValues.length; ++i) {
                newValueAttributes[i] = this.objectToAttribute(newValues[i], structNames[i], myMo, coord);
                this.attributeValue.addElement(newValueAttributes[i]);
            }
        } else {
            for (int i = 0; i < newValues.length; ++i) {
                this.setTypeOfValue(newValues[i], structNames[i], coord, myMo);
            }
        }
    }

    private void setTypeOfValue(Object newValue, String structName, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        IntegerAttribute structElement;
        Attribute attribute;
        if (newValue == null && (attribute = this.attributeValue.getElement(structName, coord)) != null && attribute instanceof ReferenceAttribute) {
            ReferenceAttribute structElement2 = (ReferenceAttribute)attribute;
            ManagedObject referencedMO = structElement2.getValue(coord);
            if (referencedMO != null) {
                ((Reservable)referencedMO).release(myMo, coord);
            }
            structElement2.setValue(null);
            return;
        }
        if (newValue instanceof Integer) {
            structElement = (IntegerAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((Integer)newValue);
        } else if (newValue instanceof String) {
            structElement = (StringAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((String)newValue);
        } else if (newValue instanceof Boolean) {
            structElement = (BooleanAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((Boolean)newValue);
        } else if (newValue instanceof ManagedObject) {
            structElement = (ReferenceAttribute)this.attributeValue.getElement(structName, coord);
            ManagedObject referencedMO = structElement.getValue(coord);
            if (referencedMO != null) {
                ((Reservable)referencedMO).release(myMo, coord);
            }
            ((Reservable)newValue).reserve(myMo, coord);
            structElement.setValue((ManagedObject)newValue);
        } else if (newValue instanceof Object[]) {
            structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            Object[] newArray = (Object[])newValue;
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(newArray[j], structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else if (newValue instanceof int[]) {
            structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            int[] newArray = (int[])newValue;
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(new Integer(newArray[j]), structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else if (newValue instanceof boolean[]) {
            structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            boolean[] newArray = (boolean[])newValue;
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(newArray[j], structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else {
            if (newValue instanceof Struct) {
                throw new NotHandledAttributeTypeException();
            }
            throw new NotHandledAttributeTypeException();
        }
    }

    public String toString() {
        return "Name: " + this.attributeName + " Value: " + this.attributeValue + " AVCNotifier " + this.isAvcNotifier;
    }
}

