/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.NotificationHandler;

public class NotificationHandlerImpl
implements NotificationHandler {
    private static AbstractLogger logger = LoggingService.getLogger(NotificationHandlerImpl.class.getName());
    private static final Class THIS_CLASS = NotificationHandlerImpl.class;
    private final String serviceName;
    private final int froType;
    private final boolean isIndicationsUsed;
    private MaoFroIndicationHandler indicationHandler = null;

    protected NotificationHandlerImpl(String serviceName, int froType) {
        this.serviceName = serviceName;
        this.froType = froType;
        this.isIndicationsUsed = serviceName != "NO_SERVICE";
    }

    public void deregisterForNotifications(Coordinator coordinator, int aFroId) {
        if (this.indicationHandler != null && this.isIndicationsUsed) {
            this.indicationHandler.deregisterForNotifications(coordinator, aFroId);
        }
    }

    public void registerForNotifications(Coordinator coordinator, MaoFroIndicationSubscriber aMaoRef, int aFroId) {
        logger.traceEnter(THIS_CLASS, "registerForNotifications()");
        if (this.isIndicationsUsed) {
            if (this.indicationHandler == null) {
                this.indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(this.serviceName, this.froType);
            }
            this.indicationHandler.registerForNotifications(coordinator, aMaoRef, aFroId);
        }
        logger.traceReturn(THIS_CLASS, "registerForNotifications()");
    }
}

