/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.omfapplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.omfapplication.GenericOmfContextImpl;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextAlreadyExists;
import se.ericsson.crbs.omf.omfapplication.OmfContextFactory;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;

public class OmfContextFactoryImpl
implements OmfContextFactory {
    private static final Class THIS_CLASS = OmfContextFactoryImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static OmfContextFactoryImpl theOmfContextFactory = null;
    protected static final Map doubleRegistration = new HashMap();
    private static final Object MUTEX_OBJECT = new Object();
    private final Map omcContexts = new HashMap();
    protected static final Map alarmDefinitionsXmlFilePaths = new HashMap();
    protected static final Map designMomXmlFilePaths = new HashMap();
    protected static final Map crbsNodeCompleteXmlFilePaths = new HashMap();
    protected static final Map sysInstMibXmlFilePaths = new HashMap();

    protected OmfContextFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmfContextFactoryImpl getInstance() {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            if (theOmfContextFactory == null) {
                theOmfContextFactory = new OmfContextFactoryImpl();
            }
        }
        return theOmfContextFactory;
    }

    public OmfContext createOmfContext(OmfContextId anOmfContextId, PmAttribute aPmAttributeHandler, MoMetaDataNames moMetaDataNames) throws IOException, OmfContextAlreadyExists {
        logger.traceEnter(THIS_CLASS, "createOmfContext()");
        if (anOmfContextId == null) {
            throw new OmfContextAlreadyExists("OmfContextFactory.createOmfContext() Must not have a null omf context id");
        }
        if (this.omcContexts.containsKey(anOmfContextId)) {
            throw new OmfContextAlreadyExists(anOmfContextId.toString());
        }
        this.checkAndRegisterAllMoMetaDataNames(moMetaDataNames, anOmfContextId);
        GenericOmfContextImpl omfContext = new GenericOmfContextImpl(anOmfContextId, aPmAttributeHandler, moMetaDataNames);
        this.omcContexts.put(anOmfContextId, omfContext);
        logger.traceReturn(THIS_CLASS, "createOmfContext()");
        return omfContext;
    }

    private void checkAndRegisterAllMoMetaDataNames(MoMetaDataNames moMetaDataNames, OmfContextId anOmfContextId) {
        OmfContextFactoryImpl.checkAndRegisterMoMetaDataName("alarmDefinitionsXmlFilePath", alarmDefinitionsXmlFilePaths, moMetaDataNames.getAlarmDefinitionsXmlFilePath(), anOmfContextId);
        OmfContextFactoryImpl.checkAndRegisterMoMetaDataName("designMomXmlFilePath", designMomXmlFilePaths, moMetaDataNames.getDesignMomXmlFilePath(), anOmfContextId);
        OmfContextFactoryImpl.checkAndRegisterMoMetaDataName("crbsNodeCompleteXmlFilePath", crbsNodeCompleteXmlFilePaths, moMetaDataNames.getRbsNodeCompleteXmlFilePath(), anOmfContextId);
        OmfContextFactoryImpl.checkAndRegisterMoMetaDataName("sysInstMibXmlFilePath", sysInstMibXmlFilePaths, moMetaDataNames.getSysInstMibXmlFilePath(), anOmfContextId);
    }

    private static void checkAndRegisterMoMetaDataName(String pathName, Map paths, String path, OmfContextId contextId) {
        if (paths.containsKey(path)) {
            Object oldContextId = paths.get(path);
            logger.traceAbnormal(THIS_CLASS, "Multiple registration of " + pathName + " " + path + " by " + contextId.toString() + ". Already registred by " + oldContextId);
            ArrayList<Object> dList = (ArrayList<Object>)doubleRegistration.get(path);
            if (dList == null) {
                dList = new ArrayList<Object>();
                doubleRegistration.put(path, dList);
            }
            if (!dList.contains(oldContextId)) {
                dList.add(oldContextId);
            }
            dList.add(contextId);
        } else {
            paths.put(path, contextId);
        }
    }

    public static Map getDoubleRegistration() {
        return doubleRegistration;
    }
}

