/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.extethswitch.ControlInterSwitchLinkMo;
import se.ericsson.cello.extethswitch.ControlInterSwitchLinkMoGen;
import se.ericsson.cello.extethswitch.ControlSwitchPortMo;
import se.ericsson.cello.extethswitch.ControlSwitchPortMoImpl;
import se.ericsson.cello.extethswitch.EthernetPortMo;
import se.ericsson.cello.extethswitch.EthernetPortMoImpl;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.mom.EthernetPort;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class ControlInterSwitchLinkMoImpl
extends ControlInterSwitchLinkMoGen
implements FroInfo {
    public ControlInterSwitchLinkMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public ControlInterSwitchLinkMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("controlSwitchPort1Ref");
        ManagedObject managedObject2 = (ManagedObject)setRequestContext.getAttributeFromRequest("controlSwitchPort2Ref");
        this.checkAllowedRefs(managedObject, managedObject2, coordinator);
        this.checkLinkUniqueness(managedObject, managedObject2, coordinator);
        if (managedObject != null && managedObject2 != null) {
            int n = 0;
            if (managedObject instanceof ControlSwitchPortMo) {
                n = ((ControlSwitchPortMoImpl)managedObject).getFroType();
            } else if (managedObject instanceof EthernetPortMo) {
                n = ((EthernetPortMoImpl)managedObject).getFroType();
            }
            SignedIntParameter signedIntParameter = new SignedIntParameter("port1RefFroType", n);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter);
            if (managedObject2 instanceof ControlSwitchPortMo) {
                n = ((ControlSwitchPortMoImpl)managedObject2).getFroType();
            } else if (managedObject2 instanceof EthernetPortMo) {
                n = ((EthernetPortMoImpl)managedObject2).getFroType();
            }
            SignedIntParameter signedIntParameter2 = new SignedIntParameter("port2RefFroType", n);
            setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAllowedRefs(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof EthernetPortMo) {
            if (!(managedObject2 instanceof ControlSwitchPortMo)) throw new InvalidReferenceException("ControlInterSwitchLink", "ControlInterSwitchLink MO can only refer to either two ControlSwitchPort MOs or one EthernetPort MO and One ControSwitchPort Mo ");
            this.validAllowedRefs(managedObject, coordinator);
            return;
        } else {
            if (!(managedObject instanceof ControlSwitchPortMo)) return;
            if (managedObject2 instanceof EthernetPortMo) {
                this.validAllowedRefs(managedObject2, coordinator);
                return;
            } else {
                if (managedObject2 instanceof ControlSwitchPortMo) return;
                throw new InvalidReferenceException("ControlInterSwitchLink", "ControlInterSwitchLink MO can only refer to either two ControlSwitchPort MOs or one EthernetPort MO and One ControSwitchPort Mo ");
            }
        }
    }

    private void validAllowedRefs(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (!ExtethswitchUtil.isControlEthernetPort(managedObject, coordinator)) {
            throw new ConfigurationMismatchException("controlSwitchPortRef of ControlInterSwitchLink MO can only refer to control EthernetPort MOs", "ControlInterSwitchLink");
        }
        int n = (Integer)managedObject.getAttribute("portNo", coordinator);
        if (n != EthernetPortMoImpl.PORT_NUMBER_CAX_UNIT) {
            throw new ConfigurationMismatchException("controlSwitchPortRef of ControlInterSwitchLink MO can only refer to control EthernetPort MO that hasport number equal to 13 ", "ControlInterSwitchLink");
        }
    }

    private void checkLinkUniqueness(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("ControlInterSwitchLink");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject3 = (ManagedObject)moIterator.nextElement();
                if (managedObject3.equals(this)) continue;
                ManagedObject managedObject4 = ((ControlInterSwitchLinkMo)managedObject3).getControlSwitchPort1Ref(coordinator);
                ManagedObject managedObject5 = ((ControlInterSwitchLinkMo)managedObject3).getControlSwitchPort2Ref(coordinator);
                if (this.fetchResourceId(managedObject) == this.fetchResourceId(managedObject4) && this.fetchResourceId(managedObject2) == this.fetchResourceId(managedObject5)) {
                    MessageLog.traceError(this.getClass(), (String)"PIU referenced by controlSwitchPortRef is not unique");
                    throw new AttrValueNotUniqueException(this.getClass() + "::Attribute value not unique", managedObject3.getType());
                }
                if (this.fetchResourceId(managedObject) == this.fetchResourceId(managedObject5) && this.fetchResourceId(managedObject2) == this.fetchResourceId(managedObject4)) {
                    MessageLog.traceError(this.getClass(), (String)"PIU referenced by controlSwitchPortRef is not unique");
                    throw new AttrValueNotUniqueException(this.getClass() + "::Attribute value not unique", managedObject3.getType());
                }
                if (!(!managedObject.equals(managedObject5) && !managedObject.equals(managedObject4) || managedObject2.equals(managedObject5) && managedObject2.equals(managedObject4))) {
                    MessageLog.traceError(this.getClass(), (String)("Port " + managedObject.toString() + " is defined in  another CISL Link."));
                    throw new AttrValueNotUniqueException(this.getClass() + "::Attribute value not unique", managedObject3.getType());
                }
                if (!managedObject2.equals(managedObject5) && !managedObject2.equals(managedObject4) || managedObject.equals(managedObject5) && managedObject.equals(managedObject4)) continue;
                MessageLog.traceError(this.getClass(), (String)("Port " + managedObject2.toString() + " is defined in  another CISL Link."));
                throw new AttrValueNotUniqueException(this.getClass() + "::Attribute value not unique", managedObject3.getType());
            }
        }
    }

    private int fetchResourceId(ManagedObject managedObject) throws MoAccessException {
        return PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
    }

    protected void validateControlSwitchPort1Ref(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        block2: {
            try {
                super.validateControlSwitchPort1Ref(managedObject, setRequestContext);
            }
            catch (WrongAttributeTypeException wrongAttributeTypeException) {
                if (managedObject instanceof EthernetPort) break block2;
                throw new WrongAttributeTypeException("controlSwitchPort1Ref", "ControlInterSwitchLink");
            }
        }
    }

    protected void validateControlSwitchPort2Ref(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        block2: {
            try {
                super.validateControlSwitchPort2Ref(managedObject, setRequestContext);
            }
            catch (WrongAttributeTypeException wrongAttributeTypeException) {
                if (managedObject instanceof EthernetPort) break block2;
                throw new WrongAttributeTypeException("controlSwitchPort2Ref", "ControlInterSwitchLink");
            }
        }
    }
}

