/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.ArrayList;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMoGen;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.extethswitch.PbitQueueMap;
import se.ericsson.cello.extethswitch.StructEthModOperatingModeImpl;
import se.ericsson.cello.extethswitch.SwitchPortStpMo;
import se.ericsson.cello.extethswitch.SwitchPortStpMoFactory;
import se.ericsson.cello.extethswitch.SwitchPortStpMoImpl;
import se.ericsson.cello.extethswitch.VlanMo;
import se.ericsson.cello.extethswitch.VlanMoImpl;
import se.ericsson.cello.extethswitch.mom.StructEthModOperatingMode;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetSwitchModulePortMoImpl
extends EthernetSwitchModulePortMoGen
implements FroInfo {
    private static final String[] esmpMomAttrsToCheck = new String[]{"administrativeState", "untaggedIngressPriority", "externalPort", "operatingMode", "pbitQueueMap", "untaggedIngressVlanRef", "egressUntagVlanRef", "vlanRef", "remoteFaultIndication"};
    private static final int MAX_LENGTH_VLAN_REF = 256;
    private boolean calledFromMasterPort = false;

    public EthernetSwitchModulePortMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler, switchPortStpMoFactory);
    }

    public EthernetSwitchModulePortMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Struct[] structArray;
        Object object;
        ManagedObject managedObject = this.getParent();
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (ExtethswitchUtil.isSMXB(coordinator)) {
            throw new MoCanNotBeCreatedException("EthernetSwitchModulePortMO cannot be created on node configured with SMXB");
        }
        int n = (Integer)setRequestContext.getAttributeFromRequest("portNo");
        this.checkPortNo(managedObject, "EthernetSwitchModulePort", n, coordinator);
        boolean bl = false;
        if (setRequestContext.isIncludedInRequest("externalPort")) {
            object = (Boolean)setRequestContext.getAttributeFromRequest("externalPort");
            bl = (Boolean)object;
        }
        object = UNTAGGED_INGRESS_VLAN_REF_DEFAULT;
        if (setRequestContext.isIncludedInRequest("untaggedIngressVlanRef")) {
            object = (ManagedObject)setRequestContext.getAttributeFromRequest("untaggedIngressVlanRef");
        }
        ManagedObject[] managedObjectArray = EGRESS_UNTAG_VLAN_REF_DEFAULT;
        if (setRequestContext.isIncludedInRequest("egressUntagVlanRef")) {
            managedObjectArray = (ManagedObject[])setRequestContext.getAttributeFromRequest("egressUntagVlanRef");
        }
        ManagedObject[] managedObjectArray2 = VLAN_REF_DEFAULT;
        if (setRequestContext.isIncludedInRequest("vlanRef")) {
            managedObjectArray2 = (ManagedObject[])setRequestContext.getAttributeFromRequest("vlanRef");
        }
        ManagedObject managedObject2 = LAG_REF_DEFAULT;
        if (setRequestContext.isIncludedInRequest("lagRef")) {
            managedObject2 = (ManagedObject)setRequestContext.getAttributeFromRequest("lagRef");
        }
        int n2 = 0;
        if (setRequestContext.isIncludedInRequest("administrativeState")) {
            n2 = (Integer)setRequestContext.getAttributeFromRequest("administrativeState");
        }
        int n3 = 0;
        if (setRequestContext.isIncludedInRequest("untaggedIngressPriority")) {
            n3 = (Integer)setRequestContext.getAttributeFromRequest("untaggedIngressPriority");
        }
        int n4 = 0;
        if (setRequestContext.isIncludedInRequest("remoteFaultIndication")) {
            n4 = (Integer)setRequestContext.getAttributeFromRequest("remoteFaultIndication");
        }
        Struct struct = !setRequestContext.isIncludedInRequest("operatingMode") ? (n < 9 ? StructEthModOperatingMode.createStruct(false, 2) : StructEthModOperatingMode.createStruct(false, 1)) : (Struct)setRequestContext.getAttributeFromRequest("operatingMode");
        setRequestContext.replaceParameter(this.froProxy, (Parameter)StructEthModOperatingModeImpl.toStructParameter(struct, "EthernetSwitchModulePort", "operatingMode"));
        PbitQueueMap pbitQueueMap = new PbitQueueMap("EthernetSwitchModulePort");
        if (setRequestContext.isIncludedInRequest("pbitQueueMap")) {
            structArray = (Struct[])setRequestContext.getAttributeFromRequest("pbitQueueMap");
            pbitQueueMap = new PbitQueueMap(structArray, "EthernetSwitchModulePort");
        }
        if (!(bl || object == null && managedObjectArray.length == 0)) {
            throw new OperationNotAllowedException("EthernetSwitchModulePort", "UntaggedIngressVlanRef or EgressUntagVlanRef can not be set when externalPort is set to false");
        }
        this.checkIfInVlanRef(managedObjectArray2, managedObjectArray, coordinator);
        structArray = this.makeStructArray(managedObjectArray2, managedObjectArray, coordinator);
        this.checkIfInVlanRef(managedObjectArray2, (ManagedObject)object, coordinator);
        ArrayParameter arrayParameter = this.makeArrayParameter(structArray, "vlanRefMembership", "VlanRefInformationPair", "EgressUntag", "vlanRef");
        setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        this.reserveVlanRef(managedObjectArray2, coordinator);
        int n5 = ((FroInfo)managedObject).getFroId(coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter("esmFroId", n5);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter);
        int n6 = ((PlugInUnitMo)managedObject.getParent()).getFroId(coordinator);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("piuFroId", n6);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter2);
        if (managedObject2 != null) {
            if (!managedObject.equals(managedObject2.getParent())) {
                throw new OperationNotAllowedException("Given EthernetSwitchModulePort and referred Lag have different parents.", "EthernetSwitchModulePort");
            }
            ManagedObject managedObject3 = ((LagMo)managedObject2).getMasterPort(coordinator);
            if (managedObject3 != null) {
                ArrayParameter arrayParameter2 = pbitQueueMap.toParameter();
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3), bl, struct, new PbitQueueMap(arrayParameter2, "EthernetSwitchModulePort").toStructs(), object, managedObjectArray, managedObjectArray2, new Integer(n4)};
                this.checkAttrsEqualityWithMasterPort(objectArray, managedObject3, coordinator, setRequestContext);
            }
            if (managedObject2 instanceof Reservable) {
                ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
            }
        }
    }

    private void checkAttrsEqualityWithMasterPort(Object[] objectArray, ManagedObject managedObject, Coordinator coordinator, SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        String string = "";
        String string2 = " cannot be compared; one or more components of this attribute in Master and/or Slave ports are mismatched.";
        Object[] objectArray2 = ((EthernetSwitchModulePortMoImpl)managedObject).getAttributes(esmpMomAttrsToCheck, coordinator);
        string = esmpMomAttrsToCheck[0];
        int n7 = (Integer)objectArray2[0];
        if (n7 != (n6 = ((Integer)objectArray[0]).intValue())) {
            bl2 = true;
            stringBuffer.append("\n" + string + ": Master: " + n7 + "\tThis: " + n6);
        }
        string = esmpMomAttrsToCheck[1];
        int n8 = (Integer)objectArray2[1];
        if (n8 != (n5 = ((Integer)objectArray[1]).intValue())) {
            bl2 = true;
            stringBuffer.append("\n" + string + ": Master: " + n8 + "\tThis: " + n5);
        }
        string = esmpMomAttrsToCheck[2];
        boolean bl3 = (Boolean)objectArray2[2];
        if (bl3 != (bl = ((Boolean)objectArray[2]).booleanValue())) {
            bl2 = true;
            stringBuffer.append("\n" + string + ": Master: " + bl3 + "\tThis: " + bl);
        }
        if (objectArray2[3] != null && objectArray[3] != null && ((Struct)objectArray[3]).getValue("autoNegotiation") != null && ((Struct)objectArray[3]).getValue("configuredSpeedDuplex") != null) {
            string = esmpMomAttrsToCheck[3];
            int n9 = ((Boolean)((Struct)objectArray2[3]).getValue("autoNegotiation")).booleanValue();
            int n10 = (Integer)((Struct)objectArray2[3]).getValue("configuredSpeedDuplex");
            n4 = ((Boolean)((Struct)objectArray[3]).getValue("autoNegotiation")).booleanValue() ? 1 : 0;
            n3 = (Integer)((Struct)objectArray[3]).getValue("configuredSpeedDuplex");
            if (n9 != n4 || n10 != n3) {
                bl2 = true;
                stringBuffer.append("\n" + string + ":");
                stringBuffer.append("\nAutoNeg: Master: " + (n9 != 0) + "\tThis: " + (n4 != 0));
                stringBuffer.append("\nCfgSpDuplex: Master: " + n10 + "\tThis: " + n3);
            }
        } else {
            bl2 = true;
            stringBuffer.append("\n" + string + string2);
        }
        string = esmpMomAttrsToCheck[4];
        if (objectArray2[4] != null && objectArray[4] != null) {
            Struct[] structArray = (Struct[])objectArray2[4];
            Struct[] structArray2 = (Struct[])objectArray[4];
            for (n4 = 0; n4 < 8; ++n4) {
                if (structArray[n4] != null && structArray2[n4] != null && structArray2[n4].getValue("pbitQueueMapElement_pbit") != null && structArray2[n4].getValue("pbitQueueMapElement_queue") != null) {
                    n3 = (Integer)structArray[n4].getValue("pbit");
                    int n11 = (Integer)structArray[n4].getValue("queue");
                    int n12 = (Integer)structArray2[n4].getValue("pbitQueueMapElement_pbit");
                    int n13 = (Integer)structArray2[n4].getValue("pbitQueueMapElement_queue");
                    if (n3 == n12 && n11 == n13) continue;
                    bl2 = true;
                    if (n4 == 0) {
                        stringBuffer.append("\n" + string + ":");
                    }
                    stringBuffer.append("\nPbit: Master: " + n3 + "\tThis: " + n12);
                    stringBuffer.append("\nQueue: Master: " + n11 + "\tThis: " + n13);
                    continue;
                }
                bl2 = true;
                stringBuffer.append("\n" + string + string2);
                break;
            }
        } else {
            bl2 = true;
            stringBuffer.append("\n" + string + string2);
        }
        string = esmpMomAttrsToCheck[5];
        if (objectArray2[5] != null || objectArray[5] != null) {
            if (objectArray2[5] != null && objectArray[5] != null && objectArray[5] instanceof VlanMo) {
                VlanMo vlanMo = (VlanMo)objectArray2[5];
                VlanMo vlanMo2 = (VlanMo)objectArray[5];
                if (!vlanMo.equals(vlanMo2)) {
                    bl2 = true;
                    String string3 = vlanMo.getLocalDistinguishedName();
                    String string4 = vlanMo2.getLocalDistinguishedName();
                    stringBuffer.append("\n" + string + ": Master: " + string3 + "\tThis: " + string4);
                }
            } else {
                bl2 = true;
                stringBuffer.append("\n" + string + string2);
            }
        }
        for (n2 = 6; n2 <= 7; ++n2) {
            string = esmpMomAttrsToCheck[n2];
            if (objectArray[n2] == null) {
                if (((ManagedObject[])objectArray2[n2]).length == 0) continue;
                bl2 = true;
                stringBuffer.append("\n" + string + string2);
                continue;
            }
            if (!(objectArray[n2] instanceof ManagedObject[])) {
                throw new WrongAttributeTypeException("vlanRef", "EthernetSwitchModulePort");
            }
            if (((ManagedObject[])objectArray[n2]).length == 0) {
                if (((ManagedObject[])objectArray2[n2]).length == 0) continue;
                bl2 = true;
                stringBuffer.append("\n" + string + "arrays have unequal lengths");
                continue;
            }
            this.checkVlanRefType((ManagedObject[])objectArray[n2]);
            ManagedObject[] managedObjectArray = (ManagedObject[])objectArray2[n2];
            ManagedObject[] managedObjectArray2 = (ManagedObject[])objectArray[n2];
            if (managedObjectArray.length == 0 || managedObjectArray.length != managedObjectArray2.length) {
                bl2 = true;
                stringBuffer.append("\n" + string + " has unequal lengths:\n" + "\tMaster: " + managedObjectArray.length + "\tThis: " + managedObjectArray2.length);
                continue;
            }
            for (n3 = 0; n3 < managedObjectArray.length; ++n3) {
                if (managedObjectArray2[n3] != null && managedObjectArray[n3] != null) {
                    if (((VlanMo)managedObjectArray2[n3]).equals((VlanMo)managedObjectArray[n3])) continue;
                    bl2 = true;
                    String string5 = managedObjectArray[n3].getLocalDistinguishedName();
                    String string6 = managedObjectArray2[n3].getLocalDistinguishedName();
                    if (n3 == 0) {
                        stringBuffer.append("\n" + string + ":");
                    }
                    stringBuffer.append("\n\tMaster: " + string5 + "\tThis: " + string6);
                    continue;
                }
                throw new WrongAttributeTypeException("vlanRef", "EthernetSwitchModulePort");
            }
        }
        string = esmpMomAttrsToCheck[8];
        n2 = (Integer)objectArray2[8];
        if (n2 != (n = ((Integer)objectArray[8]).intValue())) {
            bl2 = true;
            stringBuffer.append("\n" + string + ": Master: " + n2 + "\tThis: " + n);
        }
        if (bl2) {
            MessageLog.info((Class)EthernetSwitchModulePortMoImpl.class, (String)("checkAttrsEqualityWithMasterPortThe port attributes are not equal to masterPort in Lag. \n\nMismatched Attributes:" + stringBuffer.toString()));
            throw new OperationNotAllowedException("This port attribute(s) is not equal to masterPort in Lag.", "EthernetSwitchModulePort");
        }
    }

    protected void validateVlanRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateVlanRef(managedObjectArray, setRequestContext);
        if (managedObjectArray == null) {
            throw new OperationNotAllowedException("EthernetSwitchModulePort", "vlanRef can not be set to null");
        }
    }

    private ArrayParameter makeArrayParameter(Struct[] structArray, String string, String string2, String string3, String string4) throws MoAccessException {
        StructParameter structParameter;
        int n;
        ArrayParameter arrayParameter = new ArrayParameter(string);
        int n2 = 0;
        if (structArray != null) {
            n2 = structArray.length;
        }
        for (n = 0; n < n2; ++n) {
            structParameter = new StructParameter(string2);
            if (structArray[n].getValue(string3) instanceof Boolean) {
                int n3 = MaoFroTypeConverter.boolean2int((boolean)((Boolean)structArray[n].getValue("EgressUntag")));
                structParameter.add((Parameter)new SignedIntParameter(string3, n3));
            } else {
                structParameter.add((Parameter)new SignedIntParameter(string3, ((Integer)structArray[n].getValue(string3)).intValue()));
            }
            structParameter.add((Parameter)new SignedIntParameter(string4, ((Integer)structArray[n].getValue(string4)).intValue()));
            arrayParameter.add((Parameter)structParameter);
        }
        if (string.equalsIgnoreCase("vlanRefMembership")) {
            for (n = n2; n < 256; ++n) {
                structParameter = new StructParameter(string2);
                structParameter.add((Parameter)new SignedIntParameter(string3, -1));
                structParameter.add((Parameter)new SignedIntParameter(string4, -1));
                arrayParameter.add((Parameter)structParameter);
            }
        }
        return arrayParameter;
    }

    private void checkIfInVlanRef(ManagedObject[] managedObjectArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject != null) {
            this.checkIfInVlanRef(managedObjectArray, new ManagedObject[]{managedObject}, coordinator);
        }
    }

    private Struct[] makeStructArray(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObjectArray != null) {
            n = managedObjectArray.length;
        }
        int n2 = 0;
        if (managedObjectArray2 != null) {
            n2 = managedObjectArray2.length;
        }
        String[] stringArray = new String[]{"EgressUntag", "vlanRef"};
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(managedObjectArray2[i]);
        }
        if (n != 0) {
            Struct[] structArray = new Struct[n];
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[2];
                boolean bl = false;
                if (arrayList.contains(managedObjectArray[i])) {
                    bl = true;
                }
                objectArray[0] = bl;
                objectArray[1] = new Integer(((FroInfo)managedObjectArray[i]).getFroId(coordinator));
                StructImpl structImpl = new StructImpl(stringArray, objectArray);
                structArray[i] = structImpl;
            }
            return structArray;
        }
        return null;
    }

    private void checkIfInVlanRef(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        int n;
        int n2 = 0;
        if (managedObjectArray != null) {
            this.checkVlanRefType(managedObjectArray);
            n2 = managedObjectArray.length;
        }
        int n3 = 0;
        if (managedObjectArray2 != null) {
            this.checkVlanRefType(managedObjectArray2);
            n3 = managedObjectArray2.length;
        }
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(managedObjectArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            boolean bl = false;
            if (arrayList.contains(managedObjectArray2[n])) {
                bl = true;
            }
            if (bl) continue;
            throw new OperationNotAllowedException("EthernetSwitchModulePort", "this attribute is out of vlanRef array");
        }
    }

    private void checkVlanRefType(ManagedObject[] managedObjectArray) throws MoAccessException {
        int n = managedObjectArray.length;
        for (int i = 0; i < n; ++i) {
            if (managedObjectArray[i] instanceof VlanMo) continue;
            throw new WrongAttributeTypeException("vlanRef", "EthernetSwitchModulePort");
        }
    }

    public void checkPortNo(ManagedObject managedObject, String string, int n, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        while (moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (managedObject2 == this || !(managedObject2 instanceof EthernetSwitchModulePortMoImpl) || ((EthernetSwitchModulePortMoImpl)managedObject2).getPortNo(coordinator) != n) continue;
            throw new AttrValueNotUniqueException("PortNo is not unique", string);
        }
    }

    public void actionSetPbitQueue(int n, int n2, Coordinator coordinator) throws MoAccessException {
        boolean bl;
        ManagedObject managedObject = this.getLagRef(coordinator);
        boolean bl2 = bl = managedObject == null ? false : this.equals((EthernetSwitchModulePortMoImpl)((LagMo)managedObject).getMasterPort(coordinator));
        if (managedObject == null) {
            this.setPbitQueueInPort(n, n2, coordinator);
        } else if (bl) {
            ManagedObject[] managedObjectArray = ((LagMoImpl)this.getLagRef(coordinator)).getReservedBy(coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ((EthernetSwitchModulePortMoImpl)managedObjectArray[i]).setPbitQueueInPort(n, n2, coordinator);
            }
        } else {
            throw new OperationNotAllowedException("This EthernetSwitchModulePort is not the defined masterPort in Lag: " + managedObject.getLocalDistinguishedName(), "EthernetSwitchModulePort");
        }
    }

    void setPbitQueueInPort(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getPbitQueueMap(coordinator);
        PbitQueueMap pbitQueueMap = new PbitQueueMap(structArray, "EthernetSwitchModulePort");
        pbitQueueMap.setPbitQueue(n, n2, "EthernetSwitchModulePort");
        Struct[] structArray2 = pbitQueueMap.toStructs();
        Struct[] structArray3 = this.createStructAccToMom(structArray2);
        this.setPbitQueueMap(structArray3, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(pbitQueueMap.toParameter());
        arrayList.add(new SignedIntParameter("esmFroId", ((FroInfo)this.getParent()).getFroId(coordinator)));
        this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.sendNotification("pbitQueueMap", pbitQueueMap.toStructs(), coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void actionSetAllVlanRefs(ManagedObject[] managedObjectArray, ManagedObject managedObject, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        boolean bl;
        ManagedObject managedObject2 = this.getLagRef(coordinator);
        boolean bl2 = bl = managedObject2 == null ? false : this.equals((EthernetSwitchModulePortMoImpl)((LagMo)managedObject2).getMasterPort(coordinator));
        if (managedObject2 == null) {
            this.setAllVlanRefsInPort(managedObjectArray, managedObject, managedObjectArray2, coordinator);
        } else if (bl) {
            ManagedObject[] managedObjectArray3 = ((LagMoImpl)this.getLagRef(coordinator)).getReservedBy(coordinator);
            for (int i = 0; i < managedObjectArray3.length; ++i) {
                ((EthernetSwitchModulePortMoImpl)managedObjectArray3[i]).setAllVlanRefsInPort(managedObjectArray, managedObject, managedObjectArray2, coordinator);
            }
        } else {
            throw new OperationNotAllowedException("This EthernetSwitchModulePort is not the defined masterPort in Lag: " + managedObject2.getLocalDistinguishedName(), "EthernetSwitchModulePort");
        }
    }

    void setAllVlanRefsInPort(ManagedObject[] managedObjectArray, ManagedObject managedObject, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkIfInVlanRef(managedObjectArray, managedObjectArray2, coordinator);
        this.checkIfInVlanRef(managedObjectArray, managedObject, coordinator);
        ManagedObject[] managedObjectArray3 = this.getVlanRef(coordinator);
        this.releaseVlanRef(managedObjectArray3, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Struct[] structArray = this.makeStructArray(managedObjectArray, managedObjectArray2, coordinator);
        ArrayParameter arrayParameter = this.makeArrayParameter(structArray, "vlanRefMembership", "VlanRefInformationPair", "EgressUntag", "vlanRef");
        arrayList.add(arrayParameter);
        if (managedObject != null) {
            SignedIntParameter signedIntParameter = new SignedIntParameter("untaggedIngressVlanRef", ((FroInfo)managedObject).getFroId(coordinator));
            arrayList.add(signedIntParameter);
        } else {
            SignedIntParameter signedIntParameter = new SignedIntParameter("untaggedIngressVlanRef", 0);
            arrayList.add(signedIntParameter);
        }
        arrayList.add(new SignedIntParameter("esmFroId", ((FroInfo)this.getParent()).getFroId(coordinator)));
        if (!this.getExternalPort(coordinator)) {
            throw new OperationNotAllowedException("EthernetSwitchModulePort", "untaggedIngressVlanRef,egressUntagVlanRef can not be set when externalPort is set to false");
        }
        this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.reserveVlanRef(managedObjectArray, coordinator);
        NotificationSender.instance().pushAVC((ManagedObject)this, new String[]{"vlanRef", "egressUntagVlanRef", "untaggedIngressVlanRef"}, new Object[]{managedObjectArray, managedObjectArray2, managedObject}, coordinator);
    }

    private void reserveVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObjectArray != null) {
            n = managedObjectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            ((Reservable)managedObjectArray[i]).reserve((ManagedObject)this, coordinator);
        }
    }

    private void releaseVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObjectArray != null) {
            n = managedObjectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            ((Reservable)managedObjectArray[i]).release((ManagedObject)this, coordinator);
        }
    }

    protected Object handleGetCurrentPmRegister(GetRequestContext getRequestContext) throws MoAccessException {
        return null;
    }

    protected void handleSetCurrentPmRegister(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void addParameterNames(ParameterNames parameterNames) {
        if (parameterNames.contains("egressUntagVlanRef")) {
            parameterNames.add("vlanRefMembership");
        }
        if (parameterNames.contains("vlanRef")) {
            parameterNames.add("vlanRefMembership");
        }
    }

    protected Object handleGetEgressUntagVlanRef(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("vlanRefMembership");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: vlanRefMembership", "getAttributes", -1);
        }
        ManagedObject[] managedObjectArray = this.convertArrayParameter2Array(arrayParameter, "egressUntagVlanRef", getRequestContext.getCoordinator());
        return managedObjectArray;
    }

    protected void handleSetEgressUntagVlanRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public ManagedObject[] fetchVlanRef(ArrayParameter arrayParameter, Coordinator coordinator) throws MoAccessException {
        return null;
    }

    public ManagedObject fetchUntaggedIngressVlanRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        VlanMoImpl vlanMoImpl = VlanMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
        return vlanMoImpl;
    }

    protected Object handleGetLagRef(GetRequestContext getRequestContext) throws MoAccessException {
        ManagedObject managedObject = ((ReferenceAttribute)this.data.getAttribute("lagRef")).getValue(getRequestContext.getCoordinator());
        return managedObject;
    }

    protected void handleSetLagRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        LagMoImpl lagMoImpl = null;
        try {
            lagMoImpl = (LagMoImpl)this.getLagRef(coordinator);
        }
        catch (NullPointerException nullPointerException) {
            setRequestContext.setVariable((Object)"isCreate", (Object)Boolean.TRUE);
        }
        if (setRequestContext.getVariable((Object)"isCreate") != Boolean.TRUE) {
            String[] stringArray = setRequestContext.getNames();
            Object[] objectArray = new Object[]{managedObject};
            lagMoImpl = (LagMoImpl)this.getLagRef(coordinator);
            ManagedObject managedObject2 = lagMoImpl == null ? null : lagMoImpl.getMasterPort(coordinator);
            boolean bl = this.equals((EthernetSwitchModulePortMoImpl)managedObject2);
            if (managedObject == null) {
                if (lagMoImpl != null) {
                    if (!lagMoImpl.isConfigAllowed(coordinator)) {
                        throw new OperationNotAllowedException("Set not allowed beacuse the requiredNumberOfLinks must not exceed the number of Ethernet ports in the existing LAG", "EthernetSwitchModulePort");
                    }
                    lagMoImpl.release(this, coordinator);
                }
            } else if (managedObject instanceof LagMo) {
                ManagedObject managedObject3 = ((LagMo)managedObject).getMasterPort(coordinator);
                if (!this.getParent().getFullDistinguishedName().equals(managedObject.getParent().getFullDistinguishedName())) {
                    throw new OperationNotAllowedException("Given EthernetSwitchModulePort and referred Lag have different parents.", "EthernetSwitchModulePort");
                }
                if (((LagMoImpl)managedObject).equals(lagMoImpl)) {
                    if (managedObject2 != null) {
                        this.checkAndSetAttrsInExistingLag(stringArray, objectArray, lagMoImpl, bl, coordinator);
                    }
                } else {
                    if (lagMoImpl != null) {
                        if (!lagMoImpl.isConfigAllowed(coordinator)) {
                            throw new OperationNotAllowedException("Set not allowed beacuse the requiredNumberOfLinks must not exceed the number of Ethernet ports in the existing LAG", "EthernetSwitchModulePort");
                        }
                        lagMoImpl.release(this, coordinator);
                    }
                    ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
                    ((LagMoImpl)managedObject).isConfigAllowed(coordinator);
                    if (managedObject3 != null) {
                        this.compareAttrsWithMasterPort(stringArray, objectArray, managedObject3, coordinator, setRequestContext);
                    }
                }
            }
        }
        int n = managedObject == null ? 0 : ((LagMoImpl)managedObject).getFroId(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new UnsignedIntParameter("lagRef", (long)n));
        setRequestContext.addAvcNotification("lagRef", (Object)managedObject);
        ((ReferenceAttribute)this.data.getAttribute("lagRef")).setValue(managedObject);
    }

    private void checkAndSetAttrsInExistingLag(String[] stringArray, Object[] objectArray, ManagedObject managedObject, boolean bl, Coordinator coordinator) throws MoAccessException {
        if (managedObject != null) {
            if (bl) {
                this.calledFromMasterPort = true;
                this.setAllOtherPortsInLag(stringArray, objectArray, this.calledFromMasterPort, coordinator);
            } else if (!this.calledFromMasterPort) {
                throw new OperationNotAllowedException("This EthernetSwitchModulePort is not the defined masterPort in Lag: " + managedObject.getLocalDistinguishedName(), "EthernetSwitchModulePort");
            }
        }
    }

    private void setAllOtherPortsInLag(String[] stringArray, Object[] objectArray, boolean bl, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = ((LagMoImpl)this.getLagRef(coordinator)).getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i].equals(this)) continue;
            ((EthernetSwitchModulePortMoImpl)managedObjectArray[i]).setAttributes(stringArray, objectArray, bl, coordinator);
        }
    }

    protected Object handleGetVlanRef(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("vlanRefMembership");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: vlanRefMembership", "getAttributes", -1);
        }
        ManagedObject[] managedObjectArray = this.convertArrayParameter2Array(arrayParameter, "vlanRef", getRequestContext.getCoordinator());
        return managedObjectArray;
    }

    protected void handleSetVlanRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, String string) throws MoAccessException {
        if (!(managedObject instanceof LagMo)) {
            super.updateReservedMos(managedObject, managedObject2, coordinator, string);
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, boolean bl, Coordinator coordinator) throws MoAccessException {
        this.calledFromMasterPort = bl;
        super.setAttributes(stringArray, objectArray, coordinator);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        Object object;
        ManagedObject[] managedObjectArray;
        ManagedObject managedObject;
        ManagedObject[] managedObjectArray2;
        int n;
        Coordinator coordinator = setRequestContext.getCoordinator();
        String[] stringArray = setRequestContext.getNames();
        boolean bl = false;
        block0: for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < esmpMomAttrsToCheck.length; ++i) {
                if (!stringArray[n].equals(esmpMomAttrsToCheck[i])) continue;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            Object[] objectArray = setRequestContext.getValues();
            LagMoImpl lagMoImpl = (LagMoImpl)this.getLagRef(coordinator);
            managedObjectArray2 = lagMoImpl == null ? null : lagMoImpl.getMasterPort(coordinator);
            boolean bl2 = this.equals((EthernetSwitchModulePortMoImpl)managedObjectArray2);
            this.checkAndSetAttrsInExistingLag(stringArray, objectArray, lagMoImpl, bl2, coordinator);
        }
        n = 0;
        if (setRequestContext.isIncludedInRequest("administrativeState")) {
            n = (Integer)setRequestContext.getAttributeFromRequest("administrativeState");
            if (n == 2) {
                n = 0;
                setRequestContext.replaceParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n));
            }
            setRequestContext.addAvcNotification("administrativeState", (Object)new Integer(n));
        }
        if (setRequestContext.isIncludedInRequest("egressUntagVlanRef")) {
            ManagedObject[] managedObjectArray3 = (ManagedObject[])setRequestContext.getAttributeFromRequest("egressUntagVlanRef");
            if (managedObjectArray3 == null) {
                throw new OperationNotAllowedException("EthernetSwitchModulePort", "egressUntagVlanRef can not be set to null");
            }
            if (!this.getExternalPort(coordinator)) {
                throw new OperationNotAllowedException("EthernetSwitchModulePort", "egressUntagVlanRef can not be set when externalPort is set to false");
            }
            managedObjectArray2 = this.getVlanRef(setRequestContext.getCoordinator());
            this.checkVlanRefType(managedObjectArray3);
            this.checkIfInVlanRef(managedObjectArray2, managedObjectArray3, setRequestContext.getCoordinator());
            Struct[] structArray = this.makeStructArray(managedObjectArray2, managedObjectArray3, setRequestContext.getCoordinator());
            managedObject = this.makeArrayParameter(structArray, "vlanRefMembership", "VlanRefInformationPair", "EgressUntag", "vlanRef");
            setRequestContext.addParameter(this.froProxy, (Parameter)managedObject);
            setRequestContext.addAvcNotification("egressUntagVlanRef", (Object)managedObjectArray3);
        }
        if (setRequestContext.isIncludedInRequest("untaggedIngressVlanRef")) {
            ManagedObject managedObject2 = (ManagedObject)setRequestContext.getAttributeFromRequest("untaggedIngressVlanRef");
            if (!this.getExternalPort(setRequestContext.getCoordinator())) {
                throw new OperationNotAllowedException("EthernetSwitchModulePort", "untaggedIngressVlanRef can not be set when externalPort is set to false");
            }
            managedObjectArray2 = this.getVlanRef(setRequestContext.getCoordinator());
            this.checkIfInVlanRef(managedObjectArray2, managedObject2, setRequestContext.getCoordinator());
        }
        boolean bl3 = false;
        if (setRequestContext.isIncludedInRequest("externalPort") && !(bl3 = (managedObjectArray2 = (Boolean)setRequestContext.getAttributeFromRequest("externalPort")).booleanValue())) {
            ManagedObject[] managedObjectArray4 = this.getEgressUntagVlanRef(coordinator);
            managedObject = this.getUntaggedIngressVlanRef(coordinator);
            if (managedObjectArray4.length != 0 || managedObject != null) {
                throw new OperationNotAllowedException("EthernetSwitchModulePort", "externalPort can not be set to false when egressUntagVlanRefs or untaggedIngressVlanRef are not set to NULL");
            }
            boolean bl4 = false;
            managedObjectArray = this.getChildren();
            while (managedObjectArray.hasMoreElements()) {
                object = managedObjectArray.nextElement();
                if (!(object instanceof SwitchPortStpMo)) continue;
                bl4 = ((SwitchPortStpMoImpl)object).getL2gpActive(coordinator);
            }
            if (bl4) {
                throw new OperationNotAllowedException("EthernetSwitchModulePort", "externalPort can not be set to false when L2gp is active on this port.");
            }
        }
        if (setRequestContext.isIncludedInRequest("vlanRef")) {
            managedObjectArray2 = (ManagedObject[])setRequestContext.getAttributeFromRequest("vlanRef");
            this.checkVlanRefType(managedObjectArray2);
            ManagedObject[] managedObjectArray5 = this.getEgressUntagVlanRef(coordinator);
            managedObject = this.getUntaggedIngressVlanRef(coordinator);
            this.checkIfInVlanRef(managedObjectArray2, managedObjectArray5, coordinator);
            this.checkIfInVlanRef(managedObjectArray2, managedObject, coordinator);
            Struct[] structArray = this.makeStructArray(managedObjectArray2, managedObjectArray5, coordinator);
            object = this.makeArrayParameter(structArray, "vlanRefMembership", "VlanRefInformationPair", "EgressUntag", "vlanRef");
            managedObjectArray = this.getVlanRef(coordinator);
            this.releaseVlanRef(managedObjectArray, coordinator);
            setRequestContext.addParameter(this.froProxy, (Parameter)object);
            this.reserveVlanRef(managedObjectArray2, coordinator);
            setRequestContext.addAvcNotification("vlanRef", (Object)managedObjectArray2);
        }
        boolean bl5 = false;
        if (setRequestContext.isIncludedInRequest("operatingMode")) {
            bl5 = true;
        }
        if (bl5 && this.getLagRef(coordinator) != null) {
            throw new OperationNotAllowedException("The Operating Mode cannot be set as this EthernetSwitchModulePort is a member of the LAG: " + this.getLagRef(coordinator).getLocalDistinguishedName(), "EthernetSwitchModulePort");
        }
    }

    private void compareAttrsWithMasterPort(String[] stringArray, Object[] objectArray, ManagedObject managedObject, Coordinator coordinator, SetRequestContext setRequestContext) throws MoAccessException {
        Object[] objectArray2 = this.getAttributes(esmpMomAttrsToCheck, coordinator);
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < esmpMomAttrsToCheck.length; ++j) {
                if (!stringArray[i].equalsIgnoreCase(esmpMomAttrsToCheck[j])) continue;
                objectArray2[j] = objectArray[i];
                continue block0;
            }
        }
        objectArray2[4] = this.createStructAccToCodeGen((Struct[])objectArray2[4]);
        this.checkAttrsEqualityWithMasterPort(objectArray2, managedObject, coordinator, setRequestContext);
    }

    private ManagedObject[] convertArrayParameter2Array(ArrayParameter arrayParameter, String string, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray;
        if (arrayParameter.size() != 256) {
            MessageLog.traceError((Class)EthernetSwitchModulePortMoImpl.class, (String)"the length of array from FRO is wrong");
        }
        ArrayList<VlanMoImpl> arrayList = new ArrayList<VlanMoImpl>();
        ArrayList<VlanMoImpl> arrayList2 = new ArrayList<VlanMoImpl>();
        for (int i = 0; i < 256; ++i) {
            managedObjectArray = (ManagedObject[])arrayParameter.get(i);
            SignedIntParameter signedIntParameter = (SignedIntParameter)managedObjectArray.get("EgressUntag");
            SignedIntParameter signedIntParameter2 = (SignedIntParameter)managedObjectArray.get("vlanRef");
            if (signedIntParameter.getValue() == -1) continue;
            VlanMoImpl vlanMoImpl = VlanMoImpl.lookupInstance(signedIntParameter2.getValue(), coordinator);
            if (vlanMoImpl != null) {
                arrayList.add(vlanMoImpl);
                if (!MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue())) continue;
                VlanMoImpl vlanMoImpl2 = vlanMoImpl;
                arrayList2.add(vlanMoImpl2);
                continue;
            }
            MessageLog.traceError((Class)(class$se$ericsson$cello$extethswitch$EthernetSwitchModulePortMoImpl == null ? EthernetSwitchModulePortMoImpl.class$("se.ericsson.cello.extethswitch.EthernetSwitchModulePortMoImpl") : class$se$ericsson$cello$extethswitch$EthernetSwitchModulePortMoImpl), (String)"can not find the corresponding MO instance according to the Fro ID");
        }
        ManagedObject[] managedObjectArray2 = arrayList.toArray(new ManagedObject[arrayList.size()]);
        managedObjectArray = arrayList2.toArray(new ManagedObject[arrayList2.size()]);
        if (string.equalsIgnoreCase("vlanRef")) {
            if (managedObjectArray2.length != 0) {
                return managedObjectArray2;
            }
            return new ManagedObject[0];
        }
        if (string.equalsIgnoreCase("egressUntagVlanRef")) {
            if (managedObjectArray.length != 0) {
                return managedObjectArray;
            }
            return new ManagedObject[0];
        }
        return new ManagedObject[0];
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D05", 16);
    }

    protected Object handleGetPbitQueueMap(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("pbitQueueMap");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("EthernetSwitchModulePort", "Missing parameter from FRO: pbitQueueMap", "getAttributes", -1);
        }
        PbitQueueMap pbitQueueMap = new PbitQueueMap(arrayParameter, "EthernetSwitchModulePort", false);
        Struct[] structArray = pbitQueueMap.toStructs();
        Struct[] structArray2 = this.createStructAccToMom(structArray);
        return structArray2;
    }

    private Struct[] createStructAccToMom(Struct[] structArray) throws MoAccessException {
        String[] stringArray = new String[]{"pbit", "queue"};
        Struct[] structArray2 = new Struct[structArray.length];
        for (int i = 0; i < structArray.length; ++i) {
            Object[] objectArray = new Object[]{structArray[i].getValue("pbitQueueMapElement_pbit"), structArray[i].getValue("pbitQueueMapElement_queue")};
            structArray2[i] = new StructImpl(stringArray, objectArray);
        }
        return structArray2;
    }

    private Struct[] createStructAccToCodeGen(Struct[] structArray) throws MoAccessException {
        String[] stringArray = new String[]{"pbitQueueMapElement_pbit", "pbitQueueMapElement_queue"};
        Struct[] structArray2 = new Struct[structArray.length];
        for (int i = 0; i < structArray.length; ++i) {
            Object[] objectArray = new Object[]{structArray[i].getValue("pbit"), structArray[i].getValue("queue")};
            structArray2[i] = new StructImpl(stringArray, objectArray);
        }
        return structArray2;
    }

    protected void handleSetPbitQueueMap(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (structArray.length == 0) {
            PbitQueueMap pbitQueueMap = new PbitQueueMap("EthernetSwitchModulePort");
            ArrayParameter arrayParameter = pbitQueueMap.toParameter();
            setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        } else {
            PbitQueueMap pbitQueueMap = new PbitQueueMap(structArray, "EthernetSwitchModulePort");
            ArrayParameter arrayParameter = pbitQueueMap.toParameter();
            setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        }
    }

    public ManagedObject[] fetchEgressUntagVlanRef(ArrayParameter arrayParameter, Coordinator coordinator) throws MoAccessException {
        return null;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getLagRef(coordinator);
        if (managedObject != null) {
            throw new OperationNotAllowedException("Delete not allowed because this port is in a LAG: " + managedObject.getLocalDistinguishedName(), "EthernetSwitchModulePort");
        }
    }
}

