/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JButton;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AuxiliaryUnitRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CollectTraces;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.DeviceBoardRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.FileChooser;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.HwUnitRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Lock;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.NodeRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Refresh;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.RepairDeliveryNote;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.SaveDetails;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.SaveLogs;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Test;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Unlock;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;

public class ActionManager
extends KeyAdapter {
    private List<CabinetViewerAction> actions = null;
    private List<JButton> buttons = null;
    private Operable operable = null;
    private CabinetViewerAction auxRestart = null;
    private CabinetViewerAction deviceBoardRestart = null;
    private CabinetViewerAction hwUnitRestart = null;
    private CabinetViewerAction nodeRestart = null;
    private CabinetViewerAction lock = null;
    private CabinetViewerAction unlock = null;
    private CabinetViewerAction refresh = null;
    private CabinetViewerAction test = null;
    private CabinetViewerAction saveDetails = null;
    private CabinetViewerAction saveLogs = null;
    private CabinetViewerAction collectTraces = null;
    private CabinetViewerAction repairDeliveryNote = null;
    private JButton auxRestartButton = null;
    private JButton hwUnitRestartButton = null;
    private JButton deviceBoardRestartButton = null;
    private JButton nodeRestartButton = null;
    JButton lockButton = null;
    JButton unlockButton = null;
    JButton refreshButton = null;
    JButton testButton = null;
    JButton saveDetailsButton = null;
    JButton saveLogsButton = null;
    JButton collectTracesButton = null;
    JButton repairDeliveryNoteButton = null;
    final LauncherData launcherData;
    private static final String ADMINISTRATIVE_STATE = "administrativeState";

    public ActionManager(LauncherData launcherData) {
        this.makeAllActions();
        this.makeAllButtons();
        this.launcherData = launcherData;
    }

    public ActionManager(LauncherData launcherData, CvSession cvSession) {
        this.makeAllActions(cvSession);
        this.makeAllButtons();
        this.launcherData = launcherData;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 116) {
            this.refresh.actionPerformed(null);
        } else if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 120 && keyEvent.getID() == 401) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ActionManager.this.launcherData.properties.setProperty("LOG_NAME", "se.ericsson.crbs.cabv.support");
                        ActionManager.this.launcherData.launcher.runResource("/cello/emas/emtracelogcfg.xml", ActionManager.this.launcherData.ipAddress, ActionManager.this.launcherData.properties, ActionManager.this.launcherData.cabinetViewer);
                    }
                    catch (LauncherException launcherException) {
                        Trace.error(this, "Could not launch EM trace tool", launcherException);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public void updateActions(Operable operable) {
        this.operable = operable;
        this.hwUnitRestart.setOperable(operable);
        this.auxRestart.setOperable(operable);
        this.deviceBoardRestart.setOperable(operable);
        this.nodeRestart.setOperable(operable);
        this.lock.setOperable(operable);
        this.unlock.setOperable(operable);
        this.refresh.setOperable(operable);
        this.test.setOperable(operable);
        this.saveDetails.setOperable(operable);
        this.saveLogs.setOperable(operable);
        this.collectTraces.setOperable(operable);
        this.repairDeliveryNote.setOperable(operable);
        this.setEnableStatus();
    }

    public Action[] getAllActions() {
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    public JButton[] getAllActionsAsButtons() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        for (JButton jButton : this.buttons) {
            if (!jButton.isEnabled()) continue;
            arrayList.add(jButton);
        }
        return arrayList.toArray(new JButton[arrayList.size()]);
    }

    public Action[] getOnlyEnabledActions() {
        ArrayList<CabinetViewerAction> arrayList = new ArrayList<CabinetViewerAction>();
        for (int i = 0; i < this.actions.size(); ++i) {
            if (!((Action)this.actions.get(i)).isEnabled()) continue;
            arrayList.add(this.actions.get(i));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public JButton[] getOnlyEnabledActionsAsButtons() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getAction().isEnabled()) continue;
            arrayList.add(this.buttons.get(i));
        }
        return arrayList.toArray(new JButton[arrayList.size()]);
    }

    private void makeAllActions() {
        this.auxRestart = new AuxiliaryUnitRestart();
        this.deviceBoardRestart = new DeviceBoardRestart();
        this.nodeRestart = new NodeRestart();
        this.hwUnitRestart = new HwUnitRestart();
        this.lock = new Lock();
        this.unlock = new Unlock();
        this.refresh = new Refresh();
        this.test = new Test();
        this.collectTraces = new CollectTraces();
        this.repairDeliveryNote = new RepairDeliveryNote();
        FileChooser fileChooser = new FileChooser();
        this.saveDetails = new SaveDetails(fileChooser);
        this.saveLogs = new SaveLogs(fileChooser);
        this.actions = new ArrayList<CabinetViewerAction>();
        this.actions.add(this.nodeRestart);
        this.actions.add(this.lock);
        this.actions.add(this.unlock);
        this.actions.add(this.refresh);
        this.actions.add(this.test);
        this.actions.add(this.saveDetails);
        this.actions.add(this.saveLogs);
        this.actions.add(this.collectTraces);
        this.actions.add(this.repairDeliveryNote);
    }

    private void makeAllActions(CvSession cvSession) {
        this.makeAllActions();
        FileChooser fileChooser = new FileChooser();
        this.saveLogs = new SaveLogs(fileChooser, cvSession);
    }

    private void makeAllButtons() {
        this.hwUnitRestartButton = this.makeButton(this.hwUnitRestart);
        this.auxRestartButton = this.makeButton(this.auxRestart);
        this.deviceBoardRestartButton = this.makeButton(this.deviceBoardRestart);
        this.nodeRestartButton = this.makeButton(this.nodeRestart);
        this.lockButton = this.makeButton(this.lock);
        this.unlockButton = this.makeButton(this.unlock);
        this.refreshButton = this.makeButton(this.refresh);
        this.testButton = this.makeButton(this.test);
        this.saveDetailsButton = this.makeButton(this.saveDetails);
        this.saveLogsButton = this.makeButton(this.saveLogs);
        this.collectTracesButton = this.makeButton(this.collectTraces);
        this.repairDeliveryNoteButton = this.makeButton(this.repairDeliveryNote);
        this.buttons = new ArrayList<JButton>();
        this.buttons.add(this.nodeRestartButton);
        this.buttons.add(this.lockButton);
        this.buttons.add(this.unlockButton);
        this.buttons.add(this.refreshButton);
        this.buttons.add(this.testButton);
        this.buttons.add(this.saveDetailsButton);
        this.buttons.add(this.saveLogsButton);
        this.buttons.add(this.collectTracesButton);
        this.buttons.add(this.repairDeliveryNoteButton);
    }

    private JButton makeButton(CabinetViewerAction cabinetViewerAction) {
        JButton jButton = new JButton(cabinetViewerAction.getActionName());
        jButton.setAction(cabinetViewerAction);
        return jButton;
    }

    private void setEnableStatus() {
        this.setEnableStatusForRestart();
        this.setEnableStatusForLockUnlock();
        this.setEnableStatusForTest();
        this.setEnableStatusForSaveLogs();
        this.setEnableStatusForCollectTraces();
        this.setEnableStatusForRepairDeliveryNote();
    }

    private void setEnableStatusForRepairDeliveryNote() {
        if (this.operable.getTargetMoLdnForRepairDeliveryNote() == null) {
            this.repairDeliveryNote.setEnabled(false);
        } else {
            this.repairDeliveryNote.setEnabled(true);
        }
    }

    private void setEnableStatusForRestart() {
        if (this.operable.getTargetMoLdnForRestart() == null) {
            this.hwUnitRestart.setEnabled(false);
            this.nodeRestart.setEnabled(false);
            this.deviceBoardRestart.setEnabled(false);
            this.auxRestart.setEnabled(false);
        } else {
            this.determineWhatRestartToEnable();
        }
    }

    private void determineWhatRestartToEnable() {
        if (this.supportsAuxiliaryUnitRestart()) {
            this.auxRestart.setEnabled(true);
            this.hwUnitRestart.setEnabled(false);
            this.deviceBoardRestart.setEnabled(false);
            this.nodeRestart.setEnabled(false);
            this.actions.set(0, this.auxRestart);
            this.buttons.set(0, this.auxRestartButton);
        } else if (this.supportsDeviceBoardRestart()) {
            this.deviceBoardRestart.setEnabled(true);
            this.auxRestart.setEnabled(false);
            this.hwUnitRestart.setEnabled(false);
            this.nodeRestart.setEnabled(false);
            this.actions.set(0, this.deviceBoardRestart);
            this.buttons.set(0, this.deviceBoardRestartButton);
        } else if (this.supportsNodeRestart()) {
            this.nodeRestart.setEnabled(true);
            this.deviceBoardRestart.setEnabled(false);
            this.auxRestart.setEnabled(false);
            this.hwUnitRestart.setEnabled(false);
            this.actions.set(0, this.nodeRestart);
            this.buttons.set(0, this.nodeRestartButton);
        } else if (this.supportsHwUnitRestart() || this.supportsAntennaNearUnitRestart()) {
            this.hwUnitRestart.setEnabled(true);
            this.auxRestart.setEnabled(false);
            this.deviceBoardRestart.setEnabled(false);
            this.nodeRestart.setEnabled(false);
            this.actions.set(0, this.hwUnitRestart);
            this.buttons.set(0, this.hwUnitRestartButton);
        } else {
            this.nodeRestart.setEnabled(false);
            this.deviceBoardRestart.setEnabled(false);
            this.auxRestart.setEnabled(false);
            this.hwUnitRestart.setEnabled(false);
            this.actions.set(0, null);
            this.buttons.set(0, null);
            throw new RuntimeException("Unable to determine what restart action to enable! Should never get here!!!");
        }
    }

    private void setEnableStatusForLockUnlock() {
        if (this.operable.getTargetMoLdnForLockUnlock() == null) {
            this.lock.setEnabled(false);
            this.unlock.setEnabled(false);
        } else {
            boolean bl = this.isLocked();
            this.lock.setEnabled(!bl);
            this.unlock.setEnabled(bl);
        }
    }

    private void setEnableStatusForTest() {
        if (this.operable.getTargetMoLdnForTest() == null) {
            this.test.setEnabled(false);
        } else {
            this.test.setEnabled(true);
        }
    }

    private void setEnableStatusForSaveLogs() {
        if (this.operable.getTargetMoLdnForSaveLogs() == null) {
            this.saveLogs.setEnabled(false);
        } else {
            this.saveLogs.setEnabled(true);
        }
    }

    private void setEnableStatusForCollectTraces() {
        if (this.operable.getTargetMoLdnForCollectTraces() == null) {
            this.collectTraces.setEnabled(false);
        } else {
            this.collectTraces.setEnabled(true);
        }
    }

    public boolean isLocked() {
        boolean bl = false;
        CacheManager cacheManager = this.operable.getCvSession().getCacheManager();
        CachedMo cachedMo = cacheManager.getCachedMo(this.operable.getTargetMoLdnForLockUnlock());
        Object object = cachedMo.getAttribute(ADMINISTRATIVE_STATE);
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n == 0) {
                bl = true;
            }
        } else {
            Trace.error(this, "Could not read the attribute administrativeState on MO " + cachedMo.getLdn());
        }
        return bl;
    }

    public boolean supportsAuxiliaryUnitRestart() {
        String string = this.operable.getTargetMoLdnForRestart();
        return this.containsExactMatch(string, "AuxPlugInUnit");
    }

    public boolean supportsHwUnitRestart() {
        String string = this.operable.getTargetMoLdnForRestart();
        return this.containsExactMatch(string, "HwUnit");
    }

    public boolean supportsAntennaNearUnitRestart() {
        String string = this.operable.getTargetMoLdnForRestart();
        return this.containsExactMatch(string, "AntennaNearUnit");
    }

    public boolean supportsDeviceBoardRestart() {
        String string = this.operable.getTargetMoLdnForRestart();
        return this.containsExactMatch(string, "PlugInUnit");
    }

    public boolean containsExactMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.substring(0, string3.indexOf("="));
            if (!string4.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsNodeRestart() {
        String string;
        boolean bl = false;
        CmService cmService = this.operable.getCvSession().getNealManager().getCmService();
        String string2 = this.operable.getTargetMoLdnForRestart();
        if (string2.equals(string = cmService.getRootMo().getLdn())) {
            bl = true;
        }
        return bl;
    }

    public void stop() {
        this.auxRestart.cleanUp();
        this.hwUnitRestart.cleanUp();
        this.deviceBoardRestart.cleanUp();
        this.nodeRestart.cleanUp();
        this.lock.cleanUp();
        this.unlock.cleanUp();
        this.refresh.cleanUp();
        this.test.cleanUp();
        this.saveDetails.cleanUp();
        this.saveLogs.cleanUp();
        this.repairDeliveryNote.cleanUp();
    }
}

