/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Restart;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class AuxiliaryUnitRestart
extends Restart {
    private static final String DEFAULT_ACTION_NAME_IN_MOM = "restartAuxUnit";
    public static final String ACTION_DISPLAY_NAME_RESTART = "RestartAuxUnit";

    public AuxiliaryUnitRestart(Operable operable, String string, String string2) {
        super(operable, string);
        this.viewableObjectName = string2;
    }

    public AuxiliaryUnitRestart(Operable operable) {
        super(operable);
        this.viewableObjectName = operable.getViewableObjectName();
    }

    public AuxiliaryUnitRestart() {
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSharedWithExternalMe((VoData)((Object)this.operable))) {
            stringBuffer.append("<html>This unit is shared with external Me.<br><html>");
        }
        stringBuffer.append("Are you sure you want to restart ");
        stringBuffer.append(this.getViewableObjectName());
        stringBuffer.append("?");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performTheAction() {
        Transaction transaction = null;
        String string = this.getActionNameInMom();
        if (string == null) {
            string = DEFAULT_ACTION_NAME_IN_MOM;
        }
        try {
            transaction = this.getCmService().createTransaction();
            NameValue[] nameValueArray = new NameValue[]{};
            this.getMo().action(string, nameValueArray, transaction);
            transaction.commit();
            Trace.observation(this, "Restart: " + this.operable.getViewableObjectName());
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
        finally {
            this.refresh();
        }
    }

    @Override
    protected String getViewableObjectName() {
        return this.viewableObjectName;
    }
}

