/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.ConnectionFailedException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpClient;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.LoginFailedException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CollectTraces;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.progress.IndeterminateProgressDialog;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.progress.ProgressDlgUser;

public class CollectTracesFtp
extends Thread
implements ProgressDlgUser {
    static final String SOURCE_TRACE_FILE = "/c/logfiles/CollectTraces.log.gz";
    static final int MAX_TRIES = 3;
    final CollectTraces collectTraces;
    final String destFile;
    private volatile CollectTracesFtp ftpThread;
    private volatile boolean isCancelled;

    public CollectTracesFtp(CollectTraces collectTraces, String string) {
        this.collectTraces = collectTraces;
        this.destFile = string;
    }

    @Override
    public void run() {
        FtpClient ftpClient;
        this.ftpThread = this;
        this.isCancelled = false;
        Exception exception = null;
        Object var2_2 = null;
        try {
            ftpClient = this.collectTraces.getOperable().getCvSession().getFtpFactory().newFtpClient();
        }
        catch (FtpException ftpException) {
            this.collectTraces.showErrorFromThread("Unable to connect to RBS", exception);
            return;
        }
        if (this.isCancelled) {
            this.collectTraces.setStarted(false);
            return;
        }
        if (!this.connectToFtp(ftpClient)) {
            return;
        }
        this.collectTracesFromFtp(ftpClient);
        if (this.isCancelled) {
            this.collectTraces.setStarted(false);
            return;
        }
    }

    private boolean connectToFtp(FtpClient ftpClient) {
        String string;
        Exception exception = null;
        try {
            ftpClient.connect();
            string = "";
        }
        catch (ConnectionFailedException connectionFailedException) {
            string = "Unable to connect to RBS";
            exception = connectionFailedException;
        }
        catch (LoginFailedException loginFailedException) {
            string = "Wrong user name or password";
            exception = loginFailedException;
            this.collectTraces.showErrorFromThread(string, exception);
        }
        catch (Exception exception2) {
            string = "Unable to connect to RBS";
            exception = exception2;
            this.collectTraces.showErrorFromThread(string, exception);
        }
        if (exception != null && !this.isCancelled) {
            if (exception instanceof ConnectionFailedException) {
                Trace.error(this, string, exception);
                this.collectTraces.showErrorFromThread(string, exception);
            }
            this.collectTraces.setStarted(false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectTracesFromFtp(FtpClient ftpClient) {
        IndeterminateProgressDialog indeterminateProgressDialog = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Transferring file /c/logfiles/CollectTraces.log.gz");
        arrayList.add("to " + this.destFile);
        indeterminateProgressDialog = new IndeterminateProgressDialog(this, "File transfer of trace file", arrayList, true);
        SwingUtilities.invokeLater(indeterminateProgressDialog);
        String string = null;
        Exception exception = null;
        try {
            ftpClient.get(SOURCE_TRACE_FILE, this.destFile);
            ftpClient.disconnect();
        }
        catch (FtpException ftpException) {
            string = "Unable to get collect traces file";
            exception = ftpException;
        }
        catch (Exception exception2) {
            string = "Unable to get collect traces file";
            exception = exception2;
        }
        finally {
            ftpClient.disconnect();
            this.collectTraces.setStarted(false);
        }
        HideDialog hideDialog = new HideDialog(indeterminateProgressDialog);
        SwingUtilities.invokeLater(hideDialog);
        if (exception != null && !this.isCancelled) {
            Trace.error(this, string, exception);
            this.collectTraces.showErrorFromThread(string, exception);
        }
    }

    @Override
    public void progressCancelButtonPressed() {
        this.isCancelled = true;
        this.ftpThread.interrupt();
    }

    class HideDialog
    implements Runnable {
        JDialog jd;

        public HideDialog(JDialog jDialog) {
            this.jd = jDialog;
        }

        @Override
        public void run() {
            this.jd.setVisible(false);
        }
    }
}

