/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ManualRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Restart;

public class DeviceBoardRestart
extends Restart {
    protected ButtonGroup radioButtonGroup = null;
    protected String errorCommand = "ERROR";
    protected String upgradeCommand = "UPGRADE";
    final ManualRestart manualRestart;

    public DeviceBoardRestart(Operable operable) {
        super(operable);
        this.manualRestart = new ManualRestart(operable.getCvSession().getCvSessionController().getMainWindofFrame());
    }

    public DeviceBoardRestart(Operable operable, String string) {
        super(operable, string);
        this.manualRestart = new ManualRestart(operable.getCvSession().getCvSessionController().getMainWindofFrame());
    }

    public DeviceBoardRestart() {
        this.manualRestart = new ManualRestart(null);
    }

    @Override
    protected String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Please state the reason for restarting ");
        stringBuffer.append(this.getViewableObjectName());
        stringBuffer.append("!");
        return stringBuffer.toString();
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.manualRestart.clear();
        jPanel.add((Component)this.manualRestart.getPanel(), gridBagConstraints);
    }

    protected boolean verifyInput() {
        return this.manualRestart.verifyInput();
    }

    @Override
    protected void performTheAction() {
        this.manualRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manualRestart() {
        Transaction transaction = null;
        try {
            Trace.observation(this, "Restart: " + this.getViewableObjectName());
            transaction = this.getCmService().createTransaction();
            NameValue[] nameValueArray = new NameValue[]{this.getCmService().getNameValueFactory().create("restartRank", this.manualRestart.getRank()), this.getCmService().getNameValueFactory().create("restartReason", this.manualRestart.getReason()), this.getCmService().getNameValueFactory().create("restartInfo", this.manualRestart.getInfo())};
            this.getMo().action("manualRestart", nameValueArray, transaction);
            transaction.commit();
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
        finally {
            this.refresh();
        }
    }
}

