/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;

public class FileChooser
extends JFileChooser {
    private String contents = null;

    public void setContents(String string) {
        this.contents = string;
    }

    public void showSaveDialog(String string, String string2) {
        this.setDialogTitle(string);
        this.setSelectedFile(new File(string2));
        super.showSaveDialog(null);
    }

    @Override
    public void approveSelection() {
        File file = this.makeFile();
        if (!file.exists()) {
            this.saveFile(file);
            super.approveSelection();
        } else if (this.confirmOverwrite()) {
            this.saveFile(file);
            super.approveSelection();
        }
    }

    private File makeFile() {
        File file = new File(this.getCurrentDirectory().getPath() + File.separator + this.getSelectedFile().getName());
        return file;
    }

    private void saveFile(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.contents);
            fileWriter.close();
        }
        catch (IOException iOException) {
            Trace.error(this, iOException.getMessage(), iOException);
        }
    }

    private boolean confirmOverwrite() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Are you sure you want to overwrite ");
        stringBuffer.append(this.getSelectedFile().getName());
        stringBuffer.append("?");
        return JOptionPane.showConfirmDialog(null, stringBuffer.toString(), "Overwrite", 0, 2) == 0;
    }
}

