/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LockedState;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.TestWindow;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.TestableState;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.UnlockedState;

public class Test
extends CabinetViewerAction {
    private static String ACTION_DISPLAY_NAME_TEST = "Test";
    protected Mo mo = null;
    protected String ldn = null;
    private TestableState unlockedState = null;
    private TestableState lockedState = null;
    private TestWindow testWindow = null;
    private Mo lockUnlockMo = null;
    String lockUnlockLdn = null;

    public Test() {
        super(ACTION_DISPLAY_NAME_TEST, "KEY_TESTABLE");
        this.init();
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.ldn = operable.getTargetMoLdnForTest();
        this.lockUnlockLdn = operable.getTargetMoLdnForRestart();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
        if (this.lockUnlockLdn != null) {
            this.lockUnlockMo = this.cmService.getMo(this.lockUnlockLdn);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.testWindow.cleanUp();
    }

    private void init() {
        this.testWindow = new TestWindow(this);
        this.unlockedState = new UnlockedState(this.testWindow);
        this.lockedState = new LockedState(this.testWindow);
    }

    public TestableState getUnlockedState() {
        return this.unlockedState;
    }

    public TestableState getLockedState() {
        return this.lockedState;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            NameValue nameValue = this.lockUnlockMo.getAttribute("administrativeState", null);
            int n = nameValue.getIntValue();
            if (n == 1) {
                JFrame jFrame = this.getOperable().getCvSession().getCvSessionController().getMainWindofFrame();
                JOptionPane.showMessageDialog(jFrame, "Please lock the board before testing!", "Board Test Warning", 2);
            } else {
                this.testWindow.show(this.operable);
            }
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            }
            this.showOperationError(exception);
        }
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    @Override
    protected void performTheAction() {
    }
}

