/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AdminStateHelper;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Test;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.TestableState;

public class TestableObject {
    private static final int MAX_ID_LENGHT = 31;
    final Test tester;
    final Operable operable;
    final CmService cmService;
    final String testLdn;
    private Mo lockUnlockMo;
    private Mo testMo = null;
    private TestableState state = null;
    private String boardName = null;
    private String testResult = null;
    private String adminState = null;
    final List changeListeners = new ArrayList();
    private MyConsumer testMoObserver = null;
    private MyConsumer testMoLockUnlockObserver = null;
    private CmSubscription testMoCmSubscription = null;
    private CmSubscription testMoLockUnlockCmSubscription = null;

    public TestableObject(Test test, Operable operable) {
        this.tester = test;
        this.operable = operable;
        this.cmService = operable.getCvSession().getNealManager().getCmService();
        this.testLdn = operable.getTargetMoLdnForTest();
        if (this.testLdn != null) {
            try {
                this.testMo = this.cmService.getMo(this.testLdn);
                this.lockUnlockMo = this.testMo.getParent(null);
                this.testMoObserver = new MyConsumer();
                this.testMoCmSubscription = this.testMo.subscribe(NotificationType.AVC, (CmNotificationConsumer)this.testMoObserver);
                this.testMoLockUnlockObserver = new MyConsumer();
                this.testMoLockUnlockCmSubscription = this.lockUnlockMo.subscribe(NotificationType.AVC, (CmNotificationConsumer)this.testMoLockUnlockObserver);
            }
            catch (CmException cmException) {
                Trace.error(this, "Constructor", cmException);
            }
        }
        this.updateContents();
        if (this.adminState.equalsIgnoreCase("Unlocked")) {
            this.state = test.getUnlockedState();
        }
        if (this.adminState.equalsIgnoreCase("Locked")) {
            this.state = test.getLockedState();
        }
    }

    public void unsubscribeCSNotifications() {
        try {
            if (this.testMo != null && this.testMoObserver != null && this.testMoCmSubscription != null) {
                this.testMoCmSubscription.cancel();
                this.testMoObserver = null;
                this.testMoCmSubscription = null;
            }
            if (this.lockUnlockMo != null && this.testMoLockUnlockObserver != null && this.testMoLockUnlockCmSubscription != null) {
                this.testMoLockUnlockObserver = null;
                this.testMoLockUnlockCmSubscription = null;
            }
        }
        catch (CmException cmException) {
            Trace.error(this, "Unsubscribe", cmException);
        }
    }

    protected void updateContents() {
        this.setBoardName();
        this.setTestResult();
        this.setAdministrativeState();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void lock() {
        Object object;
        Transaction transaction = null;
        try {
            object = this.cmService.getNameValueFactory().create("administrativeState", 0);
            transaction = this.cmService.createTransaction();
            this.lockUnlockMo.setAttribute((NameValue)object, transaction);
            transaction.commit();
            Trace.observation(this, "Lock: " + this.operable.getViewableObjectName());
            this.state = this.tester.getLockedState();
        }
        catch (CmException cmException) {
            this.showOperationError((Exception)((Object)cmException));
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                Trace.error(this, "Rollback failed. " + exception);
            }
        }
        this.updateContents();
        object = new AdminStateHelper(this.lockUnlockMo, 1, this.operable);
        ((Thread)object).start();
    }

    public void test() {
        try {
            Transaction transaction = this.cmService.createNullTransaction();
            String string = "" + this.getBoardName() + " being tested";
            if (string.length() > 31) {
                string = string.substring(0, 31);
            }
            NameValue[] nameValueArray = new NameValue[]{this.cmService.getNameValueFactory().create("testId", string)};
            this.testMo.action("startHwTest", nameValueArray, transaction);
            transaction.commit();
            Trace.observation(this, "Test: " + this.operable.getViewableObjectName());
            this.state = this.tester.getLockedState();
        }
        catch (CmException cmException) {
            this.showOperationError((Exception)((Object)cmException));
        }
        this.operable.refresh();
    }

    public void unlock() {
        Object object;
        Transaction transaction = null;
        try {
            object = this.cmService.getNameValueFactory().create("administrativeState", 1);
            transaction = this.cmService.createTransaction();
            this.lockUnlockMo.setAttribute((NameValue)object, transaction);
            transaction.commit();
            Trace.observation(this, "Unlock: " + this.operable.getViewableObjectName());
            this.state = this.tester.getUnlockedState();
        }
        catch (CmException cmException) {
            this.showOperationError((Exception)((Object)cmException));
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                Trace.error(this, "Rollback failed. " + exception);
            }
        }
        this.updateContents();
        object = new AdminStateHelper(this.lockUnlockMo, 0, this.operable);
        ((Thread)object).start();
    }

    public void highlight() {
        this.state.changeEnableStatesInWindow();
    }

    public String getBoardName() {
        return this.boardName;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public String getAdministrativeState() {
        return this.adminState;
    }

    private void setBoardName() {
        this.boardName = this.operable.getViewableObjectName();
    }

    private void setTestResult() {
        try {
            NameValue nameValue = this.testMo.getAttribute("hwTestResult", null);
            int n = nameValue.getIntValue();
            switch (n) {
                case 1: {
                    this.testResult = "Failed";
                    break;
                }
                case 0: {
                    this.testResult = "Passed";
                    break;
                }
                case 2: {
                    this.testResult = "Pending";
                    break;
                }
                case 3: {
                    this.testResult = "Undetermined";
                    break;
                }
                default: {
                    this.testResult = "---";
                    break;
                }
            }
        }
        catch (CmException cmException) {
            Trace.error(this, "setTestResult", cmException);
        }
        catch (IllegalTypeException illegalTypeException) {
            Trace.error(this, "setTestResult", illegalTypeException);
        }
    }

    private void setAdministrativeState() {
        try {
            NameValue nameValue = this.lockUnlockMo.getAttribute("administrativeState", null);
            int n = nameValue.getIntValue();
            switch (n) {
                case 0: {
                    this.adminState = "Locked";
                    break;
                }
                case 1: {
                    this.adminState = "Unlocked";
                    break;
                }
                case 2: {
                    this.adminState = "Shutting down";
                    break;
                }
                default: {
                    this.adminState = "---";
                    break;
                }
            }
        }
        catch (CmException cmException) {
            Trace.error(this, "setAdministrativeState", cmException);
        }
        catch (IllegalTypeException illegalTypeException) {
            Trace.error(this, "setAdministrativeState", illegalTypeException);
        }
    }

    private void showOperationError(Exception exception) {
        Trace.error(this, "Hardware test failed. " + exception);
        this.operable.getCvSession().getCvSessionController().showErrorDialog("Hardware test failed.", exception);
    }

    class MyConsumer
    implements CmNotificationConsumer {
        MyConsumer() {
        }

        public void attributeValueChanged(String string, NameValue[] nameValueArray, int n) {
            int n2;
            for (n2 = 0; n2 < nameValueArray.length; ++n2) {
                String string2 = nameValueArray[n2].getName();
                if (!"hwTestResult".equals(string2)) continue;
                TestableObject.this.updateContents();
            }
            for (n2 = 0; n2 < TestableObject.this.changeListeners.size(); ++n2) {
                ((ChangeListener)TestableObject.this.changeListeners.get(n2)).stateChanged(new ChangeEvent(TestableObject.this));
            }
        }

        public void communicationFailed(CmSubscription cmSubscription, Node node, String string) {
            Trace.error(this, "Hardware test failed due to connection problems. " + string);
            TestableObject.this.operable.getCvSession().getCvSessionController().showErrorDialog("Hardware test failed due to connection problems." + string, null);
        }

        public void subscriptionNotActive(CmSubscription cmSubscription, Node node) {
            Trace.error(this, "Hardware test failed due to connection problems. ");
            TestableObject.this.operable.getCvSession().getCvSessionController().showErrorDialog("Hardware test failed due to connection problems.", null);
        }

        public void moCreated(String string, int n) {
        }

        public void moDeleted(String string, int n) {
        }

        public void overflowOccurred(String string) {
            Trace.warning(this, "overflowOccurred");
        }
    }
}

