/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.BbifLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StatePanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class StateOrLedPanel
extends VoView {
    final VoData voData;
    private StatePanel statePanel;
    private LedPanel ledPanel;
    private BbifLedPanel bbifLedPanel;

    public StateOrLedPanel(VoData voData, String string) {
        super(voData);
        this.voData = voData;
        this.setToolTipText(string);
        this.createLedAndStatePanels();
        this.setLedViewActive();
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public void setStateViewActive() {
        this.setStatePanelActive(true);
    }

    @Override
    public void setLedViewActive() {
        this.setStatePanelActive(false);
    }

    protected void setStatePanelActive(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof StatePanel) {
                componentArray[i].setVisible(bl);
                continue;
            }
            if (componentArray[i] instanceof LedPanel) {
                componentArray[i].setVisible(!bl);
                continue;
            }
            if (!(componentArray[i] instanceof BbifLedPanel)) continue;
            componentArray[i].setVisible(!bl);
        }
        this.repaint();
    }

    @Override
    public void setSelectionManager(VoSelectionManager voSelectionManager) {
        super.setSelectionManager(voSelectionManager);
        if (this.statePanel != null) {
            this.statePanel.setSelectionManager(voSelectionManager);
        }
    }

    @Override
    public void setActionManager(ActionManager actionManager) {
        super.setActionManager(actionManager);
        if (this.statePanel != null) {
            this.statePanel.setActionManager(actionManager);
        }
    }

    protected void createLedAndStatePanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (this.voData != null) {
            InfoView infoView;
            if (this.voData instanceof StateViewable && (infoView = ((StateViewable)((Object)this.voData)).getInfoView("stateView")) != null) {
                this.statePanel = new StatePanel(this.voData, this.getToolTipText());
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(4, 0, 2, 0);
                this.add((Component)this.statePanel, gridBagConstraints);
            }
            boolean bl = false;
            if (this.voData.getProperty("SHOW_LEDS") != null) {
                bl = true;
            } else if (this.voData.isMomLedSupported()) {
                bl = true;
            } else if (this.voData.getPropertyValue("ledDataGroups") != null) {
                bl = true;
            }
            if (bl) {
                this.ledPanel = new LedPanel(this.voData);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(4, 0, 2, 0);
                this.add((Component)this.ledPanel, gridBagConstraints);
            } else if (this.voData.getSpecificType().equalsIgnoreCase("BBIF")) {
                this.bbifLedPanel = new BbifLedPanel();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(4, 0, 2, 0);
                this.add((Component)this.bbifLedPanel, gridBagConstraints);
            }
        }
        this.initialise();
    }

    @Override
    public void cleanUp() {
        if (this.statePanel != null) {
            this.statePanel.cleanUp();
            this.statePanel = null;
        }
        if (this.ledPanel != null) {
            this.ledPanel.cleanUp();
            this.ledPanel = null;
        }
        this.removeAll();
    }

    @Override
    public void initialise() {
        super.initialise();
        this.setBorder(null);
        this.setOpaque(false);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.statePanel != null) {
            this.statePanel.setBackground(color);
        }
        if (this.ledPanel != null) {
            this.ledPanel.setBackground(color);
        }
    }
}

