/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.ContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.HorizontalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.RbsLookAndFeel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SectorUnitView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualAntennaUnitContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualSectorAntennaContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;

public class VirtualSectorContainerView
extends ContainerView {
    public static final String NAME = "VirtualSectorContainer";
    final String sector;
    private static final int MIN_NO_OF_SECTOR_ANTENNAS = 2;
    private static final int MIN_NO_OF_TMA_SUBUNITS = 4;
    private static final int MIN_NO_OF_SECTOR_ANTENNAUNITS = 2;
    private int sectorElementGridX = 0;
    private int sectorElementGridY = 0;
    final Map<String, VirtualSectorAntennaContainerView> virtualSectorAntennaContainers = new HashMap<String, VirtualSectorAntennaContainerView>();
    final Map<String, VirtualAntennaUnitContainerView> virtualAntennaUnitContainers = new HashMap<String, VirtualAntennaUnitContainerView>();

    public VirtualSectorContainerView(String string, String string2) {
        super(string + " " + string2);
        this.sector = string2;
        this.setToolTipText(string + " " + string2);
    }

    @Override
    public void buildCabinet() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        this.getContentPanel().setLayout(new GridBagLayout());
        this.getContentPanel().setOpaque(false);
        this.setCabinetLabel(new HorizontalLabel(this.getName()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.getCabinetLabel(), (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getContentPanel(), (Object)gridBagConstraints);
    }

    @Override
    public void add(Component component, Object object) {
        if (object == null) {
            GridBagConstraints gridBagConstraints = null;
            if (component instanceof SectorUnitView) {
                SectorUnitView sectorUnitView = (SectorUnitView)component;
                if (sectorUnitView.getVoData().getProperty("KEY_SORT_ON_SECTOR_ANTENNA") != null && this.getEquippedSectorsAntennas(sectorUnitView, this.sector).length >= 2) {
                    String string = ((ViewableObject)sectorUnitView.getVoData()).getSectorAntennaId();
                    VirtualSectorAntennaContainerView virtualSectorAntennaContainerView = this.virtualSectorAntennaContainers.get(string);
                    VirtualSectorAntennaContainerView virtualSectorAntennaContainerView2 = null;
                    if (string != null && virtualSectorAntennaContainerView == null) {
                        virtualSectorAntennaContainerView2 = new VirtualSectorAntennaContainerView("SectorAntenna", this.sector, string);
                        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                        gridBagConstraints2.gridx = this.sectorElementGridX++;
                        gridBagConstraints2.gridy = this.sectorElementGridY;
                        gridBagConstraints2.gridwidth = 1;
                        gridBagConstraints2.gridheight = 1;
                        gridBagConstraints2.weightx = 1.0;
                        gridBagConstraints2.weighty = 1.0;
                        gridBagConstraints2.fill = 1;
                        gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
                        this.getContentPanel().add((Component)virtualSectorAntennaContainerView2, gridBagConstraints2);
                        this.virtualSectorAntennaContainers.put(string, virtualSectorAntennaContainerView2);
                        virtualSectorAntennaContainerView2.setInstallationState(1);
                    } else {
                        virtualSectorAntennaContainerView2 = virtualSectorAntennaContainerView;
                    }
                    virtualSectorAntennaContainerView2.add(component, null);
                } else if (sectorUnitView.getVoData().getProperty("KEY_SORT_ON_ANTENNA_UNIT") != null && this.isPSICoverage(sectorUnitView, this.sector)) {
                    String string = ((ViewableObject)sectorUnitView.getVoData()).getAntennaUnitId();
                    VirtualAntennaUnitContainerView virtualAntennaUnitContainerView = this.virtualAntennaUnitContainers.get(string);
                    VirtualAntennaUnitContainerView virtualAntennaUnitContainerView2 = null;
                    if (string != null && virtualAntennaUnitContainerView == null) {
                        virtualAntennaUnitContainerView2 = new VirtualAntennaUnitContainerView("AntennaUnit", string);
                        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                        gridBagConstraints3.gridx = this.sectorElementGridX++;
                        gridBagConstraints3.gridy = this.sectorElementGridY;
                        gridBagConstraints3.gridwidth = 1;
                        gridBagConstraints3.gridheight = 1;
                        gridBagConstraints3.weightx = 1.0;
                        gridBagConstraints3.weighty = 1.0;
                        gridBagConstraints3.fill = 1;
                        gridBagConstraints3.insets = new Insets(0, 3, 0, 3);
                        this.getContentPanel().add((Component)virtualAntennaUnitContainerView2, gridBagConstraints3);
                        this.virtualAntennaUnitContainers.put(string, virtualAntennaUnitContainerView2);
                        virtualAntennaUnitContainerView2.setInstallationState(1);
                    } else {
                        virtualAntennaUnitContainerView2 = virtualAntennaUnitContainerView;
                    }
                    virtualAntennaUnitContainerView2.add(component, null);
                } else {
                    gridBagConstraints = sectorUnitView.getGridBagConstraints();
                    if (this.virtualSectorAntennaContainers.isEmpty() && this.virtualAntennaUnitContainers.isEmpty()) {
                        gridBagConstraints.gridy = this.sectorElementGridY++;
                        gridBagConstraints.gridx = this.sectorElementGridX;
                    } else {
                        gridBagConstraints.gridx = this.sectorElementGridX = 0;
                        gridBagConstraints.gridy = ++this.sectorElementGridY;
                    }
                    this.getContentPanel().add(component, gridBagConstraints);
                }
            } else {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridx = this.sectorElementGridX;
                gridBagConstraints.gridy = this.sectorElementGridY++;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                this.getContentPanel().add(component, gridBagConstraints);
            }
        } else {
            super.add(component, object);
        }
    }

    private boolean isPSICoverage(SectorUnitView sectorUnitView, String string) {
        return this.getEquippedTmaSubUnits(sectorUnitView, string).length >= 4 && this.getEquippedSectorsAntennaUnits(sectorUnitView, string).length >= 2;
    }

    public void addPushUpJPanel() {
        if (this.virtualSectorAntennaContainers.isEmpty() && this.virtualAntennaUnitContainers.isEmpty()) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = this.sectorElementGridX;
            gridBagConstraints.gridy = this.sectorElementGridY++;
            gridBagConstraints.weighty = 100.0;
            JPanel jPanel = new JPanel();
            jPanel.setBackground(RbsLookAndFeel.COLOR_AUTONOMOUS_UNIT);
            this.add((Component)jPanel, (Object)gridBagConstraints);
        } else if (!this.virtualSectorAntennaContainers.isEmpty()) {
            JPanel jPanel;
            Set<String> set = this.virtualSectorAntennaContainers.keySet();
            for (String object2 : set) {
                jPanel = this.virtualSectorAntennaContainers.get(object2);
                ((VirtualSectorAntennaContainerView)jPanel).addPushUpJPanel();
            }
            GridBagConstraints object3 = new GridBagConstraints();
            object3.gridx = this.sectorElementGridX = 0;
            object3.gridy = ++this.sectorElementGridY;
            object3.weighty = 100.0;
            jPanel = new JPanel();
            jPanel.setBackground(RbsLookAndFeel.COLOR_AUTONOMOUS_UNIT);
            this.getContentPanel().add((Component)jPanel, object3);
        } else {
            JPanel jPanel;
            Set<String> set = this.virtualAntennaUnitContainers.keySet();
            for (String string : set) {
                jPanel = this.virtualAntennaUnitContainers.get(string);
                ((VirtualAntennaUnitContainerView)jPanel).addPushUpJPanel();
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = this.sectorElementGridX = 0;
            gridBagConstraints.gridy = ++this.sectorElementGridY;
            gridBagConstraints.weighty = 100.0;
            jPanel = new JPanel();
            jPanel.setBackground(RbsLookAndFeel.COLOR_AUTONOMOUS_UNIT);
            this.getContentPanel().add((Component)jPanel, gridBagConstraints);
        }
    }

    protected String[] getEquippedSectorsAntennas(SectorUnitView sectorUnitView, String string) {
        Object object2;
        Object object3;
        Object object4 = sectorUnitView.getVoData().getProperty("MOTYPE_NAME_NO_OF_SECTOR_ANTENNAS");
        String string2 = null;
        if (object4 instanceof List) {
            object3 = (List)object4;
            string2 = object3.get(0).toString();
        }
        object3 = string2.toString();
        CacheManager cacheManager = sectorUnitView.getVoData().getCvSession().getCacheManager();
        List<CachedMo> list = cacheManager.getCachedMosOfType((String)object3);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CachedMo cachedMo = list.get(i);
            object2 = cachedMo.getLdn();
            String[] object = ((String)object2).split("=");
            stringArray[i] = object[object.length - 1];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i].split("-");
            String string3 = object2[0];
            if (!string.equals(string3)) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        object2 = new StringBuffer();
        for (String string4 : stringArray2) {
            ((StringBuffer)object2).append("\"" + string4 + "\",");
        }
        Trace.observation(this, "Found sectorAntennas for sector " + string + ": " + ((StringBuffer)object2).toString());
        return stringArray2;
    }

    protected String[] getEquippedTmaSubUnits(SectorUnitView sectorUnitView, String string) {
        Object object;
        Object object2 = sectorUnitView.getVoData().getProperty("MOTYPE_NAME_NO_OF_TMA_SUBUNITS");
        String string2 = null;
        if (object2 instanceof List) {
            object = (List)object2;
            string2 = object.get(0).toString();
        }
        object = string2.toString();
        CacheManager cacheManager = sectorUnitView.getVoData().getCvSession().getCacheManager();
        List<CachedMo> list = cacheManager.getCachedMosOfType((String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            CachedMo cachedMo = list.get(i);
            this.compareWithSectorIdForLTE(string, arrayList, cachedMo);
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private String[] getEquippedSectorsAntennaUnits(SectorUnitView sectorUnitView, String string) {
        CacheManager cacheManager = ((ViewableObject)sectorUnitView.getVoData()).getCvSession().getCacheManager();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CachedMo> list = cacheManager.getCachedMosOfType("AntennaUnit");
        if (list != null && list.size() > 0) {
            for (CachedMo cachedMo : list) {
                this.compareWithSectorIdForLTE(string, arrayList, cachedMo);
            }
        }
        Object object = new String[arrayList.size()];
        object = arrayList.toArray(new String[arrayList.size()]);
        return object;
    }

    private void compareWithSectorIdForLTE(String string, ArrayList<String> arrayList, CachedMo cachedMo) {
        String string2;
        String string3;
        String string4 = cachedMo.getLdn();
        int n = string4.indexOf("AntennaUnitGroup=");
        if (n > -1 && string.equals(string3 = (string2 = string4.substring(n)).substring(string2.indexOf("=") + 1, string2.indexOf(",")))) {
            arrayList.add(string3);
        }
    }
}

