/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AbstractInfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class FormPanel
extends AbstractInfoPanel {
    final String borderName;
    private String name;

    public FormPanel(String string, VoData voData) {
        super(voData);
        this.borderName = string;
        this.name = string;
    }

    public FormPanel(String string) {
        this.borderName = string;
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getBorderName() {
        return this.borderName;
    }

    @Override
    public void update(VoData voData) {
        try {
            this.removeAll();
            this.updateVo(voData);
            this.createPanel();
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to show panel " + this.borderName, exception);
        }
    }

    protected void createPanel() {
        if (!this.isVisible()) {
            this.name = this.borderName;
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 10.0;
        gridBagConstraints2.anchor = 18;
        this.setLayout(new GridBagLayout());
        int n = this.getNoOfAttributes();
        for (int i = 0; i < n; ++i) {
            String string = this.getLabel(i);
            Object object = this.getValue(i);
            if (object == null && this.isOptional(i)) continue;
            if (object == null || object.equals("")) {
                object = "-";
            }
            if (this.skip(object)) continue;
            gridBagConstraints.gridy = i;
            this.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints2.gridy = i;
            JTextArea jTextArea = new JTextArea(object.toString());
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setBorder(null);
            jTextArea.setBackground(this.getBackground());
            if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                jTextArea.setName(string + "_Value");
            }
            this.add((Component)jTextArea, gridBagConstraints2);
        }
        this.setBorder(new TitledBorder(this.borderName));
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.name = this.borderName + "_Group";
        }
    }

    private boolean skip(Object object) {
        return "LED".equals(this.borderName) && (!this.isApplicable(object) || "-".equals("value"));
    }
}

