/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters;

import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;

public class SpecialIndicatorConverter
implements ValueConverter {
    private static final String STRUCT_ATTR_NAME = "indicatorName";
    private static final String STRUCT_ATTR_VALUE = "indicatorStatus";
    private static final String[] INDICATOR_VALUES = new String[]{"Not applicable", "Not available", "No fault exist in support unit (Off)", "A HW fault exist in support unit (Steady on)"};

    @Override
    public Object convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Struct[]) {
            Struct[] structArray = (Struct[])object;
            if (structArray.length == 0) {
                return "-";
            }
            Object[] objectArray = new Object[structArray.length];
            NameValue nameValue = null;
            NameValue nameValue2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < structArray.length; ++i) {
                nameValue = structArray[i].getMember(STRUCT_ATTR_NAME);
                nameValue2 = structArray[i].getMember(STRUCT_ATTR_VALUE);
                if (nameValue == null || nameValue2 == null) {
                    Trace.error(this, "Wrong mib configuation");
                    return null;
                }
                if (i != 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(nameValue.getValue() + " : " + INDICATOR_VALUES[Integer.parseInt(nameValue2.getValue().toString())]);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private String getValue(int n) {
        if (n < 0 || n >= INDICATOR_VALUES.length) {
            Trace.warning(this, n + " out of index of PROVIDED_SERVICES");
            return "-";
        }
        return INDICATOR_VALUES[n];
    }
}

