/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.TechnicianPresentStatusListener;

public class TechnicianPresentStatus
implements Runnable {
    private static final int WAIT_FOR_NEXT_TIME = 20000;
    private static final String TECHNICIAN_PRESENT_ATTR = "technicianPresent";
    protected Mo nodeBFunctionMo = null;
    protected String nodeBFunctionLdn = null;
    private volatile boolean collectTechnicianPresentStatusStarted = false;
    private volatile boolean savedTpValue = false;
    final List<TechnicianPresentStatusListener> technicianPresentAttributeListeners;
    Operable operable = null;
    CmService cmService = null;
    private Thread thread;

    public TechnicianPresentStatus(Operable operable) {
        this.operable = operable;
        this.technicianPresentAttributeListeners = new ArrayList<TechnicianPresentStatusListener>();
        this.init();
    }

    private void init() {
        this.cmService = this.operable.getCvSession().getNealManager().getCmService();
        this.nodeBFunctionLdn = this.operable.getTargetMoLdnForTechnicianPresent();
        if (this.nodeBFunctionLdn != null) {
            this.nodeBFunctionMo = this.cmService.getMo(this.nodeBFunctionLdn);
        }
        this.startThread();
    }

    protected void startThread() {
        Trace.observation(this, "About to start polling thread for tp");
        TechnicianPresentStatus technicianPresentStatus = this;
        if (!this.collectTechnicianPresentStatusStarted) {
            this.thread = new Thread(technicianPresentStatus);
            this.thread.start();
        } else {
            Trace.observation(this, "Thread already started, no new will be started");
        }
    }

    @Override
    public void run() {
        block2: {
            this.collectTechnicianPresentStatusStarted = true;
            try {
                this.checkTpAttribute();
            }
            catch (Exception exception) {
                String string = "Failed to check technician present attribute";
                if (!this.collectTechnicianPresentStatusStarted) break block2;
                Trace.error(this, string, exception);
                this.showErrorFromThread("Unable to check if technician is present", exception);
                this.collectTechnicianPresentStatusStarted = false;
            }
        }
    }

    private void checkTpAttribute() throws Exception {
        NameValue nameValue = null;
        while (this.collectTechnicianPresentStatusStarted) {
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
                Trace.observation(this, "Was interrupted during sleep", exception);
                break;
            }
            try {
                nameValue = this.nodeBFunctionMo.getAttribute(TECHNICIAN_PRESENT_ATTR, null);
                boolean bl = nameValue.getBooleanValue();
                if (bl == this.savedTpValue) continue;
                this.savedTpValue = bl;
                Trace.observation(this, "The TP value is different from the previous (" + bl + ")");
                this.broadcastTechnicianPresentValue(bl);
            }
            catch (Exception exception) {
                if (NealManager.isCausedByNodeRestarting(exception)) {
                    Trace.warning(this, "Failed to check technician present attribute, but probably due to connection problems/restart");
                    continue;
                }
                throw exception;
            }
        }
        this.collectTechnicianPresentStatusStarted = false;
    }

    public void addTechnicianPresentValueListener(TechnicianPresentStatusListener technicianPresentStatusListener) {
        if (!this.technicianPresentAttributeListeners.contains(technicianPresentStatusListener)) {
            this.technicianPresentAttributeListeners.add(technicianPresentStatusListener);
        }
    }

    public void broadcastTechnicianPresentValue(boolean bl) {
        for (TechnicianPresentStatusListener technicianPresentStatusListener : this.technicianPresentAttributeListeners) {
            technicianPresentStatusListener.technicianPresentValueChanged(bl);
        }
    }

    public void stop() {
        Trace.observation(this, "About to stop TP polling thread");
        this.collectTechnicianPresentStatusStarted = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            Trace.error(this, "Failed to wait for thread termination", interruptedException);
        }
        Trace.observation(this, "TP Polling thread stopped");
    }

    protected void updateSavedTpValue(boolean bl) {
        this.savedTpValue = bl;
    }

    protected void showErrorFromThread(final String string, final Exception exception) {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TechnicianPresentStatus.this.showError(string, exception);
                    }
                });
            } else {
                this.showError(string, exception);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    protected void showError(String string, Exception exception) {
        Trace.error(this, string, exception);
        this.operable.getCvSession().getCvSessionController().showErrorDialog(string, exception);
    }
}

